/* $Id: $
 * This file is part of the SPHERE Pipeline
 * Copyright (C) 2007-2010 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 * $Author: $
 * $Date: $
 * $Revision: $
 * $Name: $
 */

#ifndef SPH_ZPL_KEYWORDS_H_
#define SPH_ZPL_KEYWORDS_H_
/*---------------------------------------------------------------------------*/
/*
 * The keywords and corresponding allowed values for ZPL are
 * defined in this file.
 * Keywords and values common to all SPHERE instruments are
 * defined in the common API under src/Sphere/sph_common_keywords.h
 */
/*---------------------------------------------------------------------------*/
#define SPH_ZPL_KEYWORD_VALUE_DPR_TYPE_BIAS                 "BIAS"
#define SPH_ZPL_KEYWORD_VALUE_DPR_TECH_BIAS                 "IMAGE"
#define SPH_ZPL_KEYWORD_VALUE_DPR_CATG_BIAS                 "CALIB"

#define SPH_ZPL_KEYWORD_VALUE_DPR_TYPE_DARK                   "DARK"
#define SPH_ZPL_KEYWORD_VALUE_DPR_TECH_DARK                   "IMAGE"
#define SPH_ZPL_KEYWORD_VALUE_DPR_CATG_DARK                   "CALIB"

#define SPH_ZPL_KEYWORD_VALUE_DPR_TYPE_IFF                    "FLAT,LAMP"
#define SPH_ZPL_KEYWORD_VALUE_DPR_TECH_IFF                    "IMAGE"
#define SPH_ZPL_KEYWORD_VALUE_DPR_CATG_IFF                    "CALIB"

#define SPH_ZPL_KEYWORD_VALUE_DPR_TYPE_PFF                    "POLFLAT,LAMP"
#define SPH_ZPL_KEYWORD_VALUE_DPR_TECH_PFF                    "IMAGE"
#define SPH_ZPL_KEYWORD_VALUE_DPR_CATG_PFF                    "CALIB"

#define SPH_ZPL_KEYWORD_VALUE_DPR_TYPE_MEFF                    "MODEM,LAMP"
#define SPH_ZPL_KEYWORD_VALUE_DPR_TECH_MEFF                    "IMAGE"
#define SPH_ZPL_KEYWORD_VALUE_DPR_CATG_MEFF                    "CALIB"

#define SPH_ZPL_KEYWORD_VALUE_DPR_TYPE_SCIENCE_P2               "OBJECT"
#define SPH_ZPL_KEYWORD_VALUE_DPR_TECH_SCIENCE_P2              "IMAGE"
#define SPH_ZPL_KEYWORD_VALUE_DPR_CATG_SCIENCE_P2              "SCIENCE P2"

#define SPH_ZPL_KEYWORD_SPLIT                                    "ESO DRS ZPL DPR SPLIT"
#define SPH_ZPL_KEYWORD_VALUE_SPLIT_EVEN                         "EVEN"
#define SPH_ZPL_KEYWORD_VALUE_SPLIT_ODD                         "ODD"

#define SPH_ZPL_KEYWORD_STOKES_PARAM_QPLUS                       "QPLUS"
#define SPH_ZPL_KEYWORD_STOKES_PARAM_QMINUS                      "QMINUS"
#define SPH_ZPL_KEYWORD_STOKES_PARAM_UPLUS                       "UPLUS"
#define SPH_ZPL_KEYWORD_STOKES_PARAM_UMINUS                      "UMINUS"

#define SPH_ZPL_KEYWORD_VALUE_PRO_CATG_PREPROC                      "ESO DRS ZPL PREPROC"
#define SPH_ZPL_KEYWORD_VALUE_PRO_CATG_PREPROC_IMAGING         "ESO DRS ZPL PREPROC IMAGING"

#define SPH_ZPL_KEYWORD_VALUE_PRO_CATG_MASTER_DARK            "ZPL_MASTER_DARK"
#define SPH_ZPL_KEYWORD_VALUE_PRO_CATG_POL_FLAT               "ZPL_MASTER_POL_FLAT"
#define SPH_ZPL_KEYWORD_VALUE_PRO_CATG_MEFF                   "ZPL_MASTER_MODEM_EFF"
#define SPH_ZPL_KEYWORD_VALUE_PRO_CATG_MASTER_FLAT            "ZPL_MASTER_FLAT"
#define SPH_ZPL_KEYWORD_VALUE_PRO_CATG_STATIC_BADPIXELMAP     "ZPL_STATIC_BADPIXELMAP"
#define SPH_ZPL_KEYWORD_VALUE_PRO_CATG_LINEAR_BADPIXELMAP     "ZPL_LINEAR_BADPIXELMAP"
#define SPH_ZPL_KEYWORD_CAMERA_NAME                           "ESO DRS ZPL CAMERA"
#define SPH_ZPL_KEYWORD_CAMERA_ID                               "ESO DRS ZPL CAMERA ID"
#define SPH_ZPL_KEYWORD_DET_CHIP_INDEX                          "ESO DET CHIP INDEX"
#define SPH_ZPL_KEYWORD_FILTER_ID                             "ESO DRS ZPL FILTER ID"
#define SPH_ZPL_KEYWORD_VALUE_CAMERA_INDEFERENT_ID            0
#define SPH_ZPL_KEYWORD_VALUE_CAMERA1_ID                      1
#define SPH_ZPL_KEYWORD_VALUE_CAMERA2_ID                      2
#define SPH_ZPL_KEYWORD_VALUE_FILTER1_ID                      1
#define SPH_ZPL_KEYWORD_VALUE_FILTER2_ID                      2
#define SPH_ZPL_KEYWORD_VALUE_FILTER3_ID                      3
#define SPH_ZPL_KEYWORD_VALUE_FILTER4_ID                      4

#define SPH_ZPL_KEYWORD_DEROTATOR_ANGLE                            "ESO DRS ZPL DEROTATOR ANGLE"
#define SPH_ZPL_KEYWORD_DEROTATOR_FIT_COEFF_A                    "ESO DRS ZPL DEROTATOR FIT COEFF A"
#define SPH_ZPL_KEYWORD_DEROTATOR_FIT_COEFF_B                    "ESO DRS ZPL DEROTATOR FIT COEFF B"
#define SPH_ZPL_KEYWORD_DEROTATOR_FIT_COEFF_C                    "ESO DRS ZPL DEROTATOR FIT COEFF C"
#define SPH_ZPL_KEYWORD_DEROTATOR_FIT_COEFF_D                    "ESO DRS ZPL DEROTATOR FIT COEFF D"
#define SPH_ZPL_KEYWORD_DEROTATOR_FIT_COEFF_E                    "ESO DRS ZPL DEROTATOR FIT COEFF E"
#define SPH_ZPL_KEYWORD_DEROTATOR_FITERR_COEFF_A                "ESO DRS ZPL DEROTATOR FITERR COEFF A"
#define SPH_ZPL_KEYWORD_DEROTATOR_FITERR_COEFF_B                "ESO DRS ZPL DEROTATOR FITERR COEFF B"
#define SPH_ZPL_KEYWORD_DEROTATOR_FITERR_COEFF_C                "ESO DRS ZPL DEROTATOR FITERR COEFF C"
#define SPH_ZPL_KEYWORD_DEROTATOR_FITERR_COEFF_D                "ESO DRS ZPL DEROTATOR FITERR COEFF D"
#define SPH_ZPL_KEYWORD_DEROTATOR_FITERR_COEFF_E                "ESO DRS ZPL DEROTATOR FITERR COEFF E"
#define SPH_ZPL_KEYWORD_DEROTATOR_FITERR_CHISQ_DOF                "ESO DRS ZPL DEROTATOR FITERR CHISQ DOF"

#define SPH_ZPL_POLARIZATION_FLAT_TAG_VALID_SETTINGS          "ZPL_MASTER_PFF_SETTINGS"
#define SPH_ZPL_MODEM_EFFICIENCY_TAG_VALID_SETTINGS              "ZPL_MASTER_MEFF_SETTINGS"

#define SPH_ZPL_KEYWORD_DIT_ID                                  "ESO DRS ZPL DIT ID"

#define SPH_ZPL_KEYWORD_HWPZ_SETTING                           "ESO DRS ZPL HWPZ SETTING"
#define SPH_ZPL_KEYWORD_VALUE_HWPZ_QPLUS                       0.0
#define SPH_ZPL_KEYWORD_VALUE_HWPZ_QMINUS                       45.0
#define SPH_ZPL_KEYWORD_VALUE_HWPZ_UPLUS                       22.5
#define SPH_ZPL_KEYWORD_VALUE_HWPZ_UMINUS                       -22.5

#define SPH_ZPL_KEYWORD_HWP2_SETTING                           "ESO DRS ZPL HWP2 SETTING"
#define SPH_ZPL_KEYWORD_VALUE_HWP2_QPLUS                       0.0
#define SPH_ZPL_KEYWORD_VALUE_HWP2_QMINUS                       45.0
#define SPH_ZPL_KEYWORD_VALUE_HWP2_UPLUS                       22.5
#define SPH_ZPL_KEYWORD_VALUE_HWP2_UMINUS                       67.5
#define SPH_ZPL_KEYWORD_VALUE_HWP2_UMINUS_22_5                  -22.5

#define  SPH_ZPL_KEYWORD_STOCK_PARAMETER_SIGN             "ESO ZPL STOCK PARAMETER SIGN" //Attention: also define in SuperRecipe.py
#define  SPH_ZPL_KEYWORD_STOCK_PARAMETER_NAME            "ESO ZPL STOCK PARAMETER_NAME"
#define  SPH_ZPL_KEYWORD_POL_STOKES_NAME                "ESO OCS3 ZIMPOL POL STOKES"
#define     SPH_ZPL_KEYWORD_VALUE_POL_STOKES_QPLUS            "Qplus"
#define     SPH_ZPL_KEYWORD_VALUE_POL_STOKES_QMINUS        "Qminus"
#define     SPH_ZPL_KEYWORD_VALUE_POL_STOKES_UPLUS            "Uplus"
#define     SPH_ZPL_KEYWORD_VALUE_POL_STOKES_UMINUS        "Uminus"

#define SPH_ZPL_KEYWORD_DET_READ_CURNAME                    "ESO DET READ CURNAME" // Used readout mode name
#define SPH_ZPL_KEYWORD_VALUE_DET_READ_CURNAME              "SlowPolarimetry"
#define SPH_ZPL_KEYWORD_VALUE_DET_READ_SNAPSHOT_IMAGING        "SnapShotImaging"
#define SPH_ZPL_KEYWORD_VALUE_DET_READ_STANDARD_IMAGING        "StandardImaging"
#define SPH_ZPL_KEYWORD_PUPIL_STAB_IMAGING_ANGLE_OFFSET   135.0       //degrees

//degrees HIERARCH ESO INS4 DROT2 POSANG = 180.0000 / Position angle [deg].
//So this can be read from header?
#define SPH_ZPL_KEYWORD_P1_NO_DEROT_ANGLE_OFFSET   180.0

#define SPH_ZPL_KEYWORD_INS4_DROT2_POSANG "ESO INS4 DROT2 POSANG"

#define SPH_ZPL_STAR_CENTER_IFRAME_XCOORD                "ESO DRS ZPL STAR CENTER IFRAME XCOORD"
#define SPH_ZPL_STAR_CENTER_IFRAME_YCOORD                "ESO DRS ZPL STAR CENTER IFRAME YCOORD"
#define SPH_ZPL_STAR_CENTER_PFRAME_XCOORD                "ESO DRS ZPL STAR CENTER PFRAME XCOORD"
#define SPH_ZPL_STAR_CENTER_PFRAME_YCOORD                "ESO DRS ZPL STAR CENTER PFRAME YCOORD"

// KEYWORDS NAME & DEFAULT VALUE FOR ADU-IMAGES LOCATIONS AND PRE-/OVERSCAN INFORMATION
// (presented here only temporarily)

// CAMERA-1
// ADU-1
#define SPH_ZPL_KEYWORD_CAM1_ADU1_X      "ESO DET OUT1 X"  // KEWWORD NAME for X location of output
#define SPH_ZPL_KEYWORD_CAM1_ADU1_Y      "ESO DET OUT1 Y"  // KEWWORD NAME for Y location of output
#define SPH_ZPL_KEYWORD_CAM1_BIN_X        "ESO DET BINX"        // Binning factor along X
#define SPH_ZPL_KEYWORD_CAM1_BIN_Y        "ESO DET BINY"        // Binning factor along Y

#define SPH_ZPL_KEYWORD_CAM1_ADU1_NX      "ESO DET OUT1 NX"  // KEWWORD NAME for output data pixels in X
#define SPH_ZPL_KEYWORD_CAM1_ADU1_NY      "ESO DET OUT1 NY"  // KEWWORD NAME for output data pixels in Y
#define SPH_ZPL_KEYWORD_VALUE_CAM1_ADU1_NX        578                // must be set up here for new data
#define SPH_ZPL_KEYWORD_VALUE_CAM1_ADU1_NY        1024//1076            // must be set up here for new data

#define SPH_ZPL_KEYWORD_CAM1_ADU1_OVSCX      "ESO DET OUT1 OVSCX"  // KEWWORD NAME for output overscan pixels in X
#define SPH_ZPL_KEYWORD_CAM1_ADU1_OVSCY      "ESO DET OUT1 OVSCY"  // KEWWORD NAME output overscan pixels in Y
#define SPH_ZPL_KEYWORD_VALUE_CAM1_ADU1_OVSCX      41  // Default value for output overscan pixels in X
#define SPH_ZPL_KEYWORD_VALUE_CAM1_ADU1_OVSCY      0//51  // Default value for output overscan pixels in Y
#define SPH_ZPL_KEYWORD_CAM1_ADU1_PRSCX      "ESO DET OUT1 PRSCX"  // Output prescan pixels in X
#define SPH_ZPL_KEYWORD_CAM1_ADU1_PRSCY      "ESO DET OUT1 PRSCY"  // Output prerscan pixels in Y
#define SPH_ZPL_KEYWORD_VALUE_CAM1_ADU1_PRSCX      25  // Default value for output prescan pixels in X
#define SPH_ZPL_KEYWORD_VALUE_CAM1_ADU1_PRSCY      0//1  // Default value for output prerscan pixels in Y
// ADU-2
#define SPH_ZPL_KEYWORD_CAM1_ADU2_X      "ESO DET OUT2 X"
#define SPH_ZPL_KEYWORD_CAM1_ADU2_Y      "ESO DET OUT2 Y"

#define SPH_ZPL_KEYWORD_CAM1_ADU2_NX      "ESO DET OUT2 NX"
#define SPH_ZPL_KEYWORD_CAM1_ADU2_NY      "ESO DET OUT2 NY"
#define SPH_ZPL_KEYWORD_VALUE_CAM1_ADU2_NX        578                // must be set up here for new data
#define SPH_ZPL_KEYWORD_VALUE_CAM1_ADU2_NY        1024// 1076            // must be set up here for new data
#define SPH_ZPL_KEYWORD_VALUE_CAM1_ADU2_X      579  // Test value for ADU2 because of the error in the header
#define SPH_ZPL_KEYWORD_CAM1_ADU2_OVSCX      "ESO DET OUT2 OVSCX"  // Output overscan pixels in X
#define SPH_ZPL_KEYWORD_CAM1_ADU2_OVSCY      "ESO DET OUT2 OVSCY"  // Output overscan pixels in Y
#define SPH_ZPL_KEYWORD_VALUE_CAM1_ADU2_OVSCX      25  // Default value for output overscan pixels in X
#define SPH_ZPL_KEYWORD_VALUE_CAM1_ADU2_OVSCY      0// 51  // Default value for output overscan pixels in X
#define SPH_ZPL_KEYWORD_CAM1_ADU2_PRSCX      "ESO DET OUT2 PRSCX"  // Output prescan pixels in X
#define SPH_ZPL_KEYWORD_CAM1_ADU2_PRSCY      "ESO DET OUT2 PRSCY"  // Output prerscan pixels in Y
#define SPH_ZPL_KEYWORD_VALUE_CAM1_ADU2_PRSCX      41   // Default value for output prescan pixels in X
#define SPH_ZPL_KEYWORD_VALUE_CAM1_ADU2_PRSCY      0//1  // Default value for output prerscan pixels in Y
// CAMERA-2
// ADU-1
#define SPH_ZPL_KEYWORD_CAM2_BIN_X        "ESO DET BINX"        // Binning factor along X
#define SPH_ZPL_KEYWORD_CAM2_BIN_Y        "ESO DET BINY"        // Binning factor along Y

#define SPH_ZPL_KEYWORD_CAM2_ADU1_X      "ESO DET OUT1 X"  // KEWWORD NAME for X location of output
#define SPH_ZPL_KEYWORD_CAM2_ADU1_Y      "ESO DET OUT1 Y"  // KEWWORD NAME for Y location of output
#define SPH_ZPL_KEYWORD_CAM2_ADU1_NX      "ESO DET OUT1 NX"  // KEWWORD NAME for output data pixels in X
#define SPH_ZPL_KEYWORD_CAM2_ADU1_NY      "ESO DET OUT1 NY"  // KEWWORD NAME for output data pixels in Y
#define SPH_ZPL_KEYWORD_VALUE_CAM2_ADU1_NX        578                // must be set up here for new data
#define SPH_ZPL_KEYWORD_VALUE_CAM2_ADU1_NY        1024//1076            // must be set up here for new data

#define SPH_ZPL_KEYWORD_CAM2_ADU1_OVSCX      "ESO DET OUT1 OVSCX"  // KEWWORD NAME for output overscan pixels in X
#define SPH_ZPL_KEYWORD_CAM2_ADU1_OVSCY      "ESO DET OUT1 OVSCY"  // KEWWORD NAME output overscan pixels in Y
#define SPH_ZPL_KEYWORD_VALUE_CAM2_ADU1_OVSCX      41  // Default value for output overscan pixels in X
#define SPH_ZPL_KEYWORD_VALUE_CAM2_ADU1_OVSCY      0 //51  // Default value for output overscan pixels in X
#define SPH_ZPL_KEYWORD_CAM2_ADU1_PRSCX      "ESO DET OUT1 PRSCX"  // Output prescan pixels in X
#define SPH_ZPL_KEYWORD_CAM2_ADU1_PRSCY      "ESO DET OUT1 PRSCY"  // Output prerscan pixels in Y
#define SPH_ZPL_KEYWORD_VALUE_CAM2_ADU1_PRSCX      25  // Default value for output prescan pixels in X
#define SPH_ZPL_KEYWORD_VALUE_CAM2_ADU1_PRSCY      0 //1  // Default value for output prerscan pixels in Y
// ADU-2
#define SPH_ZPL_KEYWORD_CAM2_ADU2_X      "ESO DET OUT2 X"
#define SPH_ZPL_KEYWORD_CAM2_ADU2_Y      "ESO DET OUT2 Y"

#define SPH_ZPL_KEYWORD_CAM2_ADU2_NX      "ESO DET OUT2 NX"
#define SPH_ZPL_KEYWORD_CAM2_ADU2_NY      "ESO DET OUT2 NY"
#define SPH_ZPL_KEYWORD_VALUE_CAM2_ADU2_NX        578                // must be set up here for new data
#define SPH_ZPL_KEYWORD_VALUE_CAM2_ADU2_NY        1024//1076            // must be set up here for new data
#define SPH_ZPL_KEYWORD_VALUE_CAM2_ADU2_X      579  // Test value for ADU2 because of the error in the header
#define SPH_ZPL_KEYWORD_CAM2_ADU2_OVSCX      "ESO DET OUT2 OVSCX"  // Output overscan pixels in X
#define SPH_ZPL_KEYWORD_CAM2_ADU2_OVSCY      "ESO DET OUT2 OVSCY"  // Output overscan pixels in Y
#define SPH_ZPL_KEYWORD_VALUE_CAM2_ADU2_OVSCX      25  // Default value for output overscan pixels in X
#define SPH_ZPL_KEYWORD_VALUE_CAM2_ADU2_OVSCY      0//51  // Default value for output overscan pixels in X
#define SPH_ZPL_KEYWORD_CAM2_ADU2_PRSCX      "ESO DET OUT2 PRSCX"  // Output prescan pixels in X
#define SPH_ZPL_KEYWORD_CAM2_ADU2_PRSCY      "ESO DET OUT2 PRSCY"  // Output prerscan pixels in Y
#define SPH_ZPL_KEYWORD_VALUE_CAM2_ADU2_PRSCX      41  // Default value for output prescan pixels in X
#define SPH_ZPL_KEYWORD_VALUE_CAM2_ADU2_PRSCY      0 //1  // Default value for output prerscan pixels in Y


#define SPH_ZPL_KEYWORD_ESO_QC_POL_U "ESO QC POL U"
#define SPH_ZPL_KEYWORD_ESO_QC_POL_Q "ESO QC POL Q"
#define SPH_ZPL_KEYWORD_ESO_QC_POL_P "ESO QC POL P"
#define SPH_ZPL_KEYWORD_ESO_QC_POL_THETA "ESO QC POL THETA"
#define SPH_ZPL_KEYWORD_ESO_QC_POL_P_OFFSET "ESO QC POL P OFFSET"
#define SPH_ZPL_KEYWORD_ESO_QC_POL_THETA_OFFSET "ESO QC POL THETA OFFSET"

#endif /* SPH_ZPL_KEYWORDS_H_ */
