/***********************************************************************************************/
/******** DANGER !! DANGER !! DANGER !! DO NOT EDIT FILE -- IT WAS GENERATED AUTOMATICALLY !!! */
/***********************************************************************************************/

/* $Id: $
 * This file is part of the SPHERE Pipeline
 * Copyright (C) 2007-2010 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 * $Author: $
 * $Date: $
 * $Revision: $
 * $Name: $
 */

/*-----------------------------------------------------------------------------
 Includes
 -----------------------------------------------------------------------------*/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "sph_zpl_master_dark_imaging.h"
#include "sph_common_keywords.h"
#include "sph_zpl_keywords.h"
#include "sph_zpl_tags.h"
#include "sph_master_frame.h"
#include "sph_error.h"
#include "sph_cube.h"
#include "sph_utils.h"

#include <math.h>
#include <assert.h>
#include <cpl.h>

/*-----------------------------------------------------------------------------
  Error Codes
 -----------------------------------------------------------------------------*/

sph_error_code SPH_ZPL_MASTER_DARK_IMAGING_GENERAL              = SPH_ZPL_MASTER_DARK_IMAGING_ERR_START + 0;
sph_error_code SPH_ZPL_MASTER_DARK_IMAGING_NO_VALID_DIT_LIST    = SPH_ZPL_MASTER_DARK_IMAGING_ERR_START + 1;

sph_error_code SPH_ZPL_MASTER_DARK_IMAGING_PARAMETER_MISSING    = SPH_ZPL_MASTER_DARK_IMAGING_ERR_START + 3;
sph_error_code SPH_ZPL_MASTER_DARK_IMAGING_FRAMES_MISSING       = SPH_ZPL_MASTER_DARK_IMAGING_ERR_START + 4;

/*-----------------------------------------------------------------------------
 Private function prototypes
 -----------------------------------------------------------------------------*/

static int sph_zpl_master_dark_imaging_create_plugin ( cpl_plugin * );
static int sph_zpl_master_dark_imaging_exec_plugin ( cpl_plugin * );
static int sph_zpl_master_dark_imaging_destroy_plugin ( cpl_plugin * );

/*-----------------------------------------------------------------------------
 Static variables
 -----------------------------------------------------------------------------*/

static const char* sph_zpl_master_dark_imaging_help = 
    "RECIPE INPUT FRAMES: \n"
    "-------------------- \n"
    "Tag                           Min,Max   Description\n"
    "ZPL_DARK_IMAGING_RAW            0, -1   I. NEW STYLE (split format) -- The raw frames in the imaging mode with a primary HDU and image:\n"
    "                                        - represents data cube of NDITS frames from camera-1/2 for a given DIT, including prescan/overscan area of 2 ADUs.\n"
    "                                        II. OLD STYLE -- The raw frames in the image mode with the two extensions  fits file format:\n"
    "                                        - first extension represents data cube of NDITS frames from camera-1 for a given DIT, including prescan/overscan area of 2 ADUs;\n"
    "                                        - second extension represents data cube of NDITS zimpol frames from camera-2 for a given DIT, including prescan/overscan area of 2 ADUs\n"
    "ZPL_DARK_IMAGING_PREPROC        0, -1   The pre-processed raw dark frames, imaging mode.\n"
    "                                        Format: ZPL EXP IMAGING = FITS[Im(2),Bt(1)]\n"
    "ZPL_DARK_IMAGING_PREPROC_CAM1   0, -1   The pre-processed raw dark frames, imaging mode.\n"
    "                                        Format: ZPL EXP IMAGING = FITS[Im(2),Bt(1)]\n"
    "ZPL_DARK_IMAGING_PREPROC_CAM2   0, -1   The pre-processed raw dark frames, imaging mode.\n"
    "                                        Format: ZPL EXP IMAGING = FITS[Im(2),Bt(1)]\n"
    "ZPL_MASTER_BIAS_IMAGING         0,  1   The master bias frame, imaging mode. Should have readout mode as the pre-processed dark imaging frames.\n"
    "                                        Format: DOUBLE IMAGE = FITS[Im(8)]\n"
    "ZPL_MASTER_BIAS_IMAGING_CAM1    0,  1   The master bias frame, imaging mode. Should have readout mode as the pre-processed dark imaging frames.\n"
    "                                        Format: DOUBLE IMAGE = FITS[Im(8)]\n"
    "ZPL_MASTER_BIAS_IMAGING_CAM2    0,  1   The master bias frame, imaging mode. Should have readout mode as the pre-processed dark imaging frames.\n"
    "                                        Format: DOUBLE IMAGE = FITS[Im(8)]\n"
    "\n"
    "RAW FRAME KEYWORDS: \n"
    "-------------------- \n"
    "Keyword                       Type   Optional  Description\n"
    "ESO DRS PC PROD TYPE          string No        This keyword is mandatory if pre-processed data are used. \n"
    "                                               As the format of the zimpol data is complicated, this keyword is introduced in order \n"
    "                                               to garantee that the input frames are imaging pre-processed data, \n"
    "                                               produced by the sph_zpl_preproc recipe which added this keyword automatically. \n"
    "                                               The value of this keyword is set up to >>SPH PC PREPROC ZPL EXP IMAGING<<. \n"
    "                                                              \n"
    "                                               Note: if raw data are used (default), then all keywords needed for the pre-processing recipe \n"
    "                                               (see sph_zpl_preproc_imaging) must be presented in the raw data. \n"
    "\n"
    "DESCRIPTION:\n"
    "------------\n"
    "This recipe creates master dark calibration frames for the imaging modes.\n"
    "\n"
    "The input frames might be either dark raw frames with the ZPL_DARK_IMAGING_RAW tag or pre-processed dark frames,\n"
    "which should carry the ZPL_DARK_IMAGING_PREPROC_CAM1 and/or ZPL_DARK_IMAGING_PREPROC_CAM2 tags, and master bias frames (if any) with the\n"
    "ZPL_MASTER_BIAS_IMAGING_CAM1 and/or ZPL_MASTER_BIAS_IMAGING_CAM2 tags.\n"
    "If input frames are raw frames then the master dark recipe first performs the pre-processing step for all input frames (raw cubes),\n"
    "creating corresponding pre-processed frames (cubes) for both ZIMPOL cameras (see also sph_zpl_preproc_imaging\n"
    "for the detailed description of the pre-processing step).\n"
    "\n"
    "The master imaging dark for each camera is then created by combining pre-processed frames (= all planes)\n"
    "from imaging pre-processed cube(s) using a specified collapse algorithm (usually the clean_mean algorithm, defined as a default one).\n"
    "If the flag >>subtract_overscan<< is not set up to 0, the recipe subtracts (before combining) the overscan bias level\n"
    "from the pre-pocessed cube(s) individually for each plane. Otherwise, the overscan subtraction step is skipped.\n"
    "(The overscan bias level -- >>ADU1 mean overscan value<< from the left area of the image and  >>ADU2 mean overscan value<<\n"
    "from the right area of the image -- for odd and even sub-frames are saved anyway as a binary table in the imaging\n"
    "pre-processed cube(s)).\n"
    "\n"
    "After all pre-processed frames (all 2 zimpol imaging exposure sub-frames) are combined in this way,\n"
    "the badpixel maps are determined on the results, using a simple sigma clipping algorithm.\n"
    "It sets the bad/hot pixels to be all those that are further than the\n"
    ">>specified sigma x the total RMS<< of the whole image away from the image median.\n"
    "\n"
    "\n"
    "The resulting master dark imaging frames for both cameras are subtracted\n"
    "by the corresponding master bias imaging calibrations and written out in the DOUBLE IMAGE (8 extensions)\n"
    "format specified as follows:\n"
    "\n"
    "1.  odd sub-frame (informative component):\n"
    "\n"
    "    -   master dark image,\n"
    "\n"
    "    -   badpixel-map,\n"
    "\n"
    "    -   ncomb-map,\n"
    "\n"
    "    -   rms-map;\n"
    "\n"
    "2.  even sub-frame (dark current component):\n"
    "\n"
    "    -   master dark image,\n"
    "\n"
    "    -   badpixel-map,\n"
    "\n"
    "    -   ncomb-map,\n"
    "\n"
    "    -   rms-map.\n"
    "\n"
    "\n"
    "\n"
    "\n"
    "The master imaging dark products are used in the all subsequent imaging recipes.\n"
    "RECIPE PRODUCTS: \n"
    "-------------------- \n"
    "Tag                      Format         Description\n"
    "ZPL_MASTER_DARK_IMAGING            FITS[Im(8)]    The resulting master dark frame is of the DOUBLE IMAGE format.\n"
    "                                        This frame contains 8 image extensions (2 master frames), grouped by the following order:\n"
    "                                        - odd sub-frame master dark image (informative), badpixel-map, ncomb-map and rms-map;\n"
    "                                        - even sub-frame  master dark image (dark current), badpixel-map, rms-map and rms-map.\n"
    "ZPL_MASTER_DARK_IMAGING_CAM1       FITS[Im(8)]    The resulting master dark frame is of the DOUBLE IMAGE format.\n"
    "                                        This frame contains 8 image extensions (2 master frames), grouped by the following order:\n"
    "                                        - odd sub-frame master dark image (informative), badpixel-map, ncomb-map and rms-map;\n"
    "                                        - even sub-frame  master dark image (dark current), badpixel-map, rms-map and rms-map.\n"
    "ZPL_MASTER_DARK_IMAGING_CAM2       FITS[Im(8)]    The resulting master dark frame is of the DOUBLE IMAGE format.\n"
    "                                        This frame contains 8 image extensions (2 master frames), grouped by the following order:\n"
    "                                        - odd sub-frame master dark image (informative), badpixel-map, ncomb-map and rms-map;\n"
    "                                        - even sub-frame  master dark image (dark current), badpixel-map, ncomb-map and rms-map.\n"
    "\n"
    "PRODUCT FRAME KEYWORDS: \n"
    "-------------------- \n"
    "Keyword                       Frame          Type    Description\n"
    "\n"
;

/*-----------------------------------------------------------------------------
 Function code
 -----------------------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/
/**
 * @defgroup sph_zpl_master_dark_imaging Create Master Dark Recipe
 *
 * This module provides the recipe plugin and relating functions for the
 * creation of the master dark .
 *
 * @par Synopsis:
 * @code
 *   #include "sph_zpl_master_dark_imaging.h"
 * @endcode
 */
/*----------------------------------------------------------------------------*/
/**@{*/

/*****************************************************************************
 *
 *
 *      First come the static and global functions necessary for the
 *      normal working of the recipe as plugin....
 *
 *
 * ***************************************************************************/
/*----------------------------------------------------------------------------*/
/**
 @brief    Build the list of available plugins, for this module.
 @param    list    the plugin list
 @return   0 if everything is ok, 1 otherwise
 @note     Only this function is exported

 Create the recipe instance and make it available to the application
 using the interface.
 */
/*----------------------------------------------------------------------------*/
int cpl_plugin_get_info(cpl_pluginlist * list)
{
    cpl_recipe * recipe = cpl_calloc( 1, sizeof *recipe);
    cpl_plugin * plugin = &recipe->interface;

    if (cpl_plugin_init(plugin,
                        CPL_PLUGIN_API,
                        SPH_ZPL_MASTER_DARK_IMAGING_VERSION,
                        CPL_PLUGIN_TYPE_RECIPE,
                        "sph_zpl_master_dark_imaging",
                        "Create master dark, imaging mode.",
                        sph_zpl_master_dark_imaging_help, "Alexey Pavlov <pavlov@mpia-hd.mpg.de>",
                        "https://support.eso.org", cpl_get_license("SPHERE DRH","2012"),
                        sph_zpl_master_dark_imaging_create_plugin,
                        sph_zpl_master_dark_imaging_exec_plugin,
                        sph_zpl_master_dark_imaging_destroy_plugin) )
    {
        cpl_msg_error( cpl_func, "Plugin initialization failed");
        (void)cpl_error_set_where( cpl_func );
        return 1;
    }

    if (cpl_pluginlist_append(list, plugin) )
    {
        cpl_msg_error( cpl_func, "Error adding plugin to list");
        (void)cpl_error_set_where( cpl_func );
        return 1;
    }
    return 0;
}

/*----------------------------------------------------------------------------*/
/**
 @brief    Setup the recipe options
 @param    plugin  the plugin
 @return   0 if everything is ok

 Defining the command-line/configuration parameters for the recipe.
 */
/*----------------------------------------------------------------------------*/
static int sph_zpl_master_dark_imaging_create_plugin(cpl_plugin * plugin)
{
    if (cpl_error_get_code() != CPL_ERROR_NONE)
    {
        cpl_msg_error( cpl_func, "%s():%d: An error is already set: %s",
                       cpl_func, __LINE__, cpl_error_get_where());
        return (int)cpl_error_get_code();
    }

    if (plugin == NULL)
    {
        cpl_msg_error(cpl_func, "Null plugin");
        cpl_ensure_code(0, (int)CPL_ERROR_NULL_INPUT);
    }

    if (cpl_plugin_get_type(plugin) != CPL_PLUGIN_TYPE_RECIPE)
    {
        cpl_msg_error( cpl_func, "Plugin is not a recipe");
        cpl_ensure_code( 0, (int)CPL_ERROR_TYPE_MISMATCH );
    }

    if ( plugin != NULL ) {
        cpl_recipe * recipe = (cpl_recipe *)plugin;
        recipe->parameters = sph_zpl_master_dark_imaging_create_paramlist();
        if ( recipe->parameters == NULL ) {
            return SPH_ZPL_MASTER_DARK_IMAGING_GENERAL;
        }
    }
    return 0;
}

/*----------------------------------------------------------------------------*/
/**
 @brief    Testing for setup of the recipe options
 @param    plugin  the plugin
 @return   0 if everything is ok

 Wrapper to make the static plugin creation function accessible from outside
 for testing purposes.
 */
/*----------------------------------------------------------------------------*/
int sph_zpl_master_dark_imaging_create_test(cpl_plugin * plugin)
{
    return (int)sph_zpl_master_dark_imaging_create_plugin(plugin);
}

/*----------------------------------------------------------------------------*/
/**
 @brief    Execute the plugin instance given by the interface
 @param    plugin  the plugin
 @return   0 if everything is ok
 */
/*----------------------------------------------------------------------------*/
static int sph_zpl_master_dark_imaging_exec_plugin(cpl_plugin * plugin)
{

    cpl_recipe*             recipe                  = NULL;
    cpl_error_code          recipe_code;
    sph_zpl_master_dark_imaging*    sph_recipe      = NULL;
    cpl_errorstate          initial_errorstate      = cpl_errorstate_get();

    if (cpl_error_get_code() != CPL_ERROR_NONE)
    {
        cpl_msg_error( cpl_func, "%s():%d: A cpl error is already set: %s",
        cpl_func, __LINE__, cpl_error_get_where());
        return (int)cpl_error_get_code();
    }

    if (plugin == NULL)
    {
        cpl_msg_error( cpl_func, "Null plugin");
        cpl_ensure_code( 0, (int)CPL_ERROR_NULL_INPUT );
        return (int)cpl_error_get_code();
    }

    if (cpl_plugin_get_type(plugin) != CPL_PLUGIN_TYPE_RECIPE)
    {
        cpl_msg_error( cpl_func, "Plugin is not a recipe");
        cpl_ensure_code( 0, (int)CPL_ERROR_TYPE_MISMATCH );
        return (int)cpl_error_get_code();
    }

    recipe = (cpl_recipe *)plugin;

    if (recipe->parameters == NULL)
    {
        cpl_msg_error( cpl_func, "Recipe invoked with NULL parameter list");
        cpl_ensure_code( 0, (int)CPL_ERROR_NULL_INPUT );
        return (int)cpl_error_get_code();
    }

    if (recipe->frames == NULL)
    {
        cpl_msg_error( cpl_func, "Recipe invoked with NULL frame set");
        cpl_ensure_code( 0, (int)CPL_ERROR_NULL_INPUT );
        return (int)cpl_error_get_code();
    }

    sph_recipe = sph_zpl_master_dark_imaging_new( recipe->frames, recipe->parameters );
    if ( sph_recipe == NULL ) {
        recipe_code = cpl_error_set_where(cpl_func);
    } else {

        recipe_code = sph_zpl_master_dark_imaging_run( sph_recipe );

        sph_zpl_master_dark_imaging_delete( sph_recipe );
    }

    if ( !cpl_errorstate_is_equal(initial_errorstate) )
    {
        cpl_errorstate_dump(initial_errorstate, CPL_FALSE, NULL);
    }
    sph_end_erex(); //close the sphere system
    return (int)(recipe_code >= CPL_ERROR_EOL /* Workaround esorex PIPE-6887 */
                 ? CPL_ERROR_EOL : recipe_code);
}

/*----------------------------------------------------------------------------*/
/**
 @brief    Destroy what has been created by the 'create' function
 @param    plugin  the plugin
 @return   0 if everything is ok
 */
/*----------------------------------------------------------------------------*/
static int sph_zpl_master_dark_imaging_destroy_plugin(cpl_plugin * plugin)
{
    cpl_recipe * recipe;

    if (plugin == NULL)
    {
        cpl_msg_error( cpl_func, "Null plugin");
        cpl_ensure_code( 0, (int)CPL_ERROR_NULL_INPUT );
    }

    if (cpl_plugin_get_type(plugin) != CPL_PLUGIN_TYPE_RECIPE)
    {
        cpl_msg_error( cpl_func, "Plugin is not a recipe");
        cpl_ensure_code( 0, (int)CPL_ERROR_TYPE_MISMATCH );
    }

    recipe = (cpl_recipe *)plugin;

    cpl_parameterlist_delete(recipe->parameters);

    return 0;
}

/*****************************************************************************
 *
 *
 *      Here come the "Member" functions of the sph_zpl_master_dark_imaging struct
 *
 *
 * ***************************************************************************/

/*----------------------------------------------------------------------------*/
/**
 @brief    Fill a pre-allocated parameterlist for the recipe
 @param    result A pre-allocated parameterlist
 @return   CPL_ERROR_NONE iff successful

 This function fills the standard parameterlist for the recipe

 */
/*----------------------------------------------------------------------------*/
static cpl_error_code sph_zpl_master_dark_imaging_fill_parameterlist(cpl_parameterlist * result)
{
    cpl_parameter* p;

        /* Code to set up parameters GENERATED DO NOT EDIT */

        p = cpl_parameter_new_value("zpl.master_dark_imaging.outfilename",
                                   CPL_TYPE_STRING,
                                   "The output filename for the product for the camera-1/2. Please also see the esorex documentation "
                                   "for naming of output products. "
                                   ,"zpl.master_dark_imaging",
                                   "zpl_master_dark_imaging.fits" );

        cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
        cpl_parameterlist_append(result, p);
        p = cpl_parameter_new_value("zpl.master_dark_imaging.outfilename_cam1",
                                   CPL_TYPE_STRING,
                                   "The output filename for the product for the camera-1. Please also see the esorex documentation "
                                   "for naming of output products. "
                                   ,"zpl.master_dark_imaging",
                                   "zpl_master_dark_imaging_cam1.fits" );

        cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
        cpl_parameterlist_append(result, p);
        p = cpl_parameter_new_value("zpl.master_dark_imaging.outfilename_cam2",
                                   CPL_TYPE_STRING,
                                   "The output filename for the product for the camera-2. Please also see the esorex documentation "
                                   "for naming of output products. "
                                   ,"zpl.master_dark_imaging",
                                   "zpl_master_dark_imaging_cam2.fits" );

        cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
        cpl_parameterlist_append(result, p);
        p = cpl_parameter_new_value("zpl.master_dark_imaging.subtract_overscan",
                                   CPL_TYPE_BOOL,
                                   "Flag to set if the overscan mean values must be subtracted from pre-processed data (TRUE) "
                                   "Note that this parameter is applied if pre-processed data containt overscan table "
                                   ,"zpl.master_dark_imaging",
                                   1 );

        cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
        cpl_parameterlist_append(result, p);
        p = cpl_parameter_new_enum("zpl.master_dark_imaging.coll_alg",
                                   CPL_TYPE_INT,
                                   "Set the collapse algorithm. The available algorithms: 0 = Mean, 1 = Median, 2 = Clean Mean. Default is 2 = Clean Mean "
                                   ,"zpl.master_dark_imaging",
                                   2 ,
                                   3,0,1,2);

        cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
        cpl_parameterlist_append(result, p);
        p = cpl_parameter_new_range("zpl.master_dark_imaging.coll_alg.clean_mean.reject_high",
                                   CPL_TYPE_INT,
                                   "The number of pixels to reject when combining frames at the high end. Number of input frames must be > reject_high +reject_low "
                                   ,"zpl.master_dark_imaging",
                                   0 ,
                                   0,20);

        cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
        cpl_parameterlist_append(result, p);
        p = cpl_parameter_new_range("zpl.master_dark_imaging.coll_alg.clean_mean.reject_low",
                                   CPL_TYPE_INT,
                                   "The number of pixels to reject when combining frames at the low end. Number of input frames must be > reject_high +reject_low "
                                   ,"zpl.master_dark_imaging",
                                   0 ,
                                   0,20);

        cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
        cpl_parameterlist_append(result, p);
        p = cpl_parameter_new_range("zpl.master_dark_imaging.clean_mean.sigma",
                                   CPL_TYPE_DOUBLE,
                                   "The number of pixels to reject when combining frames in sigma from median. NOT SUPPORTED YET! "
                                   ,"zpl.master_dark_imaging",
                                   5.0 ,
                                   0.0,200.0);

        cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
        cpl_parameterlist_append(result, p);
        p = cpl_parameter_new_range("zpl.master_dark_imaging.sigma_clip",
                                   CPL_TYPE_DOUBLE,
                                   "The sigma clipping value for static badpixel detection. Default is 0 (=inf). "
                                   ,"zpl.master_dark_imaging",
                                   0.0 ,
                                   0.0,200.0);

        cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
        cpl_parameterlist_append(result, p);
        p = cpl_parameter_new_value("zpl.master_dark_imaging.keep_intermediate",
                                   CPL_TYPE_BOOL,
                                   "Flag to set if intermediate date must be saved, namely pre-processed and overscan pre-processed subtracted data "
                                   ,"zpl.master_dark_imaging",
                                   0 );

        cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
        cpl_parameterlist_append(result, p);
        p = cpl_parameter_new_value("zpl.preproc.outfilename_cam1",
                                   CPL_TYPE_STRING,
                                   "The postfix-  of the intermediate filename of the pre-processed raw data for the CAMERA-1. "
                                   ,"zpl.preproc",
                                   "preproc_cam1.fits" );

        cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
        cpl_parameterlist_append(result, p);
        p = cpl_parameter_new_value("zpl.preproc.outfilename_cam2",
                                   CPL_TYPE_STRING,
                                   "The postfix- of the  intermediate filename of the pre-processed raw data for the CAMERA-2. "
                                   ,"zpl.preproc",
                                   "preproc_cam2.fits" );

        cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
        cpl_parameterlist_append(result, p);
        /* End of code to set up parameters BUT ITS STILL NOT SAFE TO EDIT! FILE IS GENERATED !*/

    return cpl_error_set_where(cpl_func);
}
/*----------------------------------------------------------------------------*/
/**
 @brief  Create and return the standard parameterlist for the recipe
 @return The standard parameterlist or NULL on error
 @note   The returned object must be deallocated using cpl_parameterlist_delete

 */
/*----------------------------------------------------------------------------*/
cpl_parameterlist* sph_zpl_master_dark_imaging_create_paramlist(void)
{
    cpl_parameterlist* self = cpl_parameterlist_new();

    if (sph_zpl_master_dark_imaging_fill_parameterlist(self)) {
        cpl_parameterlist_delete(self);
        self = NULL;
        (void)cpl_error_set_where(cpl_func);
    }

    return self;
}

/*----------------------------------------------------------------------------*/
/**
 @brief    Check the recipe frames, and assign them to the sph_zpl_master_dark_imaging
           structure.
 @param    self     the sph_zpl_master_dark_imaging recipe structure
 @return   error code of the check.

 This checks the frames that were given in the sph_zpl_master_dark_imaging_new function
 as parameters for the correctness and completeness. If the frames needed are
 found they are also assigned to the corresponding structure members.

 The return value is the error code of the check.
 */
/*----------------------------------------------------------------------------*/
sph_error_code  sph_zpl_master_dark_imaging_check_frames( sph_zpl_master_dark_imaging* self )
{
    sph_error_code           rerr            = CPL_ERROR_NONE;
    /* Code to check frames GENERATED DO NOT EDIT */

    cpl_frame* aframe;
    aframe = cpl_frameset_find( self->inframes, SPH_ZPL_TAG_DARK_IMAGING_RAW );
    while ( aframe ) {
        cpl_frame_set_group( aframe, CPL_FRAME_GROUP_RAW );
        aframe = cpl_frameset_find( self->inframes, NULL );
    }
    self->rawframes = sph_utils_extract_frames( self->inframes, SPH_ZPL_TAG_DARK_IMAGING_RAW );
    if ( ! self->rawframes )
    {
        sph_error_raise( SPH_ZPL_MASTER_DARK_IMAGING_FRAMES_MISSING,
                         __FILE__, __func__, __LINE__ ,
                         SPH_ERROR_INFO,
                         "Could not extract rawframes frames."
                         "Since this is an optional frame, this is ok "
                         "and this message is just informational. If you intended, "
                         "to use them check that they have the %s tag.",
                         SPH_ZPL_TAG_DARK_IMAGING_RAW);
        cpl_error_reset();
    }

    else {

         int numframes = (int)cpl_frameset_get_size( self->rawframes );
         for ( int ii = 0; ii < numframes; ++ii ) {
             cpl_frame* iframe = cpl_frameset_get_position( self->rawframes, ii );
             const char* ifname = cpl_frame_get_filename(iframe);
             cpl_propertylist* pl = cpl_propertylist_load(ifname, 0);
             if (pl == NULL ) {
                 sph_error_raise(cpl_error_get_code(),
                    __FILE__, __func__, __LINE__ ,SPH_ERROR_ERROR,
                 "Could not read keywords from file %s. "
                 "Either the file is not readable or corrupted. ",
                  ifname);
             }
             else {
                 rerr = cpl_frame_set_group( iframe, CPL_FRAME_GROUP_RAW );
                 int haskey, okval;
                 haskey = 0;okval = 0;
                 if ( cpl_propertylist_has(pl,"ESO DRS PC PROD TYPE") )  {
                     haskey = 1;
                     if ( cpl_propertylist_get_type(pl,"ESO DRS PC PROD TYPE") == CPL_TYPE_STRING )  {
                         okval = 1; //Type is string so always ok
                     } 
                     if ( haskey == 0 || okval == 0 ) {
                         sph_error_raise(CPL_ERROR_ILLEGAL_INPUT,
                            __FILE__, __func__, __LINE__ ,SPH_ERROR_ERROR,
                         "Could not read a keyword ESO DRS PC PROD TYPE from file %s. "
                         "that has __type string "
                         "and values between 0.0 and 0.0 "
                         "The recipe requires this. ",
                         ifname);
                     }
                 }
                 cpl_propertylist_delete(pl); pl=NULL;
             }
         }
         numframes -= (int)cpl_frameset_get_size( self->rawframes );
         assert( numframes == 0);
    }

    aframe = cpl_frameset_find( self->inframes, SPH_ZPL_TAG_DARK_IMAGING_PREPROC_RAW );
    while ( aframe ) {
        cpl_frame_set_group( aframe, CPL_FRAME_GROUP_CALIB );
        aframe = cpl_frameset_find( self->inframes, NULL );
    }
    self->preproc_frames = sph_utils_extract_frames( self->inframes, SPH_ZPL_TAG_DARK_IMAGING_PREPROC_RAW );
    if ( ! self->preproc_frames )
    {
        sph_error_raise( SPH_ZPL_MASTER_DARK_IMAGING_FRAMES_MISSING,
                         __FILE__, __func__, __LINE__ ,
                         SPH_ERROR_INFO,
                         "Could not extract preproc_frames frames."
                         "Since this is an optional frame, this is ok "
                         "and this message is just informational. If you intended, "
                         "to use them check that they have the %s tag.",
                         SPH_ZPL_TAG_DARK_IMAGING_PREPROC_RAW);
        cpl_error_reset();
    }

    else {

         int numframes = (int)cpl_frameset_get_size( self->preproc_frames );
         for ( int ii = 0; ii < numframes; ++ii ) {
         }
         numframes -= (int)cpl_frameset_get_size( self->preproc_frames );
         assert( numframes == 0);
    }

    aframe = cpl_frameset_find( self->inframes, SPH_ZPL_TAG_DARK_IMAGING_PREPROC_CAM1 );
    while ( aframe ) {
        cpl_frame_set_group( aframe, CPL_FRAME_GROUP_CALIB );
        aframe = cpl_frameset_find( self->inframes, NULL );
    }
    self->preproc_frames_cam1 = sph_utils_extract_frames( self->inframes, SPH_ZPL_TAG_DARK_IMAGING_PREPROC_CAM1 );
    if ( ! self->preproc_frames_cam1 )
    {
        sph_error_raise( SPH_ZPL_MASTER_DARK_IMAGING_FRAMES_MISSING,
                         __FILE__, __func__, __LINE__ ,
                         SPH_ERROR_INFO,
                         "Could not extract preproc_frames_cam1 frames."
                         "Since this is an optional frame, this is ok "
                         "and this message is just informational. If you intended, "
                         "to use them check that they have the %s tag.",
                         SPH_ZPL_TAG_DARK_IMAGING_PREPROC_CAM1);
        cpl_error_reset();
    }

    else {

         int numframes = (int)cpl_frameset_get_size( self->preproc_frames_cam1 );
         for ( int ii = 0; ii < numframes; ++ii ) {
         }
         numframes -= (int)cpl_frameset_get_size( self->preproc_frames_cam1 );
         assert( numframes == 0);
    }

    aframe = cpl_frameset_find( self->inframes, SPH_ZPL_TAG_DARK_IMAGING_PREPROC_CAM2 );
    while ( aframe ) {
        cpl_frame_set_group( aframe, CPL_FRAME_GROUP_CALIB );
        aframe = cpl_frameset_find( self->inframes, NULL );
    }
    self->preproc_frames_cam2 = sph_utils_extract_frames( self->inframes, SPH_ZPL_TAG_DARK_IMAGING_PREPROC_CAM2 );
    if ( ! self->preproc_frames_cam2 )
    {
        sph_error_raise( SPH_ZPL_MASTER_DARK_IMAGING_FRAMES_MISSING,
                         __FILE__, __func__, __LINE__ ,
                         SPH_ERROR_INFO,
                         "Could not extract preproc_frames_cam2 frames."
                         "Since this is an optional frame, this is ok "
                         "and this message is just informational. If you intended, "
                         "to use them check that they have the %s tag.",
                         SPH_ZPL_TAG_DARK_IMAGING_PREPROC_CAM2);
        cpl_error_reset();
    }

    else {

         int numframes = (int)cpl_frameset_get_size( self->preproc_frames_cam2 );
         for ( int ii = 0; ii < numframes; ++ii ) {
         }
         numframes -= (int)cpl_frameset_get_size( self->preproc_frames_cam2 );
         assert( numframes == 0);
    }

    aframe = cpl_frameset_find( self->inframes, SPH_ZPL_TAG_BIAS_IMAGING_CALIB );
    while ( aframe ) {
        cpl_frame_set_group( aframe, CPL_FRAME_GROUP_CALIB );
        aframe = cpl_frameset_find( self->inframes, NULL );
    }
    self->master_bias_imaging_frame = sph_utils_extract_frame( self->inframes, SPH_ZPL_TAG_BIAS_IMAGING_CALIB );
    if ( ! self->master_bias_imaging_frame )
    {
        sph_error_raise( SPH_ZPL_MASTER_DARK_IMAGING_FRAMES_MISSING,
                         __FILE__, __func__, __LINE__ ,
                         SPH_ERROR_INFO,
                         "Could not extract master_bias_imaging_frame frames."
                         "Since this is an optional frame, this is ok "
                         "and this message is just informational. If you intended, "
                         "to use them check that they have the %s tag.",
                         SPH_ZPL_TAG_BIAS_IMAGING_CALIB);
        cpl_error_reset();
    }

    else {

         rerr = cpl_frame_set_group( self->master_bias_imaging_frame, CPL_FRAME_GROUP_CALIB );
    }

    aframe = cpl_frameset_find( self->inframes, SPH_ZPL_TAG_BIAS_IMAGING_CALIB_CAM1 );
    while ( aframe ) {
        cpl_frame_set_group( aframe, CPL_FRAME_GROUP_CALIB );
        aframe = cpl_frameset_find( self->inframes, NULL );
    }
    self->master_bias_imaging_frame_cam1 = sph_utils_extract_frame( self->inframes, SPH_ZPL_TAG_BIAS_IMAGING_CALIB_CAM1 );
    if ( ! self->master_bias_imaging_frame_cam1 )
    {
        sph_error_raise( SPH_ZPL_MASTER_DARK_IMAGING_FRAMES_MISSING,
                         __FILE__, __func__, __LINE__ ,
                         SPH_ERROR_INFO,
                         "Could not extract master_bias_imaging_frame_cam1 frames."
                         "Since this is an optional frame, this is ok "
                         "and this message is just informational. If you intended, "
                         "to use them check that they have the %s tag.",
                         SPH_ZPL_TAG_BIAS_IMAGING_CALIB_CAM1);
        cpl_error_reset();
    }

    else {

         rerr = cpl_frame_set_group( self->master_bias_imaging_frame_cam1, CPL_FRAME_GROUP_CALIB );
    }

    aframe = cpl_frameset_find( self->inframes, SPH_ZPL_TAG_BIAS_IMAGING_CALIB_CAM2 );
    while ( aframe ) {
        cpl_frame_set_group( aframe, CPL_FRAME_GROUP_CALIB );
        aframe = cpl_frameset_find( self->inframes, NULL );
    }
    self->master_bias_imaging_frame_cam2 = sph_utils_extract_frame( self->inframes, SPH_ZPL_TAG_BIAS_IMAGING_CALIB_CAM2 );
    if ( ! self->master_bias_imaging_frame_cam2 )
    {
        sph_error_raise( SPH_ZPL_MASTER_DARK_IMAGING_FRAMES_MISSING,
                         __FILE__, __func__, __LINE__ ,
                         SPH_ERROR_INFO,
                         "Could not extract master_bias_imaging_frame_cam2 frames."
                         "Since this is an optional frame, this is ok "
                         "and this message is just informational. If you intended, "
                         "to use them check that they have the %s tag.",
                         SPH_ZPL_TAG_BIAS_IMAGING_CALIB_CAM2);
        cpl_error_reset();
    }

    else {

         rerr = cpl_frame_set_group( self->master_bias_imaging_frame_cam2, CPL_FRAME_GROUP_CALIB );
    }

    /* End of code to check frames BUT ITS STILL NOT SAFE TO EDIT! FILE IS GENERATED !*/
    self->current_raw_frameset = sph_utils_extract_frames_group( self->inframes, CPL_FRAME_GROUP_RAW );

    return rerr;
}

/*----------------------------------------------------------------------------*/
/**
 @brief    Check the recipe parameters, and assign them to the sph_zpl_master_dark_imaging
           structure.
 @param    self     the sph_zpl_master_dark_imaging recipe structure
 @return   error code of the check.

 This checks the parameters that were given in the sph_zpl_master_dark_imaging_new function
 as parameters for the correctness and completeness. If the parameters needed are
 found they are also assigned to the corresponding structure members.

 The return value is the error code of the check.
 */
/*----------------------------------------------------------------------------*/
sph_error_code sph_zpl_master_dark_imaging_check_params( sph_zpl_master_dark_imaging* self ) {
    sph_error_code                 rerr               = CPL_ERROR_NONE;
    const cpl_parameter*           param              = NULL;

    if ( self->framecomb_parameterlist != NULL ) {
        cpl_parameterlist_delete( self->framecomb_parameterlist );
        self->framecomb_parameterlist = NULL;
    }
    self->framecomb_parameterlist = cpl_parameterlist_new();
    /* Code to check parameters GENERATED DO NOT EDIT */

    param = cpl_parameterlist_find_const( self->inparams,
                                          "zpl.master_dark_imaging.outfilename");
    if (param == NULL) {
        return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                     "Recipe parameter missing: "
                                     "zpl.master_dark_imaging.outfilename");
    }

    self->master_dark_imaging_outfilename = cpl_parameter_get_string(param);
    if (cpl_error_get_code()) {
        return cpl_error_set_where(cpl_func);
    }

    param = cpl_parameterlist_find_const( self->inparams,
                                          "zpl.master_dark_imaging.outfilename_cam1");
    if (param == NULL) {
        return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                     "Recipe parameter missing: "
                                     "zpl.master_dark_imaging.outfilename_cam1");
    }

    self->master_dark_imaging_outfilename_cam1 = cpl_parameter_get_string(param);
    if (cpl_error_get_code()) {
        return cpl_error_set_where(cpl_func);
    }

    param = cpl_parameterlist_find_const( self->inparams,
                                          "zpl.master_dark_imaging.outfilename_cam2");
    if (param == NULL) {
        return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                     "Recipe parameter missing: "
                                     "zpl.master_dark_imaging.outfilename_cam2");
    }

    self->master_dark_imaging_outfilename_cam2 = cpl_parameter_get_string(param);
    if (cpl_error_get_code()) {
        return cpl_error_set_where(cpl_func);
    }

    param = cpl_parameterlist_find_const( self->inparams,
                                          "zpl.master_dark_imaging.subtract_overscan");
    if (param == NULL) {
        return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                     "Recipe parameter missing: "
                                     "zpl.master_dark_imaging.subtract_overscan");
    }

    self->subtract_overscan = cpl_parameter_get_bool(param);
    if (cpl_error_get_code()) {
        return cpl_error_set_where(cpl_func);
    }

    param = cpl_parameterlist_find_const( self->inparams,
                                          "zpl.master_dark_imaging.coll_alg");
    if (param == NULL) {
        return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                     "Recipe parameter missing: "
                                     "zpl.master_dark_imaging.coll_alg");
    }

    self->coll_alg = cpl_parameter_get_int(param);
    if (cpl_error_get_code()) {
        return cpl_error_set_where(cpl_func);
    }

    param = cpl_parameterlist_find_const( self->inparams,
                                          "zpl.master_dark_imaging.coll_alg.clean_mean.reject_high");
    if (param == NULL) {
        return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                     "Recipe parameter missing: "
                                     "zpl.master_dark_imaging.coll_alg.clean_mean.reject_high");
    }

    self->clean_mean_reject_high = cpl_parameter_get_int(param);
    if (cpl_error_get_code()) {
        return cpl_error_set_where(cpl_func);
    }

    cpl_parameterlist_append( self->framecomb_parameterlist,
                              cpl_parameter_new_range( "clean_mean.reject_high",
                                                       CPL_TYPE_INT,
                                                       NULL,
                                                       NULL,
                                                       cpl_parameter_get_int( param ) ,
                                                       0,20
                                                      )
                            );

    param = cpl_parameterlist_find_const( self->inparams,
                                          "zpl.master_dark_imaging.coll_alg.clean_mean.reject_low");
    if (param == NULL) {
        return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                     "Recipe parameter missing: "
                                     "zpl.master_dark_imaging.coll_alg.clean_mean.reject_low");
    }

    self->clean_mean_reject_low = cpl_parameter_get_int(param);
    if (cpl_error_get_code()) {
        return cpl_error_set_where(cpl_func);
    }

    cpl_parameterlist_append( self->framecomb_parameterlist,
                              cpl_parameter_new_range( "clean_mean.reject_low",
                                                       CPL_TYPE_INT,
                                                       NULL,
                                                       NULL,
                                                       cpl_parameter_get_int( param ) ,
                                                       0,20
                                                      )
                            );

    param = cpl_parameterlist_find_const( self->inparams,
                                          "zpl.master_dark_imaging.clean_mean.sigma");
    if (param == NULL) {
        return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                     "Recipe parameter missing: "
                                     "zpl.master_dark_imaging.clean_mean.sigma");
    }

    self->clean_mean_sigma = cpl_parameter_get_double(param);
    if (cpl_error_get_code()) {
        return cpl_error_set_where(cpl_func);
    }

    cpl_parameterlist_append( self->framecomb_parameterlist,
                              cpl_parameter_new_range( "clean_mean.sigma",
                                                       CPL_TYPE_DOUBLE,
                                                       NULL,
                                                       NULL,
                                                       cpl_parameter_get_double( param ) ,
                                                       0.0,200.0
                                                      )
                            );

    param = cpl_parameterlist_find_const( self->inparams,
                                          "zpl.master_dark_imaging.sigma_clip");
    if (param == NULL) {
        return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                     "Recipe parameter missing: "
                                     "zpl.master_dark_imaging.sigma_clip");
    }

    self->sigma_clip = cpl_parameter_get_double(param);
    if (cpl_error_get_code()) {
        return cpl_error_set_where(cpl_func);
    }

    param = cpl_parameterlist_find_const( self->inparams,
                                          "zpl.master_dark_imaging.keep_intermediate");
    if (param == NULL) {
        return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                     "Recipe parameter missing: "
                                     "zpl.master_dark_imaging.keep_intermediate");
    }

    self->keep_intermediate = cpl_parameter_get_bool(param);
    if (cpl_error_get_code()) {
        return cpl_error_set_where(cpl_func);
    }

    param = cpl_parameterlist_find_const( self->inparams,
                                          "zpl.preproc.outfilename_cam1");
    if (param == NULL) {
        return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                     "Recipe parameter missing: "
                                     "zpl.preproc.outfilename_cam1");
    }

    self->outfilename_cam1 = cpl_parameter_get_string(param);
    if (cpl_error_get_code()) {
        return cpl_error_set_where(cpl_func);
    }

    param = cpl_parameterlist_find_const( self->inparams,
                                          "zpl.preproc.outfilename_cam2");
    if (param == NULL) {
        return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                     "Recipe parameter missing: "
                                     "zpl.preproc.outfilename_cam2");
    }

    self->outfilename_cam2 = cpl_parameter_get_string(param);
    if (cpl_error_get_code()) {
        return cpl_error_set_where(cpl_func);
    }

    /* End of code to check parameters BUT ITS STILL NOT SAFE TO EDIT! FILE IS GENERATED !*/

    return rerr;
}
/*----------------------------------------------------------------------------*/
/**
 @brief    Create a new sph_zpl_master_dark_imaging structure.

 @param    frameset     the input recipe frames
 @param    parlist      the input recipe parameters

 @return   pointer to newly created structure or NULL in case of error

 This creates a new sph_zpl_master_dark_imaging_structure and fills the inparams and
 inframes fields with the pointers pf frameset and parlist.
 The return value is the error code of the check.
 */
/*----------------------------------------------------------------------------*/
sph_zpl_master_dark_imaging* sph_zpl_master_dark_imaging_new( cpl_frameset * frameset,
                                              cpl_parameterlist * parlist )
{
    sph_zpl_master_dark_imaging*    result      = NULL;
    int                     rerr        = CPL_ERROR_NONE;

    sph_init_erex();
    if ( frameset == NULL || parlist == NULL ) {
        sph_error_raise( CPL_ERROR_NULL_INPUT, __FILE__,
                         __func__, __LINE__,
                         SPH_ERROR_ERROR,
                         "Null input pointer.");
        return NULL;
    }

    result = cpl_calloc( 1, sizeof(sph_zpl_master_dark_imaging) );

    if ( result == NULL ) {
        sph_error_raise( SPH_ZPL_MASTER_DARK_IMAGING_GENERAL, __FILE__, __func__,
                         __LINE__, SPH_ERROR_ERROR,
                         "Could not allocate the structure.");
        return result;
    }

    result->inframes = frameset;
    result->inparams = parlist;

    rerr = sph_zpl_master_dark_imaging_check_frames( result );
    if ( rerr == CPL_ERROR_NONE) rerr = sph_zpl_master_dark_imaging_check_params( result );

    if ( rerr != CPL_ERROR_NONE ) {
        if ( result ) {
            sph_zpl_master_dark_imaging_delete( result );
        }
        result = NULL;
    }

    return result;
}

/*----------------------------------------------------------------------------*/
/**
 @brief    Delete the sph_zpl_master_dark_imaging structure.

 @param    self         the structure tp delete

 @return   error code of the operation

 This creates a new sph_zpl_master_dark_imaging_structure and fills the inparams and
 inframes fields with the pointers pf frameset and parlist.
 The return value is the error code of the check.
 */
/*----------------------------------------------------------------------------*/
sph_error_code sph_zpl_master_dark_imaging_delete( sph_zpl_master_dark_imaging* self )
{
    sph_error_code          rerr            = CPL_ERROR_NONE;

    if ( self == NULL ) {
        sph_error_raise( CPL_ERROR_NULL_INPUT, __FILE__,
                         __func__, __LINE__,
                         SPH_ERROR_ERROR,
                         "Null input pointer.");
        return rerr;
    }

    if ( self->framecomb_parameterlist != NULL ) {
        cpl_parameterlist_delete( self->framecomb_parameterlist );
        self->framecomb_parameterlist = NULL;
    }

    /* Code to delete recipe pointers GENERATED DO NOT EDIT */

    if ( self->rawframes != NULL ) {
        cpl_frameset_delete( self->rawframes );
        self->rawframes = NULL;
    }
    if ( self->preproc_frames != NULL ) {
        cpl_frameset_delete( self->preproc_frames );
        self->preproc_frames = NULL;
    }
    if ( self->preproc_frames_cam1 != NULL ) {
        cpl_frameset_delete( self->preproc_frames_cam1 );
        self->preproc_frames_cam1 = NULL;
    }
    if ( self->preproc_frames_cam2 != NULL ) {
        cpl_frameset_delete( self->preproc_frames_cam2 );
        self->preproc_frames_cam2 = NULL;
    }
    if ( self->master_bias_imaging_frame != NULL ) {
        cpl_frame_delete( self->master_bias_imaging_frame );
        self->master_bias_imaging_frame = NULL;
    }
    if ( self->master_bias_imaging_frame_cam1 != NULL ) {
        cpl_frame_delete( self->master_bias_imaging_frame_cam1 );
        self->master_bias_imaging_frame_cam1 = NULL;
    }
    if ( self->master_bias_imaging_frame_cam2 != NULL ) {
        cpl_frame_delete( self->master_bias_imaging_frame_cam2 );
        self->master_bias_imaging_frame_cam2 = NULL;
    }
 
    sph_double_image_delete(self->master_dark_imaging_doubleimage);
    sph_double_image_delete(self->master_dark_imaging_doubleimage_cam1);
    sph_double_image_delete(self->master_dark_imaging_doubleimage_cam2);
    /* End of code to delete pointers BUT ITS STILL NOT SAFE TO EDIT! FILE IS GENERATED !*/
    if ( self->current_raw_frameset ) {
        cpl_frameset_delete(self->current_raw_frameset);
        self->current_raw_frameset = NULL;
    }
    sph_polygon_free_all();
    cpl_free(    self);
    return rerr;

}


/**@}*/
