/***********************************************************************************************/
/******** DANGER !! DANGER !! DANGER !! DO NOT EDIT FILE -- IT WAS GENERATED AUTOMATICALLY !!! */
/***********************************************************************************************/

/* $Id: $
 * This file is part of the SPHERE Pipeline
 * Copyright (C) 2007-2010 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 * $Author: $
 * $Date: $
 * $Revision: $
 * $Name: $
 */

/*-----------------------------------------------------------------------------
 Includes
 -----------------------------------------------------------------------------*/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "sph_zpl_polarization_flat.h"
#include "sph_common_keywords.h"
#include "sph_zpl_keywords.h"
#include "sph_zpl_tags.h"
#include "sph_master_frame.h"
#include "sph_error.h"
#include "sph_cube.h"
#include "sph_utils.h"

#include <math.h>
#include <assert.h>
#include <cpl.h>

/*-----------------------------------------------------------------------------
  Error Codes
 -----------------------------------------------------------------------------*/

sph_error_code SPH_ZPL_POLARIZATION_FLAT_GENERAL              = SPH_ZPL_POLARIZATION_FLAT_ERR_START + 0;
sph_error_code SPH_ZPL_POLARIZATION_FLAT_NO_VALID_DIT_LIST    = SPH_ZPL_POLARIZATION_FLAT_ERR_START + 1;

sph_error_code SPH_ZPL_POLARIZATION_FLAT_PARAMETER_MISSING    = SPH_ZPL_POLARIZATION_FLAT_ERR_START + 3;
sph_error_code SPH_ZPL_POLARIZATION_FLAT_FRAMES_MISSING       = SPH_ZPL_POLARIZATION_FLAT_ERR_START + 4;

/*-----------------------------------------------------------------------------
 Private function prototypes
 -----------------------------------------------------------------------------*/

static int sph_zpl_polarization_flat_create_plugin ( cpl_plugin * );
static int sph_zpl_polarization_flat_exec_plugin ( cpl_plugin * );
static int sph_zpl_polarization_flat_destroy_plugin ( cpl_plugin * );

/*-----------------------------------------------------------------------------
 Static variables
 -----------------------------------------------------------------------------*/

static const char* sph_zpl_polarization_flat_help = 
    "RECIPE INPUT FRAMES: \n"
    "-------------------- \n"
    "Tag                           Min,Max   Description\n"
    "ZPL_POL_FLAT_FIELD_RAW          0, -1   The raw  frames in the polarimetric modes with the two extensions  fits file format:\n"
    "                                        first extension represents data cube of NDITS frames from camera-1 for a given DIT, including prescan/overscan area of 2 ADUs;\n"
    "                                        second extension represents data cube of NDITS zimpol frames from camera-2 for a given DIT, including prescan/overscan area of 2 ADUs\n"
    "ZPL_POL_FLAT_PREPROC            0, -1   The pre-processed raw polarization flat field frames.\n"
    "                                        Format: ZPL EXP\n"
    "ZPL_POL_FLAT_PREPROC_CAM1       0, -1   The pre-processed raw polarization flat field frames.\n"
    "                                        Format: ZPL EXP\n"
    "ZPL_POL_FLAT_PREPROC_CAM2       0, -1   The pre-processed raw polarization flat field frames.\n"
    "                                        Format: ZPL EXP\n"
    "ZPL_MASTER_BIAS                 0,  1   The master bias frame. Should have readout mode as the pre-processed intensity flat field frames.\n"
    "                                        Format: QUAD IMAGE = [Im(16)]\n"
    "ZPL_MASTER_BIAS_CAM1            0,  1   The master bias frame. Should have readout mode as the pre-processed intensity flat field frames.\n"
    "                                        Format: QUAD IMAGE = [Im(16)]\n"
    "ZPL_MASTER_BIAS_CAM2            0,  1   The master bias frame. Should have readout mode as the pre-processed intensity flat field frames.\n"
    "                                        Format: QUAD IMAGE = [Im(16)]\n"
    "ZPL_MASTER_DARK                 0,  1   The master dark frame. Should have readout mode as the pre-processed intensity flat field frames.\n"
    "                                        Format: QUAD IMAGE = [Im(16)]\n"
    "ZPL_MASTER_DARK_CAM1            0,  1   The master dark frame. Should have readout mode as the pre-processed intensity flat field frames.\n"
    "                                        Format: QUAD IMAGE = [Im(16)]\n"
    "ZPL_MASTER_DARK_CAM2            0,  1   The master dark frame. Should have readout mode as the pre-processed intensity flat field frames.\n"
    "                                        Format: QUAD IMAGE = [Im(16)]\n"
    "ZPL_INT_FLAT_FIELD              0,  1   The intensity flat field calibration frame. It should have readout mode as the pre-processed polarization flat field frames.\n"
    "                                        Format: QUAD IMAGE = [Im(16)]\n"
    "ZPL_INT_FLAT_FIELD_CAM1         0,  1   The intensity flat field calibration frame. It should have readout mode as the pre-processed polarization flat field frames.\n"
    "                                        Format: QUAD IMAGE = [Im(16)]\n"
    "ZPL_INT_FLAT_FIELD_CAM2         0,  1   The intensity flat field calibration frame. It should have readout mode as the pre-processed polarization flat field frames.\n"
    "                                        Format: QUAD IMAGE = [Im(16)]\n"
    "ZPL_INT_FLAT_FIELD_MASTER       0,  1   The master intensity flat field frame. Should have readout mode as the pre-processed science frames.\n"
    "                                        Format: MASTER FRAME = [Im(4)]\n"
    "ZPL_INT_FLAT_FIELD_MASTER_CAM1  0,  1   The master intensity flat field frame. Should have readout mode as the pre-processed science frames.\n"
    "                                        Format: MASTER FRAME = [Im(4)]\n"
    "ZPL_INT_FLAT_FIELD_MASTER_CAM2  0,  1   The master intensity flat field frame. Should have readout mode as the pre-processed science frames.\n"
    "                                        Format: MASTER FRAME = [Im(4)]\n"
    "\n"
    "RAW FRAME KEYWORDS: \n"
    "-------------------- \n"
    "Keyword                       Type   Optional  Description\n"
    "ESO DRS PC PROD TYPE          string No        This keyword is mandatory if the pre-processed data are used. \n"
    "                                               As the format of the zimpol pre-processed data is complicated, this keyword was introduced in order \n"
    "                                               to garantee that the pre-processed input frames are polarimetric pre-processed data, \n"
    "                                               produced by the sph_zpl_preproc utility recipe. \n"
    "                                                              \n"
    "                                               Note: if raw data are used (default), then all keywords needed for the pre-processing recipe \n"
    "                                               (see sph_zpl_preproc) must be presented in the raw data. \n"
    "\n"
    "DESCRIPTION:\n"
    "------------\n"
    "This recipe creates the polarization flat field calibration frame for both cameras.\n"
    "The input frames might be either intesity flat raw frames with the ZPL_POL_FLAT_FIELD_RAW tag or\n"
    "pre-processed polarization flatframes, which should carry the ZPL_POL_FLAT_PREPROC_CAM1 and/or  tag ZPL_POL_FLAT_PREPROC_CAM2 tags, and\n"
    "master bias frames (if any) with the ZPL_MASTER_BIAS_CAM1 and/or ZPL_MASTER_BIAS_CAM2 tags, and\n"
    "master dark frames (if any) with the ZPL_MASTER_DARK_CAM1 and/or ZPL_MASTER_DARK_CAM2 tags, and\n"
    "master intensity flat field calibration frames with the  ZPL_INT_FLAT_FIELD_MASTER_CAM1 and/or ZPL_INT_FLAT_FIELD_MASTER_CAM2 tags.\n"
    "The intensity flat calibration frames can be also used in the format of the QUAD IMAGE (see the description in sph_zpl_intensity_flat recipe) with\n"
    "the corresponding ZPL_INT_FLAT_FIELD_CAM1 and/or ZPL_INT_FLAT_FIELD_CAM2 tags. If both formats of the intensity flat field calibrations are presented\n"
    "in sof-file the MASTER format will be used.\n"
    "\n"
    "If input frames are raw frames then the polarization flat recipe first performs the pre-processing step for all input frames (raw cubes),\n"
    "creating corresponding pre-processed frames (cubes) for both ZIMPOL cameras (see also sph_zpl_preproc for the detailed description of the\n"
    "pre-processing step).\n"
    "\n"
    "\n"
    "Then, all the pre-processed frames are read and combined  using the specified\n"
    "collapse algorithm (usually the clean_mean algorithm, defined as a default one) for each zpl exposure sub-frames.\n"
    "The combined frames for both cameras are of the QUAD IMAGE (16 extensions) format specified as follows:\n"
    "- zpl exp phase zero odd sub-frame combined image, badpixel-map, ncomb-map and rms-map;\n"
    "- zpl exp phase zero even  sub-frame combined image, badpixel-map, ncomb-map and rms-map;\n"
    "- zpl exp phase PI odd sub-frame master combined image, badpixel-map, ncomb-map and  rms-map;\n"
    "- zpl exp phase PI even sub-frame  master combined image, badpixel-map, ncomb-map and rms-map.\n"
    "The master bias, dark and intensity flat field are applied to this combined master frame and\n"
    "then the Stokes parameters (I,P) are calculated. The output master polarization flat field is written\n"
    "out in the DOUBLE IMAGE (8 images) format specified as follows:\n"
    "- master intensity Stokes parameter image, badpixel-map, ncomb-map and rms-map;\n"
    "- master polarization Stokes parameter image, badpixel-map, ncomb-map and rms-map.\n"
    "\n"
    "The master polarization flat field products for both cameras are used in all subsequent polarization recipes.\n"
    "RECIPE PRODUCTS: \n"
    "-------------------- \n"
    "Tag                      Format         Description\n"
    "ZPL_POL_FLAT_FIELD                 FITS[Im(8)]    The resulting polarization flat filed frame is of the DOUBLE IMAGE format.\n"
    "                                        This frame contains 8 image extensions grouped by the following order:\n"
    "                                        master intensity image, badpixel-map, ncomb-map and rms-map;\n"
    "                                        master polarization image, badpixel-map, ncomb-map and rms-map.\n"
    "ZPL_POL_FLAT_FIELD_CAM1            FITS[Im(8)]    The resulting polarization flat filed frame is of the DOUBLE IMAGE format.\n"
    "                                        This frame contains 8 image extensions grouped by the following order:\n"
    "                                        master intensity image, badpixel-map, ncomb-map and rms-map;\n"
    "                                        master polarization image, badpixel-map, ncomb-map and rms-map.\n"
    "ZPL_POL_FLAT_FIELD_CAM2            FITS[Im(8)]    The resulting polarization flat filed frame is of the DOUBLE IMAGE format.\n"
    "                                        This frame contains 8 image extensions grouped by the following order:\n"
    "                                        intensity image, badpixel-map, ncomb-map and rms-map;\n"
    "                                        polarization image, badpixel-map, ncomb-map and rms-map.\n"
    "\n"
    "PRODUCT FRAME KEYWORDS: \n"
    "-------------------- \n"
    "Keyword                       Frame          Type    Description\n"
    "\n"
;

/*-----------------------------------------------------------------------------
 Function code
 -----------------------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/
/**
 * @defgroup sph_zpl_polarization_flat Create Master Dark Recipe
 *
 * This module provides the recipe plugin and relating functions for the
 * creation of the master dark .
 *
 * @par Synopsis:
 * @code
 *   #include "sph_zpl_polarization_flat.h"
 * @endcode
 */
/*----------------------------------------------------------------------------*/
/**@{*/

/*****************************************************************************
 *
 *
 *      First come the static and global functions necessary for the
 *      normal working of the recipe as plugin....
 *
 *
 * ***************************************************************************/
/*----------------------------------------------------------------------------*/
/**
 @brief    Build the list of available plugins, for this module.
 @param    list    the plugin list
 @return   0 if everything is ok, 1 otherwise
 @note     Only this function is exported

 Create the recipe instance and make it available to the application
 using the interface.
 */
/*----------------------------------------------------------------------------*/
int cpl_plugin_get_info(cpl_pluginlist * list)
{
    cpl_recipe * recipe = cpl_calloc( 1, sizeof *recipe);
    cpl_plugin * plugin = &recipe->interface;

    if (cpl_plugin_init(plugin,
                        CPL_PLUGIN_API,
                        SPH_ZPL_POLARIZATION_FLAT_VERSION,
                        CPL_PLUGIN_TYPE_RECIPE,
                        "sph_zpl_polarization_flat",
                        "Create polarization flat field, polarimetric modes.",
                        sph_zpl_polarization_flat_help, "Alexey Pavlov <pavlov@mpia-hd.mpg.de>",
                        "https://support.eso.org", cpl_get_license("SPHERE DRH","2012"),
                        sph_zpl_polarization_flat_create_plugin,
                        sph_zpl_polarization_flat_exec_plugin,
                        sph_zpl_polarization_flat_destroy_plugin) )
    {
        cpl_msg_error( cpl_func, "Plugin initialization failed");
        (void)cpl_error_set_where( cpl_func );
        return 1;
    }

    if (cpl_pluginlist_append(list, plugin) )
    {
        cpl_msg_error( cpl_func, "Error adding plugin to list");
        (void)cpl_error_set_where( cpl_func );
        return 1;
    }
    return 0;
}

/*----------------------------------------------------------------------------*/
/**
 @brief    Setup the recipe options
 @param    plugin  the plugin
 @return   0 if everything is ok

 Defining the command-line/configuration parameters for the recipe.
 */
/*----------------------------------------------------------------------------*/
static int sph_zpl_polarization_flat_create_plugin(cpl_plugin * plugin)
{
    if (cpl_error_get_code() != CPL_ERROR_NONE)
    {
        cpl_msg_error( cpl_func, "%s():%d: An error is already set: %s",
                       cpl_func, __LINE__, cpl_error_get_where());
        return (int)cpl_error_get_code();
    }

    if (plugin == NULL)
    {
        cpl_msg_error(cpl_func, "Null plugin");
        cpl_ensure_code(0, (int)CPL_ERROR_NULL_INPUT);
    }

    if (cpl_plugin_get_type(plugin) != CPL_PLUGIN_TYPE_RECIPE)
    {
        cpl_msg_error( cpl_func, "Plugin is not a recipe");
        cpl_ensure_code( 0, (int)CPL_ERROR_TYPE_MISMATCH );
    }

    if ( plugin != NULL ) {
        cpl_recipe * recipe = (cpl_recipe *)plugin;
        recipe->parameters = sph_zpl_polarization_flat_create_paramlist();
        if ( recipe->parameters == NULL ) {
            return SPH_ZPL_POLARIZATION_FLAT_GENERAL;
        }
    }
    return 0;
}

/*----------------------------------------------------------------------------*/
/**
 @brief    Testing for setup of the recipe options
 @param    plugin  the plugin
 @return   0 if everything is ok

 Wrapper to make the static plugin creation function accessible from outside
 for testing purposes.
 */
/*----------------------------------------------------------------------------*/
int sph_zpl_polarization_flat_create_test(cpl_plugin * plugin)
{
    return (int)sph_zpl_polarization_flat_create_plugin(plugin);
}

/*----------------------------------------------------------------------------*/
/**
 @brief    Execute the plugin instance given by the interface
 @param    plugin  the plugin
 @return   0 if everything is ok
 */
/*----------------------------------------------------------------------------*/
static int sph_zpl_polarization_flat_exec_plugin(cpl_plugin * plugin)
{

    cpl_recipe*             recipe                  = NULL;
    cpl_error_code          recipe_code;
    sph_zpl_polarization_flat*    sph_recipe      = NULL;
    cpl_errorstate          initial_errorstate      = cpl_errorstate_get();

    if (cpl_error_get_code() != CPL_ERROR_NONE)
    {
        cpl_msg_error( cpl_func, "%s():%d: A cpl error is already set: %s",
        cpl_func, __LINE__, cpl_error_get_where());
        return (int)cpl_error_get_code();
    }

    if (plugin == NULL)
    {
        cpl_msg_error( cpl_func, "Null plugin");
        cpl_ensure_code( 0, (int)CPL_ERROR_NULL_INPUT );
        return (int)cpl_error_get_code();
    }

    if (cpl_plugin_get_type(plugin) != CPL_PLUGIN_TYPE_RECIPE)
    {
        cpl_msg_error( cpl_func, "Plugin is not a recipe");
        cpl_ensure_code( 0, (int)CPL_ERROR_TYPE_MISMATCH );
        return (int)cpl_error_get_code();
    }

    recipe = (cpl_recipe *)plugin;

    if (recipe->parameters == NULL)
    {
        cpl_msg_error( cpl_func, "Recipe invoked with NULL parameter list");
        cpl_ensure_code( 0, (int)CPL_ERROR_NULL_INPUT );
        return (int)cpl_error_get_code();
    }

    if (recipe->frames == NULL)
    {
        cpl_msg_error( cpl_func, "Recipe invoked with NULL frame set");
        cpl_ensure_code( 0, (int)CPL_ERROR_NULL_INPUT );
        return (int)cpl_error_get_code();
    }

    sph_recipe = sph_zpl_polarization_flat_new( recipe->frames, recipe->parameters );
    if ( sph_recipe == NULL ) {
        recipe_code = cpl_error_set_where(cpl_func);
    } else {

        recipe_code = sph_zpl_polarization_flat_run( sph_recipe );

        sph_zpl_polarization_flat_delete( sph_recipe );
    }

    if ( !cpl_errorstate_is_equal(initial_errorstate) )
    {
        cpl_errorstate_dump(initial_errorstate, CPL_FALSE, NULL);
    }
    sph_end_erex(); //close the sphere system
    return (int)(recipe_code >= CPL_ERROR_EOL /* Workaround esorex PIPE-6887 */
                 ? CPL_ERROR_EOL : recipe_code);
}

/*----------------------------------------------------------------------------*/
/**
 @brief    Destroy what has been created by the 'create' function
 @param    plugin  the plugin
 @return   0 if everything is ok
 */
/*----------------------------------------------------------------------------*/
static int sph_zpl_polarization_flat_destroy_plugin(cpl_plugin * plugin)
{
    cpl_recipe * recipe;

    if (plugin == NULL)
    {
        cpl_msg_error( cpl_func, "Null plugin");
        cpl_ensure_code( 0, (int)CPL_ERROR_NULL_INPUT );
    }

    if (cpl_plugin_get_type(plugin) != CPL_PLUGIN_TYPE_RECIPE)
    {
        cpl_msg_error( cpl_func, "Plugin is not a recipe");
        cpl_ensure_code( 0, (int)CPL_ERROR_TYPE_MISMATCH );
    }

    recipe = (cpl_recipe *)plugin;

    cpl_parameterlist_delete(recipe->parameters);

    return 0;
}

/*****************************************************************************
 *
 *
 *      Here come the "Member" functions of the sph_zpl_polarization_flat struct
 *
 *
 * ***************************************************************************/

/*----------------------------------------------------------------------------*/
/**
 @brief    Fill a pre-allocated parameterlist for the recipe
 @param    result A pre-allocated parameterlist
 @return   CPL_ERROR_NONE iff successful

 This function fills the standard parameterlist for the recipe

 */
/*----------------------------------------------------------------------------*/
static cpl_error_code sph_zpl_polarization_flat_fill_parameterlist(cpl_parameterlist * result)
{
    cpl_parameter* p;

        /* Code to set up parameters GENERATED DO NOT EDIT */

        p = cpl_parameter_new_value("zpl.polarization_flat.outfilename",
                                   CPL_TYPE_STRING,
                                   "The output filename for the product for the camera-1/2. Please also see the esorex documentation "
                                   "for naming of output products. "
                                   ,"zpl.polarization_flat",
                                   "zpl_polarization_flat.fits" );

        cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
        cpl_parameterlist_append(result, p);
        p = cpl_parameter_new_value("zpl.polarization_flat.outfilename_cam1",
                                   CPL_TYPE_STRING,
                                   "The output filename for the product for the camera-1. Please also see the esorex documentation "
                                   "for naming of output products. "
                                   ,"zpl.polarization_flat",
                                   "zpl_polarization_flat_cam1.fits" );

        cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
        cpl_parameterlist_append(result, p);
        p = cpl_parameter_new_value("zpl.polarization_flat.outfilename_cam2",
                                   CPL_TYPE_STRING,
                                   "The output filename for the product for the camera-2. Please also see the esorex documentation "
                                   "for naming of output products. "
                                   ,"zpl.polarization_flat",
                                   "zpl_polarization_flat_cam2.fits" );

        cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
        cpl_parameterlist_append(result, p);
        p = cpl_parameter_new_value("zpl.polarization_flat.subtract_overscan",
                                   CPL_TYPE_BOOL,
                                   "Flag to set if the overscan mean values must be subtracted from pre-processed data (TRUE) "
                                   "Note that this parameter is applied if pre-processed data containt overscan table "
                                   ,"zpl.polarization_flat",
                                   1 );

        cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
        cpl_parameterlist_append(result, p);
        p = cpl_parameter_new_enum("zpl.polarization_flat.coll_alg",
                                   CPL_TYPE_INT,
                                   "Set the collapse algorithm. The available algorithms: 0 = Mean, 1 = Median, 2 = Clean Mean. Default is 2 = Clean Mean "
                                   ,"zpl.polarization_flat",
                                   2 ,
                                   3,0,1,2);

        cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
        cpl_parameterlist_append(result, p);
        p = cpl_parameter_new_range("zpl.polarization_flat.coll_alg.clean_mean.reject_high",
                                   CPL_TYPE_INT,
                                   "The number of pixels to reject when combining frames at the high end. Number of input frames must be > reject_high +reject_low "
                                   ,"zpl.polarization_flat",
                                   0 ,
                                   0,20);

        cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
        cpl_parameterlist_append(result, p);
        p = cpl_parameter_new_range("zpl.polarization_flat.coll_alg.clean_mean.reject_low",
                                   CPL_TYPE_INT,
                                   "The number of pixels to reject when combining frames at the low end. Number of input frames must be > reject_high +reject_low "
                                   ,"zpl.polarization_flat",
                                   0 ,
                                   0,20);

        cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
        cpl_parameterlist_append(result, p);
        p = cpl_parameter_new_value("zpl.polarization_flat.keep_intermediate",
                                   CPL_TYPE_BOOL,
                                   "Flag to set if intermediate date must be saved, namely pre-processed and overscan pre-processed subtracted data (FALSE) "
                                   ,"zpl.polarization_flat",
                                   0 );

        cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
        cpl_parameterlist_append(result, p);
        p = cpl_parameter_new_value("zpl.preproc.outfilename_cam1",
                                   CPL_TYPE_STRING,
                                   "The postfix-  of the intermediate filename of the pre-processed raw data for the CAMERA-1. "
                                   ,"zpl.preproc",
                                   "preproc_cam1.fits" );

        cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
        cpl_parameterlist_append(result, p);
        p = cpl_parameter_new_value("zpl.preproc.outfilename_cam2",
                                   CPL_TYPE_STRING,
                                   "The postfix- of the  intermediate filename of the pre-processed raw data for the CAMERA-2. "
                                   ,"zpl.preproc",
                                   "preproc_cam2.fits" );

        cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
        cpl_parameterlist_append(result, p);
        /* End of code to set up parameters BUT ITS STILL NOT SAFE TO EDIT! FILE IS GENERATED !*/

    return cpl_error_set_where(cpl_func);
}
/*----------------------------------------------------------------------------*/
/**
 @brief  Create and return the standard parameterlist for the recipe
 @return The standard parameterlist or NULL on error
 @note   The returned object must be deallocated using cpl_parameterlist_delete

 */
/*----------------------------------------------------------------------------*/
cpl_parameterlist* sph_zpl_polarization_flat_create_paramlist(void)
{
    cpl_parameterlist* self = cpl_parameterlist_new();

    if (sph_zpl_polarization_flat_fill_parameterlist(self)) {
        cpl_parameterlist_delete(self);
        self = NULL;
        (void)cpl_error_set_where(cpl_func);
    }

    return self;
}

/*----------------------------------------------------------------------------*/
/**
 @brief    Check the recipe frames, and assign them to the sph_zpl_polarization_flat
           structure.
 @param    self     the sph_zpl_polarization_flat recipe structure
 @return   error code of the check.

 This checks the frames that were given in the sph_zpl_polarization_flat_new function
 as parameters for the correctness and completeness. If the frames needed are
 found they are also assigned to the corresponding structure members.

 The return value is the error code of the check.
 */
/*----------------------------------------------------------------------------*/
sph_error_code  sph_zpl_polarization_flat_check_frames( sph_zpl_polarization_flat* self )
{
    sph_error_code           rerr            = CPL_ERROR_NONE;
    /* Code to check frames GENERATED DO NOT EDIT */

    cpl_frame* aframe;
    aframe = cpl_frameset_find( self->inframes, SPH_ZPL_TAG_PFF_RAW );
    while ( aframe ) {
        cpl_frame_set_group( aframe, CPL_FRAME_GROUP_RAW );
        aframe = cpl_frameset_find( self->inframes, NULL );
    }
    self->rawframes = sph_utils_extract_frames( self->inframes, SPH_ZPL_TAG_PFF_RAW );
    if ( ! self->rawframes )
    {
        sph_error_raise( SPH_ZPL_POLARIZATION_FLAT_FRAMES_MISSING,
                         __FILE__, __func__, __LINE__ ,
                         SPH_ERROR_INFO,
                         "Could not extract rawframes frames."
                         "Since this is an optional frame, this is ok "
                         "and this message is just informational. If you intended, "
                         "to use them check that they have the %s tag.",
                         SPH_ZPL_TAG_PFF_RAW);
        cpl_error_reset();
    }

    else {

         int numframes = (int)cpl_frameset_get_size( self->rawframes );
         for ( int ii = 0; ii < numframes; ++ii ) {
             cpl_frame* iframe = cpl_frameset_get_position( self->rawframes, ii );
             const char* ifname = cpl_frame_get_filename(iframe);
             cpl_propertylist* pl = cpl_propertylist_load(ifname, 0);
             if (pl == NULL ) {
                 sph_error_raise(cpl_error_get_code(),
                    __FILE__, __func__, __LINE__ ,SPH_ERROR_ERROR,
                 "Could not read keywords from file %s. "
                 "Either the file is not readable or corrupted. ",
                  ifname);
             }
             else {
                 rerr = cpl_frame_set_group( iframe, CPL_FRAME_GROUP_RAW );
                 int haskey, okval;
                 haskey = 0;okval = 0;
                 if ( cpl_propertylist_has(pl,"ESO DRS PC PROD TYPE") )  {
                     haskey = 1;
                     if ( cpl_propertylist_get_type(pl,"ESO DRS PC PROD TYPE") == CPL_TYPE_STRING )  {
                         okval = 1; //Type is string so always ok
                     } 
                     if ( haskey == 0 || okval == 0 ) {
                         sph_error_raise(CPL_ERROR_ILLEGAL_INPUT,
                            __FILE__, __func__, __LINE__ ,SPH_ERROR_ERROR,
                         "Could not read a keyword ESO DRS PC PROD TYPE from file %s. "
                         "that has __type string "
                         "and values between 0.0 and 0.0 "
                         "The recipe requires this. ",
                         ifname);
                     }
                 }
                 cpl_propertylist_delete(pl); pl=NULL;
             }
         }
         numframes -= (int)cpl_frameset_get_size( self->rawframes );
         assert( numframes == 0);
    }

    aframe = cpl_frameset_find( self->inframes, SPH_ZPL_TAG_PFF_PREPROC_RAW );
    while ( aframe ) {
        cpl_frame_set_group( aframe, CPL_FRAME_GROUP_CALIB );
        aframe = cpl_frameset_find( self->inframes, NULL );
    }
    self->preproc_frames = sph_utils_extract_frames( self->inframes, SPH_ZPL_TAG_PFF_PREPROC_RAW );
    if ( ! self->preproc_frames )
    {
        sph_error_raise( SPH_ZPL_POLARIZATION_FLAT_FRAMES_MISSING,
                         __FILE__, __func__, __LINE__ ,
                         SPH_ERROR_INFO,
                         "Could not extract preproc_frames frames."
                         "Since this is an optional frame, this is ok "
                         "and this message is just informational. If you intended, "
                         "to use them check that they have the %s tag.",
                         SPH_ZPL_TAG_PFF_PREPROC_RAW);
        cpl_error_reset();
    }

    else {

         int numframes = (int)cpl_frameset_get_size( self->preproc_frames );
         for ( int ii = 0; ii < numframes; ++ii ) {
         }
         numframes -= (int)cpl_frameset_get_size( self->preproc_frames );
         assert( numframes == 0);
    }

    aframe = cpl_frameset_find( self->inframes, SPH_ZPL_TAG_PFF_PREPROC_CAM1 );
    while ( aframe ) {
        cpl_frame_set_group( aframe, CPL_FRAME_GROUP_CALIB );
        aframe = cpl_frameset_find( self->inframes, NULL );
    }
    self->preproc_frames_cam1 = sph_utils_extract_frames( self->inframes, SPH_ZPL_TAG_PFF_PREPROC_CAM1 );
    if ( ! self->preproc_frames_cam1 )
    {
        sph_error_raise( SPH_ZPL_POLARIZATION_FLAT_FRAMES_MISSING,
                         __FILE__, __func__, __LINE__ ,
                         SPH_ERROR_INFO,
                         "Could not extract preproc_frames_cam1 frames."
                         "Since this is an optional frame, this is ok "
                         "and this message is just informational. If you intended, "
                         "to use them check that they have the %s tag.",
                         SPH_ZPL_TAG_PFF_PREPROC_CAM1);
        cpl_error_reset();
    }

    else {

         int numframes = (int)cpl_frameset_get_size( self->preproc_frames_cam1 );
         for ( int ii = 0; ii < numframes; ++ii ) {
         }
         numframes -= (int)cpl_frameset_get_size( self->preproc_frames_cam1 );
         assert( numframes == 0);
    }

    aframe = cpl_frameset_find( self->inframes, SPH_ZPL_TAG_PFF_PREPROC_CAM2 );
    while ( aframe ) {
        cpl_frame_set_group( aframe, CPL_FRAME_GROUP_CALIB );
        aframe = cpl_frameset_find( self->inframes, NULL );
    }
    self->preproc_frames_cam2 = sph_utils_extract_frames( self->inframes, SPH_ZPL_TAG_PFF_PREPROC_CAM2 );
    if ( ! self->preproc_frames_cam2 )
    {
        sph_error_raise( SPH_ZPL_POLARIZATION_FLAT_FRAMES_MISSING,
                         __FILE__, __func__, __LINE__ ,
                         SPH_ERROR_INFO,
                         "Could not extract preproc_frames_cam2 frames."
                         "Since this is an optional frame, this is ok "
                         "and this message is just informational. If you intended, "
                         "to use them check that they have the %s tag.",
                         SPH_ZPL_TAG_PFF_PREPROC_CAM2);
        cpl_error_reset();
    }

    else {

         int numframes = (int)cpl_frameset_get_size( self->preproc_frames_cam2 );
         for ( int ii = 0; ii < numframes; ++ii ) {
         }
         numframes -= (int)cpl_frameset_get_size( self->preproc_frames_cam2 );
         assert( numframes == 0);
    }

    aframe = cpl_frameset_find( self->inframes, SPH_ZPL_TAG_BIAS_CALIB );
    while ( aframe ) {
        cpl_frame_set_group( aframe, CPL_FRAME_GROUP_CALIB );
        aframe = cpl_frameset_find( self->inframes, NULL );
    }
    self->master_bias_frame = sph_utils_extract_frame( self->inframes, SPH_ZPL_TAG_BIAS_CALIB );
    if ( ! self->master_bias_frame )
    {
        sph_error_raise( SPH_ZPL_POLARIZATION_FLAT_FRAMES_MISSING,
                         __FILE__, __func__, __LINE__ ,
                         SPH_ERROR_INFO,
                         "Could not extract master_bias_frame frames."
                         "Since this is an optional frame, this is ok "
                         "and this message is just informational. If you intended, "
                         "to use them check that they have the %s tag.",
                         SPH_ZPL_TAG_BIAS_CALIB);
        cpl_error_reset();
    }

    else {

         rerr = cpl_frame_set_group( self->master_bias_frame, CPL_FRAME_GROUP_CALIB );
    }

    aframe = cpl_frameset_find( self->inframes, SPH_ZPL_TAG_BIAS_CALIB_CAM1 );
    while ( aframe ) {
        cpl_frame_set_group( aframe, CPL_FRAME_GROUP_CALIB );
        aframe = cpl_frameset_find( self->inframes, NULL );
    }
    self->master_bias_frame_cam1 = sph_utils_extract_frame( self->inframes, SPH_ZPL_TAG_BIAS_CALIB_CAM1 );
    if ( ! self->master_bias_frame_cam1 )
    {
        sph_error_raise( SPH_ZPL_POLARIZATION_FLAT_FRAMES_MISSING,
                         __FILE__, __func__, __LINE__ ,
                         SPH_ERROR_INFO,
                         "Could not extract master_bias_frame_cam1 frames."
                         "Since this is an optional frame, this is ok "
                         "and this message is just informational. If you intended, "
                         "to use them check that they have the %s tag.",
                         SPH_ZPL_TAG_BIAS_CALIB_CAM1);
        cpl_error_reset();
    }

    else {

         rerr = cpl_frame_set_group( self->master_bias_frame_cam1, CPL_FRAME_GROUP_CALIB );
    }

    aframe = cpl_frameset_find( self->inframes, SPH_ZPL_TAG_BIAS_CALIB_CAM2 );
    while ( aframe ) {
        cpl_frame_set_group( aframe, CPL_FRAME_GROUP_CALIB );
        aframe = cpl_frameset_find( self->inframes, NULL );
    }
    self->master_bias_frame_cam2 = sph_utils_extract_frame( self->inframes, SPH_ZPL_TAG_BIAS_CALIB_CAM2 );
    if ( ! self->master_bias_frame_cam2 )
    {
        sph_error_raise( SPH_ZPL_POLARIZATION_FLAT_FRAMES_MISSING,
                         __FILE__, __func__, __LINE__ ,
                         SPH_ERROR_INFO,
                         "Could not extract master_bias_frame_cam2 frames."
                         "Since this is an optional frame, this is ok "
                         "and this message is just informational. If you intended, "
                         "to use them check that they have the %s tag.",
                         SPH_ZPL_TAG_BIAS_CALIB_CAM2);
        cpl_error_reset();
    }

    else {

         rerr = cpl_frame_set_group( self->master_bias_frame_cam2, CPL_FRAME_GROUP_CALIB );
    }

    aframe = cpl_frameset_find( self->inframes, SPH_ZPL_TAG_DARK_CALIB );
    while ( aframe ) {
        cpl_frame_set_group( aframe, CPL_FRAME_GROUP_CALIB );
        aframe = cpl_frameset_find( self->inframes, NULL );
    }
    self->master_dark_frame = sph_utils_extract_frame( self->inframes, SPH_ZPL_TAG_DARK_CALIB );
    if ( ! self->master_dark_frame )
    {
        sph_error_raise( SPH_ZPL_POLARIZATION_FLAT_FRAMES_MISSING,
                         __FILE__, __func__, __LINE__ ,
                         SPH_ERROR_INFO,
                         "Could not extract master_dark_frame frames."
                         "Since this is an optional frame, this is ok "
                         "and this message is just informational. If you intended, "
                         "to use them check that they have the %s tag.",
                         SPH_ZPL_TAG_DARK_CALIB);
        cpl_error_reset();
    }

    else {

         rerr = cpl_frame_set_group( self->master_dark_frame, CPL_FRAME_GROUP_CALIB );
    }

    aframe = cpl_frameset_find( self->inframes, SPH_ZPL_TAG_DARK_CALIB_CAM1 );
    while ( aframe ) {
        cpl_frame_set_group( aframe, CPL_FRAME_GROUP_CALIB );
        aframe = cpl_frameset_find( self->inframes, NULL );
    }
    self->master_dark_frame_cam1 = sph_utils_extract_frame( self->inframes, SPH_ZPL_TAG_DARK_CALIB_CAM1 );
    if ( ! self->master_dark_frame_cam1 )
    {
        sph_error_raise( SPH_ZPL_POLARIZATION_FLAT_FRAMES_MISSING,
                         __FILE__, __func__, __LINE__ ,
                         SPH_ERROR_INFO,
                         "Could not extract master_dark_frame_cam1 frames."
                         "Since this is an optional frame, this is ok "
                         "and this message is just informational. If you intended, "
                         "to use them check that they have the %s tag.",
                         SPH_ZPL_TAG_DARK_CALIB_CAM1);
        cpl_error_reset();
    }

    else {

         rerr = cpl_frame_set_group( self->master_dark_frame_cam1, CPL_FRAME_GROUP_CALIB );
    }

    aframe = cpl_frameset_find( self->inframes, SPH_ZPL_TAG_DARK_CALIB_CAM2 );
    while ( aframe ) {
        cpl_frame_set_group( aframe, CPL_FRAME_GROUP_CALIB );
        aframe = cpl_frameset_find( self->inframes, NULL );
    }
    self->master_dark_frame_cam2 = sph_utils_extract_frame( self->inframes, SPH_ZPL_TAG_DARK_CALIB_CAM2 );
    if ( ! self->master_dark_frame_cam2 )
    {
        sph_error_raise( SPH_ZPL_POLARIZATION_FLAT_FRAMES_MISSING,
                         __FILE__, __func__, __LINE__ ,
                         SPH_ERROR_INFO,
                         "Could not extract master_dark_frame_cam2 frames."
                         "Since this is an optional frame, this is ok "
                         "and this message is just informational. If you intended, "
                         "to use them check that they have the %s tag.",
                         SPH_ZPL_TAG_DARK_CALIB_CAM2);
        cpl_error_reset();
    }

    else {

         rerr = cpl_frame_set_group( self->master_dark_frame_cam2, CPL_FRAME_GROUP_CALIB );
    }

    aframe = cpl_frameset_find( self->inframes, SPH_ZPL_TAG_IFF_CALIB );
    while ( aframe ) {
        cpl_frame_set_group( aframe, CPL_FRAME_GROUP_CALIB );
        aframe = cpl_frameset_find( self->inframes, NULL );
    }
    self->intensity_flat_frame = sph_utils_extract_frame( self->inframes, SPH_ZPL_TAG_IFF_CALIB );
    if ( ! self->intensity_flat_frame )
    {
        sph_error_raise( SPH_ZPL_POLARIZATION_FLAT_FRAMES_MISSING,
                         __FILE__, __func__, __LINE__ ,
                         SPH_ERROR_INFO,
                         "Could not extract intensity_flat_frame frames."
                         "Since this is an optional frame, this is ok "
                         "and this message is just informational. If you intended, "
                         "to use them check that they have the %s tag.",
                         SPH_ZPL_TAG_IFF_CALIB);
        cpl_error_reset();
    }

    else {

         rerr = cpl_frame_set_group( self->intensity_flat_frame, CPL_FRAME_GROUP_CALIB );
    }

    aframe = cpl_frameset_find( self->inframes, SPH_ZPL_TAG_IFF_CALIB_CAM1 );
    while ( aframe ) {
        cpl_frame_set_group( aframe, CPL_FRAME_GROUP_CALIB );
        aframe = cpl_frameset_find( self->inframes, NULL );
    }
    self->intensity_flat_frame_cam1 = sph_utils_extract_frame( self->inframes, SPH_ZPL_TAG_IFF_CALIB_CAM1 );
    if ( ! self->intensity_flat_frame_cam1 )
    {
        sph_error_raise( SPH_ZPL_POLARIZATION_FLAT_FRAMES_MISSING,
                         __FILE__, __func__, __LINE__ ,
                         SPH_ERROR_INFO,
                         "Could not extract intensity_flat_frame_cam1 frames."
                         "Since this is an optional frame, this is ok "
                         "and this message is just informational. If you intended, "
                         "to use them check that they have the %s tag.",
                         SPH_ZPL_TAG_IFF_CALIB_CAM1);
        cpl_error_reset();
    }

    else {

         rerr = cpl_frame_set_group( self->intensity_flat_frame_cam1, CPL_FRAME_GROUP_CALIB );
    }

    aframe = cpl_frameset_find( self->inframes, SPH_ZPL_TAG_IFF_CALIB_CAM2 );
    while ( aframe ) {
        cpl_frame_set_group( aframe, CPL_FRAME_GROUP_CALIB );
        aframe = cpl_frameset_find( self->inframes, NULL );
    }
    self->intensity_flat_frame_cam2 = sph_utils_extract_frame( self->inframes, SPH_ZPL_TAG_IFF_CALIB_CAM2 );
    if ( ! self->intensity_flat_frame_cam2 )
    {
        sph_error_raise( SPH_ZPL_POLARIZATION_FLAT_FRAMES_MISSING,
                         __FILE__, __func__, __LINE__ ,
                         SPH_ERROR_INFO,
                         "Could not extract intensity_flat_frame_cam2 frames."
                         "Since this is an optional frame, this is ok "
                         "and this message is just informational. If you intended, "
                         "to use them check that they have the %s tag.",
                         SPH_ZPL_TAG_IFF_CALIB_CAM2);
        cpl_error_reset();
    }

    else {

         rerr = cpl_frame_set_group( self->intensity_flat_frame_cam2, CPL_FRAME_GROUP_CALIB );
    }

    aframe = cpl_frameset_find( self->inframes, SPH_ZPL_TAG_IFFM_CALIB );
    while ( aframe ) {
        cpl_frame_set_group( aframe, CPL_FRAME_GROUP_CALIB );
        aframe = cpl_frameset_find( self->inframes, NULL );
    }
    self->intensity_flat_frame_master = sph_utils_extract_frame( self->inframes, SPH_ZPL_TAG_IFFM_CALIB );
    if ( ! self->intensity_flat_frame_master )
    {
        sph_error_raise( SPH_ZPL_POLARIZATION_FLAT_FRAMES_MISSING,
                         __FILE__, __func__, __LINE__ ,
                         SPH_ERROR_INFO,
                         "Could not extract intensity_flat_frame_master frames."
                         "Since this is an optional frame, this is ok "
                         "and this message is just informational. If you intended, "
                         "to use them check that they have the %s tag.",
                         SPH_ZPL_TAG_IFFM_CALIB);
        cpl_error_reset();
    }

    else {

         rerr = cpl_frame_set_group( self->intensity_flat_frame_master, CPL_FRAME_GROUP_CALIB );
    }

    aframe = cpl_frameset_find( self->inframes, SPH_ZPL_TAG_IFFM_CALIB_CAM1 );
    while ( aframe ) {
        cpl_frame_set_group( aframe, CPL_FRAME_GROUP_CALIB );
        aframe = cpl_frameset_find( self->inframes, NULL );
    }
    self->intensity_flat_frame_master_cam1 = sph_utils_extract_frame( self->inframes, SPH_ZPL_TAG_IFFM_CALIB_CAM1 );
    if ( ! self->intensity_flat_frame_master_cam1 )
    {
        sph_error_raise( SPH_ZPL_POLARIZATION_FLAT_FRAMES_MISSING,
                         __FILE__, __func__, __LINE__ ,
                         SPH_ERROR_INFO,
                         "Could not extract intensity_flat_frame_master_cam1 frames."
                         "Since this is an optional frame, this is ok "
                         "and this message is just informational. If you intended, "
                         "to use them check that they have the %s tag.",
                         SPH_ZPL_TAG_IFFM_CALIB_CAM1);
        cpl_error_reset();
    }

    else {

         rerr = cpl_frame_set_group( self->intensity_flat_frame_master_cam1, CPL_FRAME_GROUP_CALIB );
    }

    aframe = cpl_frameset_find( self->inframes, SPH_ZPL_TAG_IFFM_CALIB_CAM2 );
    while ( aframe ) {
        cpl_frame_set_group( aframe, CPL_FRAME_GROUP_CALIB );
        aframe = cpl_frameset_find( self->inframes, NULL );
    }
    self->intensity_flat_frame_master_cam2 = sph_utils_extract_frame( self->inframes, SPH_ZPL_TAG_IFFM_CALIB_CAM2 );
    if ( ! self->intensity_flat_frame_master_cam2 )
    {
        sph_error_raise( SPH_ZPL_POLARIZATION_FLAT_FRAMES_MISSING,
                         __FILE__, __func__, __LINE__ ,
                         SPH_ERROR_INFO,
                         "Could not extract intensity_flat_frame_master_cam2 frames."
                         "Since this is an optional frame, this is ok "
                         "and this message is just informational. If you intended, "
                         "to use them check that they have the %s tag.",
                         SPH_ZPL_TAG_IFFM_CALIB_CAM2);
        cpl_error_reset();
    }

    else {

         rerr = cpl_frame_set_group( self->intensity_flat_frame_master_cam2, CPL_FRAME_GROUP_CALIB );
    }

    /* End of code to check frames BUT ITS STILL NOT SAFE TO EDIT! FILE IS GENERATED !*/
    self->current_raw_frameset = sph_utils_extract_frames_group( self->inframes, CPL_FRAME_GROUP_RAW );

    return rerr;
}

/*----------------------------------------------------------------------------*/
/**
 @brief    Check the recipe parameters, and assign them to the sph_zpl_polarization_flat
           structure.
 @param    self     the sph_zpl_polarization_flat recipe structure
 @return   error code of the check.

 This checks the parameters that were given in the sph_zpl_polarization_flat_new function
 as parameters for the correctness and completeness. If the parameters needed are
 found they are also assigned to the corresponding structure members.

 The return value is the error code of the check.
 */
/*----------------------------------------------------------------------------*/
sph_error_code sph_zpl_polarization_flat_check_params( sph_zpl_polarization_flat* self ) {
    sph_error_code                 rerr               = CPL_ERROR_NONE;
    const cpl_parameter*           param              = NULL;

    if ( self->framecomb_parameterlist != NULL ) {
        cpl_parameterlist_delete( self->framecomb_parameterlist );
        self->framecomb_parameterlist = NULL;
    }
    self->framecomb_parameterlist = cpl_parameterlist_new();
    /* Code to check parameters GENERATED DO NOT EDIT */

    param = cpl_parameterlist_find_const( self->inparams,
                                          "zpl.polarization_flat.outfilename");
    if (param == NULL) {
        return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                     "Recipe parameter missing: "
                                     "zpl.polarization_flat.outfilename");
    }

    self->polarization_flat_outfilename = cpl_parameter_get_string(param);
    if (cpl_error_get_code()) {
        return cpl_error_set_where(cpl_func);
    }

    param = cpl_parameterlist_find_const( self->inparams,
                                          "zpl.polarization_flat.outfilename_cam1");
    if (param == NULL) {
        return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                     "Recipe parameter missing: "
                                     "zpl.polarization_flat.outfilename_cam1");
    }

    self->polarization_flat_outfilename_cam1 = cpl_parameter_get_string(param);
    if (cpl_error_get_code()) {
        return cpl_error_set_where(cpl_func);
    }

    param = cpl_parameterlist_find_const( self->inparams,
                                          "zpl.polarization_flat.outfilename_cam2");
    if (param == NULL) {
        return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                     "Recipe parameter missing: "
                                     "zpl.polarization_flat.outfilename_cam2");
    }

    self->polarization_flat_outfilename_cam2 = cpl_parameter_get_string(param);
    if (cpl_error_get_code()) {
        return cpl_error_set_where(cpl_func);
    }

    param = cpl_parameterlist_find_const( self->inparams,
                                          "zpl.polarization_flat.subtract_overscan");
    if (param == NULL) {
        return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                     "Recipe parameter missing: "
                                     "zpl.polarization_flat.subtract_overscan");
    }

    self->subtract_overscan = cpl_parameter_get_bool(param);
    if (cpl_error_get_code()) {
        return cpl_error_set_where(cpl_func);
    }

    param = cpl_parameterlist_find_const( self->inparams,
                                          "zpl.polarization_flat.coll_alg");
    if (param == NULL) {
        return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                     "Recipe parameter missing: "
                                     "zpl.polarization_flat.coll_alg");
    }

    self->coll_alg = cpl_parameter_get_int(param);
    if (cpl_error_get_code()) {
        return cpl_error_set_where(cpl_func);
    }

    param = cpl_parameterlist_find_const( self->inparams,
                                          "zpl.polarization_flat.coll_alg.clean_mean.reject_high");
    if (param == NULL) {
        return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                     "Recipe parameter missing: "
                                     "zpl.polarization_flat.coll_alg.clean_mean.reject_high");
    }

    self->clean_mean_reject_high = cpl_parameter_get_int(param);
    if (cpl_error_get_code()) {
        return cpl_error_set_where(cpl_func);
    }

    cpl_parameterlist_append( self->framecomb_parameterlist,
                              cpl_parameter_new_range( "clean_mean.reject_high",
                                                       CPL_TYPE_INT,
                                                       NULL,
                                                       NULL,
                                                       cpl_parameter_get_int( param ) ,
                                                       0,20
                                                      )
                            );

    param = cpl_parameterlist_find_const( self->inparams,
                                          "zpl.polarization_flat.coll_alg.clean_mean.reject_low");
    if (param == NULL) {
        return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                     "Recipe parameter missing: "
                                     "zpl.polarization_flat.coll_alg.clean_mean.reject_low");
    }

    self->clean_mean_reject_low = cpl_parameter_get_int(param);
    if (cpl_error_get_code()) {
        return cpl_error_set_where(cpl_func);
    }

    cpl_parameterlist_append( self->framecomb_parameterlist,
                              cpl_parameter_new_range( "clean_mean.reject_low",
                                                       CPL_TYPE_INT,
                                                       NULL,
                                                       NULL,
                                                       cpl_parameter_get_int( param ) ,
                                                       0,20
                                                      )
                            );

    param = cpl_parameterlist_find_const( self->inparams,
                                          "zpl.polarization_flat.keep_intermediate");
    if (param == NULL) {
        return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                     "Recipe parameter missing: "
                                     "zpl.polarization_flat.keep_intermediate");
    }

    self->keep_intermediate = cpl_parameter_get_bool(param);
    if (cpl_error_get_code()) {
        return cpl_error_set_where(cpl_func);
    }

    param = cpl_parameterlist_find_const( self->inparams,
                                          "zpl.preproc.outfilename_cam1");
    if (param == NULL) {
        return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                     "Recipe parameter missing: "
                                     "zpl.preproc.outfilename_cam1");
    }

    self->outfilename_cam1 = cpl_parameter_get_string(param);
    if (cpl_error_get_code()) {
        return cpl_error_set_where(cpl_func);
    }

    param = cpl_parameterlist_find_const( self->inparams,
                                          "zpl.preproc.outfilename_cam2");
    if (param == NULL) {
        return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                     "Recipe parameter missing: "
                                     "zpl.preproc.outfilename_cam2");
    }

    self->outfilename_cam2 = cpl_parameter_get_string(param);
    if (cpl_error_get_code()) {
        return cpl_error_set_where(cpl_func);
    }

    /* End of code to check parameters BUT ITS STILL NOT SAFE TO EDIT! FILE IS GENERATED !*/

    return rerr;
}
/*----------------------------------------------------------------------------*/
/**
 @brief    Create a new sph_zpl_polarization_flat structure.

 @param    frameset     the input recipe frames
 @param    parlist      the input recipe parameters

 @return   pointer to newly created structure or NULL in case of error

 This creates a new sph_zpl_polarization_flat_structure and fills the inparams and
 inframes fields with the pointers pf frameset and parlist.
 The return value is the error code of the check.
 */
/*----------------------------------------------------------------------------*/
sph_zpl_polarization_flat* sph_zpl_polarization_flat_new( cpl_frameset * frameset,
                                              cpl_parameterlist * parlist )
{
    sph_zpl_polarization_flat*    result      = NULL;
    int                     rerr        = CPL_ERROR_NONE;

    sph_init_erex();
    if ( frameset == NULL || parlist == NULL ) {
        sph_error_raise( CPL_ERROR_NULL_INPUT, __FILE__,
                         __func__, __LINE__,
                         SPH_ERROR_ERROR,
                         "Null input pointer.");
        return NULL;
    }

    result = cpl_calloc( 1, sizeof(sph_zpl_polarization_flat) );

    if ( result == NULL ) {
        sph_error_raise( SPH_ZPL_POLARIZATION_FLAT_GENERAL, __FILE__, __func__,
                         __LINE__, SPH_ERROR_ERROR,
                         "Could not allocate the structure.");
        return result;
    }

    result->inframes = frameset;
    result->inparams = parlist;

    rerr = sph_zpl_polarization_flat_check_frames( result );
    if ( rerr == CPL_ERROR_NONE) rerr = sph_zpl_polarization_flat_check_params( result );

    if ( rerr != CPL_ERROR_NONE ) {
        if ( result ) {
            sph_zpl_polarization_flat_delete( result );
        }
        result = NULL;
    }

    return result;
}

/*----------------------------------------------------------------------------*/
/**
 @brief    Delete the sph_zpl_polarization_flat structure.

 @param    self         the structure tp delete

 @return   error code of the operation

 This creates a new sph_zpl_polarization_flat_structure and fills the inparams and
 inframes fields with the pointers pf frameset and parlist.
 The return value is the error code of the check.
 */
/*----------------------------------------------------------------------------*/
sph_error_code sph_zpl_polarization_flat_delete( sph_zpl_polarization_flat* self )
{
    sph_error_code          rerr            = CPL_ERROR_NONE;

    if ( self == NULL ) {
        sph_error_raise( CPL_ERROR_NULL_INPUT, __FILE__,
                         __func__, __LINE__,
                         SPH_ERROR_ERROR,
                         "Null input pointer.");
        return rerr;
    }

    if ( self->framecomb_parameterlist != NULL ) {
        cpl_parameterlist_delete( self->framecomb_parameterlist );
        self->framecomb_parameterlist = NULL;
    }

    /* Code to delete recipe pointers GENERATED DO NOT EDIT */

    if ( self->rawframes != NULL ) {
        cpl_frameset_delete( self->rawframes );
        self->rawframes = NULL;
    }
    if ( self->preproc_frames != NULL ) {
        cpl_frameset_delete( self->preproc_frames );
        self->preproc_frames = NULL;
    }
    if ( self->preproc_frames_cam1 != NULL ) {
        cpl_frameset_delete( self->preproc_frames_cam1 );
        self->preproc_frames_cam1 = NULL;
    }
    if ( self->preproc_frames_cam2 != NULL ) {
        cpl_frameset_delete( self->preproc_frames_cam2 );
        self->preproc_frames_cam2 = NULL;
    }
    if ( self->master_bias_frame != NULL ) {
        cpl_frame_delete( self->master_bias_frame );
        self->master_bias_frame = NULL;
    }
    if ( self->master_bias_frame_cam1 != NULL ) {
        cpl_frame_delete( self->master_bias_frame_cam1 );
        self->master_bias_frame_cam1 = NULL;
    }
    if ( self->master_bias_frame_cam2 != NULL ) {
        cpl_frame_delete( self->master_bias_frame_cam2 );
        self->master_bias_frame_cam2 = NULL;
    }
    if ( self->master_dark_frame != NULL ) {
        cpl_frame_delete( self->master_dark_frame );
        self->master_dark_frame = NULL;
    }
    if ( self->master_dark_frame_cam1 != NULL ) {
        cpl_frame_delete( self->master_dark_frame_cam1 );
        self->master_dark_frame_cam1 = NULL;
    }
    if ( self->master_dark_frame_cam2 != NULL ) {
        cpl_frame_delete( self->master_dark_frame_cam2 );
        self->master_dark_frame_cam2 = NULL;
    }
    if ( self->intensity_flat_frame != NULL ) {
        cpl_frame_delete( self->intensity_flat_frame );
        self->intensity_flat_frame = NULL;
    }
    if ( self->intensity_flat_frame_cam1 != NULL ) {
        cpl_frame_delete( self->intensity_flat_frame_cam1 );
        self->intensity_flat_frame_cam1 = NULL;
    }
    if ( self->intensity_flat_frame_cam2 != NULL ) {
        cpl_frame_delete( self->intensity_flat_frame_cam2 );
        self->intensity_flat_frame_cam2 = NULL;
    }
    if ( self->intensity_flat_frame_master != NULL ) {
        cpl_frame_delete( self->intensity_flat_frame_master );
        self->intensity_flat_frame_master = NULL;
    }
    if ( self->intensity_flat_frame_master_cam1 != NULL ) {
        cpl_frame_delete( self->intensity_flat_frame_master_cam1 );
        self->intensity_flat_frame_master_cam1 = NULL;
    }
    if ( self->intensity_flat_frame_master_cam2 != NULL ) {
        cpl_frame_delete( self->intensity_flat_frame_master_cam2 );
        self->intensity_flat_frame_master_cam2 = NULL;
    }
 
    sph_double_image_delete(self->polarization_flat_field);
    sph_double_image_delete(self->polarization_flat_field_cam1);
    sph_double_image_delete(self->polarization_flat_field_cam2);
    /* End of code to delete pointers BUT ITS STILL NOT SAFE TO EDIT! FILE IS GENERATED !*/
    if ( self->current_raw_frameset ) {
        cpl_frameset_delete(self->current_raw_frameset);
        self->current_raw_frameset = NULL;
    }
    sph_polygon_free_all();
    cpl_free(    self);
    return rerr;

}


/**@}*/
