/* $Id: $
 * This file is part of the SPHERE Pipeline
 * Copyright (C) 2007-2010 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 * $Author: $
 * $Date: $
 * $Revision: $
 * $Name: $
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

/*-----------------------------------------------------------------------------
 Includes
 -----------------------------------------------------------------------------*/
#include <cpl.h>
#include "sph_error.h"
#include "sph_psfcube.h"
#ifndef SPH_ANDROMEDA_CORE_H_
#define SPH_ANDROMEDA_CORE_H_


typedef struct _sph_andromeda_core_ {
    sph_psfcube*        psfcube;
    cpl_bivector*       indices;
    cpl_vector*         angles;
    cpl_imagelist*      imlist;
    int                 nx;
    int                 ny;
    int                 minx;
    int                 maxx;
    int                 miny;
    int                 maxy;
    int                 posleft;
    int                 posbot;
    int                 negleft;
    int                 negbot;
    double              possubx;
    double              possuby;
    double              negsubx;
    double              negsuby;
} sph_andromeda_core;

cpl_image*
sph_andromeda_core_get_weight_2D( cpl_imagelist* diffims, int hom );

cpl_image*
sph_andromeda_core_get_flux(
        cpl_imagelist* diffimages,
        cpl_vector* posind,
        cpl_vector* negind,
        cpl_vector* angles,
        sph_psfcube* psfcube,
        int  hom_var,
        cpl_imagelist* weights,
        double rhomin,
        double rhomax,
        cpl_vector* gamma,
        int positivity,
        cpl_image* mask,
        cpl_image** snr,
        cpl_image** likelyhood,
        cpl_image** std
        );
#endif /* SPH_ANDROMEDA_CORE_H_ */
