/* $Id: $
 * This file is part of the SPHERE Pipeline
 * Copyright (C) 2007-2010 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 * $Author: $
 * $Date: $
 * $Revision: $
 * $Name: $
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

/*-----------------------------------------------------------------------------
 Includes
 -----------------------------------------------------------------------------*/
#include <cpl.h>
#include "sph_error.h"
#ifndef SPH_APERTURES_H_
#define SPH_APERTURES_H_
double
sph_apertures_get_width_y_pdt( cpl_apertures* aps, int n,
		sph_pixel_description_table* pdt, sph_master_frame* mframe );

double
sph_apertures_get_lambda( cpl_apertures* aps, int n,
		sph_pixel_description_table* pdt);
double
sph_apertures_get_width_x( cpl_apertures* aps, int n,
		sph_master_frame* mframe );
double
sph_apertures_get_width_y( cpl_apertures* aps, int n,
		sph_master_frame* mframe );
#endif /* SPH_APERTURES_H_ */
