/* $Id: $
 * This file is part of the SPHERE Pipeline
 * Copyright (C) 2007-2010 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 * $Author: $
 * $Date: $
 * $Revision: $
 * $Name: $
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

/*-----------------------------------------------------------------------------
 Includes
 -----------------------------------------------------------------------------*/
#include <cpl.h>
#include "sph_error.h"
#include "sph_raw_image_corrector_data.h"
#ifndef SPH_BADPIXELCO_H_
#define SPH_BADPIXELCO_H_

cpl_error_code
sph_badpixelco_apply_to_raw_cube(
		cpl_frameset* allframes,
		cpl_frame* raw_cube_frame,
		cpl_size border,
		double thresh_factor,
		double thresh_absolute);

cpl_image* sph_badpixelco_correct_image(cpl_size border,
		double thresh_factor, double thresh_absolute,
		cpl_image* image);

cpl_error_code
sph_badpixelco_correct_image_in_place(sph_raw_image_corrector_data* data,cpl_image** image);

cpl_vector*
sph_badpixelco_get_medians_for_rows( cpl_image* image, cpl_size border );

cpl_error_code
sph_badpixelco_correct_single_pixel_entire_row(
		const cpl_image* image_to_correct,
		const cpl_vector* medians,
		double thresh_factor,
		double thresh_absolute,
		cpl_size x,
		cpl_size y,
		cpl_image* result_image);

cpl_error_code
sph_badpixelco_correct_single_pixel(
		const cpl_image* badpix_image,
		const cpl_image* image_to_correct,
		cpl_size badpix_row_coord,
		cpl_size badpix_col_coord,
		cpl_image* result_image);

cpl_size
sph_badpixelco_fill_cx_cy_vectors(
		const cpl_image* badimage,
		cpl_vector** cx,
		cpl_vector** cy );

#endif /* SPH_BADPIXELCO_H_ */
