/* $Id: $
 * This file is part of the SPHERE Pipeline
 * Copyright (C) 2007-2010 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 * $Author: $
 * $Date: $
 * $Revision: $
 * $Name: $
 */
/*---------------------------------------------------------------------------*/
/*
 * The keywords and corresponding allowed values for SPHERE in general are
 * defined in this file.
 * Keywords and values specific to all SPHERE instruments are
 * defined in under src/Recipes/<INS>/sph_<ins>_keywords.h
 */
/*---------------------------------------------------------------------------*/

#ifndef SPH_COMMON_KEYWORDS_H_
#define SPH_COMMON_KEYWORDS_H_

/*---------------------------------------------------------------------------*/
/*
 * Definition of common ESO keywords and values
 */
/*---------------------------------------------------------------------------*/
#define SPH_COMMON_KEYWORD_MD5                         "ESO DATAMD5"
#define SPH_COMMON_KEYWORD_PRO_CATG                    "ESO PRO CATG"
#define SPH_COMMON_KEYWORD_DPR_CATG                    "ESO DPR CATG"
#define SPH_COMMON_KEYWORD_DPR_TYPE                    "ESO DPR TYPE"
#define SPH_COMMON_KEYWORD_DPR_TECH                    "ESO DPR TECH"
#define SPH_COMMON_KEYWORD_EXPTIME                     "ESO DET DIT"
#define SPH_COMMON_KEYWORD_EXPTIME2                    "EXPTIME"
#define SPH_COMMON_KEYWORD_SEQ1DIT                     "ESO DET SEQ1 DIT"
#define SPH_COMMON_KEYWORD_DIT                         "ESO DET DIT1"
#define SPH_COMMON_KEYWORD_NDIT                        "ESO DET NDIT"
#define SPH_COMMON_KEYWORD_NDSAMPLES                   "ESO DET NDSAMPLES"
#define SPH_COMMON_KEYWORD_READ_CURID                  "ESO DET READ CURID"
#define SPH_COMMON_KEYWORD_DATE                        "DATE"
#define SPH_COMMON_KEYWORD_NREADS                      "ESO NREADS"
#define SPH_COMMON_KEYWORD_MJD_OBS					   "MJD-OBS"
#define SPH_COMMON_KEYWORD_DET_FRAM_UTC				   "ESO DET FRAM UTC"
#define SPH_COMMON_KEYWORD_UTC                         "UTC"
#define SPH_COMMON_KEYWORD_DATE_OBS                    "DATE-OBS"

#define SPH_COMMON_KEYWORD_DETECTOR_NAME  		       "ESO DET NAME"
#define SPH_COMMON_KEYWORD_IFS_DETECTOR_NAME           "IFS"
#define SPH_COMMON_KEYWORD_IRDIS_DETECTOR_NAME         "IRDIS"

#define SPH_COMMON_KEYWORD_AIRMASS_START               "ESO TEL AIRM START"
#define SPH_COMMON_KEYWORD_AIRMASS_END                 "ESO TEL AIRM END"

#define SPH_COMMON_KEYWORD_EXTNAME					   				"EXTNAME"
#define SPH_COMMON_KEYWORD_VALUE_MASTER_FRAME_IMAGE_EXTNAME			"IMAGE"
#define SPH_COMMON_KEYWORD_VALUE_MASTER_FRAME_BADPIXMAP_EXTNAME		"BADPIXELMAP"
#define SPH_COMMON_KEYWORD_VALUE_MASTER_FRAME_NCOMBMAP_EXTNAME		"NCOMBMAP"
#define SPH_COMMON_KEYWORD_VALUE_MASTER_FRAME_RMSMAP_EXTNAME		"RMSMAP"

#define SPH_COMMON_KEYWORD_VALUE_DOUBLE_IMAGE_IFRAME_IMAGE_EXTNAME		"IMAGE"
#define SPH_COMMON_KEYWORD_VALUE_DOUBLE_IMAGE_IFRAME_BADPIXMAP_EXTNAME	"BADPIXELMAP"
#define SPH_COMMON_KEYWORD_VALUE_DOUBLE_IMAGE_IFRAME_NCOMBMAP_EXTNAME	"NCOMBMAP"
#define SPH_COMMON_KEYWORD_VALUE_DOUBLE_IMAGE_IFRAME_RMSMAP_EXTNAME		"RMSMAP"

#define SPH_COMMON_KEYWORD_VALUE_DOUBLE_IMAGE_PFRAME_IMAGE_EXTNAME		"IMAGE"
#define SPH_COMMON_KEYWORD_VALUE_DOUBLE_IMAGE_PFRAME_BADPIXMAP_EXTNAME	"BADPIXELMAP"
#define SPH_COMMON_KEYWORD_VALUE_DOUBLE_IMAGE_PFRAME_NCOMBMAP_EXTNAME	"NCOMBMAP"
#define SPH_COMMON_KEYWORD_VALUE_DOUBLE_IMAGE_PFRAME_RMSMAP_EXTNAME		"RMSMAP"

#define SPH_COMMON_KEYWORD_VALUE_QUAD_IMAGE_ZERO_IFRAME_IMAGE_EXTNAME		"PHASE-0.ODD.IMAGE"
#define SPH_COMMON_KEYWORD_VALUE_QUAD_IMAGE_ZERO_IFRAME_BADPIXMAP_EXTNAME	"PHASE-0.ODD.BADPIXELMAP"
#define SPH_COMMON_KEYWORD_VALUE_QUAD_IMAGE_ZERO_IFRAME_NCOMBMAP_EXTNAME	"PHASE-0.ODD.NCOMBMAP"
#define SPH_COMMON_KEYWORD_VALUE_QUAD_IMAGE_ZERO_IFRAME_RMSMAP_EXTNAME		"PHASE-0.ODD.RMSMAP"

#define SPH_COMMON_KEYWORD_VALUE_QUAD_IMAGE_ZERO_PFRAME_IMAGE_EXTNAME		"PHASE-0.EVEN.IMAGE"
#define SPH_COMMON_KEYWORD_VALUE_QUAD_IMAGE_ZERO_PFRAME_BADPIXMAP_EXTNAME	"PHASE-0.EVEN.BADPIXELMAP"
#define SPH_COMMON_KEYWORD_VALUE_QUAD_IMAGE_ZERO_PFRAME_NCOMBMAP_EXTNAME	"PHASE-0.EVEN.NCOMBMAP"
#define SPH_COMMON_KEYWORD_VALUE_QUAD_IMAGE_ZERO_PFRAME_RMSMAP_EXTNAME		"PHASE-0.EVEN.RMSMAP"

#define SPH_COMMON_KEYWORD_VALUE_QUAD_IMAGE_PI_IFRAME_IMAGE_EXTNAME		"PHASE-PI.ODD.IMAGE"
#define SPH_COMMON_KEYWORD_VALUE_QUAD_IMAGE_PI_IFRAME_BADPIXMAP_EXTNAME	"PHASE-PI.ODD.BADPIXELMAP"
#define SPH_COMMON_KEYWORD_VALUE_QUAD_IMAGE_PI_IFRAME_NCOMBMAP_EXTNAME	"PHASE-PI.ODD.NCOMBMAP"
#define SPH_COMMON_KEYWORD_VALUE_QUAD_IMAGE_PI_IFRAME_RMSMAP_EXTNAME	"PHASE-PI.ODD.RMSMAP"

#define SPH_COMMON_KEYWORD_VALUE_QUAD_IMAGE_PI_PFRAME_IMAGE_EXTNAME		"PHASE-PI.EVEN.IMAGE"
#define SPH_COMMON_KEYWORD_VALUE_QUAD_IMAGE_PI_PFRAME_BADPIXMAP_EXTNAME	"PHASE-PI.EVEN.BADPIXELMAP"
#define SPH_COMMON_KEYWORD_VALUE_QUAD_IMAGE_PI_PFRAME_NCOMBMAP_EXTNAME	"PHASE-PI.EVEN.NCOMBMAP"
#define SPH_COMMON_KEYWORD_VALUE_QUAD_IMAGE_PI_PFRAME_RMSMAP_EXTNAME	"PHASE-PI.EVEN.RMSMAP"


#define SPH_COMMON_KEYWORD_VALUE_PDT_SPECID_EXTNAME			"PDT.SPECID"
#define SPH_COMMON_KEYWORD_VALUE_PDT_LENSID_EXTNAME			"PDT.LENSID"
#define SPH_COMMON_KEYWORD_VALUE_PDT_WAVELENGTH_EXTNAME		"PDT.WAVELENGTH"
#define SPH_COMMON_KEYWORD_VALUE_PDT_DLAMBDA_EXTNAME		"PDT.DLAMBDA"
#define SPH_COMMON_KEYWORD_VALUE_PDT_DDLAMBDA_EXTNAME		"PDT.DDLAMBDA"
#define SPH_COMMON_KEYWORD_VALUE_PDT_ILLUMINATION_EXTNAME	"PDT.ILLUMINATION"
#define SPH_COMMON_KEYWORD_VALUE_PDT_BADIMAGE_EXTNAME	    "PDT.BADSPECTRA"
#define SPH_COMMON_KEYWORD_203_TEMP                         "ESO INS2 TEMP203 VAL"



//descr Mean value of a master frame
#define SPH_COMMON_KEYWORD_QC_MEANMASTERFRAME_COMMENT  "Mean value of a master frame [1]"
#define SPH_COMMON_KEYWORD_QC_MEANMASTERFRAME          "ESO QC MEANMASTER"
//descr Median value of a master frame
#define SPH_COMMON_KEYWORD_QC_MEDIANMASTERFRAME_COMMENT "Median value of a master frame[1]"
#define SPH_COMMON_KEYWORD_QC_MEDIANMASTERFRAME         "ESO QC MEDIANMASTER"
//descr RMS of a master frame
#define SPH_COMMON_KEYWORD_QC_RMSMASTERFRAME_COMMENT   "RMS of a master frame[1]"
#define SPH_COMMON_KEYWORD_QC_RMSMASTERFRAME           "ESO QC RMSMASTER"
//descr Determined bias level (ADU)
#define SPH_COMMON_KEYWORD_QC_BIAS_COMMENT             "Determined bias level [ADU]"
#define SPH_COMMON_KEYWORD_QC_BIAS                     "ESO QC BIAS"
//descr Determined read-out noise (ADU)
#define SPH_COMMON_KEYWORD_QC_RON_COMMENT              "Determined read-out noise [ADU]"
#define SPH_COMMON_KEYWORD_QC_RON                      "ESO QC RON"
//descr RMS of determined read-out noise (ADU)
#define SPH_COMMON_KEYWORD_QC_RON_RMS_COMMENT          "RMS of determined read-outnoise [ADU]"
#define SPH_COMMON_KEYWORD_QC_RON_RMS                  "ESO QC RON RMS"
//descr Determined gain (e-/ADU)
#define SPH_COMMON_KEYWORD_QC_GAIN_COMMENT             "Determined gain [e-/ADU]"
#define SPH_COMMON_KEYWORD_QC_GAIN                     "ESO QC GAIN"
//descr Determined RMS of gain (e-/ADU)
#define SPH_COMMON_KEYWORD_QC_GAIN_RMS_COMMENT         "Determined RMS of gain [e-/ADU]"
#define SPH_COMMON_KEYWORD_QC_GAIN_RMS                 "ESO QC GAIN RMS"
#define SPH_COMMON_KEYWORD_QC_GAIN_SIGNAL_COMMENT      "Signal of gain [ADU](unused)"
#define SPH_COMMON_KEYWORD_QC_GAIN_SIGNAL              "ESO QC MON SIGNAL"
#define SPH_COMMON_KEYWORD_QC_GAIN_SQ_NOISE_COMMENT    "Square noise of gain [ADU](unused)"
#define SPH_COMMON_KEYWORD_QC_GAIN_SQ_NOISE            "ESO QC MON NOISE"
//descr saturation signal remainder after 1s
#define SPH_COMMON_KEYWORD_QC_PERSISTENCE_ONES_COMMENT    "saturation signal remainder after 1s[ADU](unused)"
#define SPH_COMMON_KEYWORD_QC_PERSISTENCE_ONES            "ESO QC PERSISTENCE 1S"
//descr saturation signal remainder after 5s
#define SPH_COMMON_KEYWORD_QC_PERSISTENCE_FIVES_COMMENT  "saturation signal remainder after 5s[ADU](unused)"
#define SPH_COMMON_KEYWORD_QC_PERSISTENCE_FIVES          "ESO QC PERSISTENCE 5S"
//descr saturation signal remainder after 10s
#define SPH_COMMON_KEYWORD_QC_PERSISTENCE_TENS_COMMENT   "saturation signal remainder after 10s [ADU](unused)"
#define SPH_COMMON_KEYWORD_QC_PERSISTENCE_TENS           "ESO QC PERSISTENCE 10S"
//descr RMS of saturation signal
#define SPH_COMMON_KEYWORD_QC_PERSISTENCE_RMS_COMMENT    "RMS of saturation signal [ADU](unused)"
#define SPH_COMMON_KEYWORD_QC_PERSISTENCE_RMS            "ESO QC PERSISTENCE RMS"
//descr persistence coefficient
#define SPH_COMMON_KEYWORD_QC_PERSISTENCE_COEFF_COMMENT  "persistence coefficient [1](unused)"
#define SPH_COMMON_KEYWORD_QC_PERSISTENCE_COEFF          "ESO QC PERSISTENCE COEFF"
//descr RMS of persistence coefficient
#define SPH_COMMON_KEYWORD_QC_PERSISTENCE_COEFF_RMS_COMMENT "RMS of persistence coefficient [1](unused)"
#define SPH_COMMON_KEYWORD_QC_PERSISTENCE_COEFF_RMS         "ESO QC PERSISTENCE COEFF RMS"

#define SPH_QC_PERSIST      "ESO QC PERSIST"
#define SPH_QC_PERSIST_NORM "ESO QC PERSISTNORM"

//descr Mean value of an intensity double image (ZIMPOL)
#define SPH_COMMON_KEYWORD_QC_MEAN_DOUBLEIMAGE_IFRAME_COMMENT "Mean value of an intensity double image (ZIMPOL)[ADU]"
#define SPH_COMMON_KEYWORD_QC_MEAN_DOUBLEIMAGE_IFRAME  		  "ESO QC DOUBLE IMAGE IFRAME MEAN"
//descr Median value of an intensity double image (ZIMPOL)
#define SPH_COMMON_KEYWORD_QC_MEDIAN_DOUBLEIMAGE_IFRAME_COMMENT "Median value of an intensity double image (ZIMPOL)[ADU]"
#define SPH_COMMON_KEYWORD_QC_MEDIAN_DOUBLEIMAGE_IFRAME 	    "ESO QC DOUBLE IMAGE IFRAME MEDIAN"
//descr RMS of an intensity double image (ZIMPOL)
#define SPH_COMMON_KEYWORD_QC_RMS_DOUBLEIMAGE_IFRAME_COMMENT    "RMS of an intensity double image (ZIMPOL)[ADU]"
#define SPH_COMMON_KEYWORD_QC_RMS_DOUBLEIMAGE_IFRAME		    "ESO QC DOUBLE IMAGE IFRAME RMS"
//descr Mean value of a polarization degree double image (ZIMPOL)
#define SPH_COMMON_KEYWORD_QC_MEAN_DOUBLEIMAGE_PFRAME_COMMENT   "Mean value of a polarization degree double image (ZIMPOL)[1]"
#define SPH_COMMON_KEYWORD_QC_MEAN_DOUBLEIMAGE_PFRAME     	    "ESO QC DOUBLE IMAGE PFRAME MEAN"
//descr Medan value of a polarization degree double image (ZIMPOL)
#define SPH_COMMON_KEYWORD_QC_MEDIAN_DOUBLEIMAGE_PFRAME_COMMENT "Median value of a polarization degree double image (ZIMPOL)[1]"
#define SPH_COMMON_KEYWORD_QC_MEDIAN_DOUBLEIMAGE_PFRAME   	    "ESO QC DOUBLE IMAGE PFRAME MEDIAN"
//descr RMS of a polarization degree double image (ZIMPOL)
#define SPH_COMMON_KEYWORD_QC_RMS_DOUBLEIMAGE_PFRAME_COMMENT    "RMS of a polarization degree double image (ZIMPOL)[1]"
#define SPH_COMMON_KEYWORD_QC_RMS_DOUBLEIMAGE_PFRAME  		    "ESO QC DOUBLE IMAGE PFRAME RMS"
//descr Mean value of an intensity triple image (ZIMPOL)
#define SPH_COMMON_KEYWORD_QC_MEAN_TRIPLEIMAGE_IFRAME_COMMENT   "Mean value of an intensity triple image (ZIMPOL)[ADU]"
#define SPH_COMMON_KEYWORD_QC_MEAN_TRIPLEIMAGE_IFRAME  		    "ESO QC TRIPLE IMAGE IFRAME MEAN"
//descr Median value of an intensity triple image (ZIMPOL)
#define SPH_COMMON_KEYWORD_QC_MEDIAN_TRIPLEIMAGE_IFRAME_COMMENT "Median value of an intensity triple image (ZIMPOL)[ADU]"
#define SPH_COMMON_KEYWORD_QC_MEDIAN_TRIPLEIMAGE_IFRAME 	    "ESO QC TRIPLE IMAGE IFRAME MEDIAN"
//descr RMS of an intensity triple image (ZIMPOL)
#define SPH_COMMON_KEYWORD_QC_RMS_TRIPLEIMAGE_IFRAME_COMMENT    "RMS of an intensity triple image (ZIMPOL)[ADU]"
#define SPH_COMMON_KEYWORD_QC_RMS_TRIPLEIMAGE_IFRAME		    "ESO QC TRIPLE IMAGE IFRAME RMS"
//descr Mean value of a Q triple image (ZIMPOL)
#define SPH_COMMON_KEYWORD_QC_MEAN_TRIPLEIMAGE_QFRAME_COMMENT   "Mean value of a Q triple image (ZIMPOL)[1]"
#define SPH_COMMON_KEYWORD_QC_MEAN_TRIPLEIMAGE_QFRAME     	    "ESO QC TRIPLE IMAGE QFRAME MEAN"
//descr Median value of a Q triple image (ZIMPOL)
#define SPH_COMMON_KEYWORD_QC_MEDIAN_TRIPLEIMAGE_QFRAME_COMMENT "Median value of a Q triple image (ZIMPOL)[1]"
#define SPH_COMMON_KEYWORD_QC_MEDIAN_TRIPLEIMAGE_QFRAME   	    "ESO QC TRIPLE IMAGE QFRAME MEDIAN"
//descr RMS of a Q triple image (ZIMPOL)
#define SPH_COMMON_KEYWORD_QC_RMS_TRIPLEIMAGE_QFRAME_COMMENT    "RMS of a Q triple image (ZIMPOL)[1]"
#define SPH_COMMON_KEYWORD_QC_RMS_TRIPLEIMAGE_QFRAME  		    "ESO QC TRIPLE IMAGE QFRAME RMS"
//descr Mean value of a U triple image (ZIMPOL)
#define SPH_COMMON_KEYWORD_QC_MEAN_TRIPLEIMAGE_UFRAME_COMMENT   "Mean value of a U triple image (ZIMPOL)[1]"
#define SPH_COMMON_KEYWORD_QC_MEAN_TRIPLEIMAGE_UFRAME     	    "ESO QC TRIPLE IMAGE UFRAME MEAN"
//descr Median value of a U triple image (ZIMPOL)
#define SPH_COMMON_KEYWORD_QC_MEDIAN_TRIPLEIMAGE_UFRAME_COMMENT "Median value of a U triple image (ZIMPOL)[1]"
#define SPH_COMMON_KEYWORD_QC_MEDIAN_TRIPLEIMAGE_UFRAME   	    "ESO QC TRIPLE IMAGE UFRAME MEDIAN"
//descr RMS of a U triple image (ZIMPOL)
#define SPH_COMMON_KEYWORD_QC_RMS_TRIPLEIMAGE_UFRAME_COMMENT    "RMS a U triple image (ZIMPOL)[1]"
#define SPH_COMMON_KEYWORD_QC_RMS_TRIPLEIMAGE_UFRAME  		    "ESO QC TRIPLE IMAGE UFRAME RMS"

//descr Mean value of a zero-odd quadimage (ZIMPOL)
#define SPH_COMMON_KEYWORD_QC_MEAN_QUADIMAGE_ZERO_ODD_COMMENT   "Mean value of a zero-odd quadimage [ADU]"
#define SPH_COMMON_KEYWORD_QC_MEAN_QUADIMAGE_ZERO_ODD  		    "ESO QC QUAD IMAGE ZERO ODD MEAN"
//descr Median value of a zero-odd quadimage (ZIMPOL)
#define SPH_COMMON_KEYWORD_QC_MEDIAN_QUADIMAGE_ZERO_ODD_COMMENT "Median value of a zero-odd quadimage [ADU]"
#define SPH_COMMON_KEYWORD_QC_MEDIAN_QUADIMAGE_ZERO_ODD 	    "ESO QC QUAD IMAGE ZERO ODD MEDIAN"
//descr RMS of a zero-odd quadimage (ZIMPOL)
#define SPH_COMMON_KEYWORD_QC_RMS_QUADIMAGE_ZERO_ODD_COMMENT    "RMS of a zero-odd quadimage [ADU]"
#define SPH_COMMON_KEYWORD_QC_RMS_QUADIMAGE_ZERO_ODD		    "ESO QC QUAD IMAGE ZERO ODD RMS"
//descr Mean value of a zero-even quadimage (ZIMPOL)
#define SPH_COMMON_KEYWORD_QC_MEAN_QUADIMAGE_ZERO_EVEN_COMMENT  "Mean value of a zero-even quadimage [ADU]"
#define SPH_COMMON_KEYWORD_QC_MEAN_QUADIMAGE_ZERO_EVEN     	    "ESO QC QUAD IMAGE ZERO EVEN MEAN"
//descr Median value of a zero-even quadimage (ZIMPOL)
#define SPH_COMMON_KEYWORD_QC_MEDIAN_QUADIMAGE_ZERO_EVEN_COMMENT "Median value of a zero-even quadimage [ADU]"
#define SPH_COMMON_KEYWORD_QC_MEDIAN_QUADIMAGE_ZERO_EVEN   	     "ESO QC QUAD IMAGE ZERO EVEN MEDIAN"
//descr RMS of a zero-even quadimage (ZIMPOL)
#define SPH_COMMON_KEYWORD_QC_RMS_QUADIMAGE_ZERO_EVEN_COMMENT    "RMS of a zero-even quadimage [ADU]"
#define SPH_COMMON_KEYWORD_QC_RMS_QUADIMAGE_ZERO_EVEN  		     "ESO QC QUAD IMAGE ZERO EVEN RMS"
//descr Mean value of a pi-odd quadimage (ZIMPOL)
#define SPH_COMMON_KEYWORD_QC_MEAN_QUADIMAGE_PI_ODD_COMMENT      "Mean value of a pi-odd quadimage [ADU]"
#define SPH_COMMON_KEYWORD_QC_MEAN_QUADIMAGE_PI_ODD  	    	 "ESO QC QUAD IMAGE PI ODD MEAN"
//descr Median value of a pi-odd quadimage (ZIMPOL)
#define SPH_COMMON_KEYWORD_QC_MEDIAN_QUADIMAGE_PI_ODD_COMMENT    "Median value of a pi-odd quadimage [ADU]"
#define SPH_COMMON_KEYWORD_QC_MEDIAN_QUADIMAGE_PI_ODD 		     "ESO QC QUAD IMAGE PI ODD MEDIAN"
//descr RMS of a pi-odd quadimage (ZIMPOL)
#define SPH_COMMON_KEYWORD_QC_RMS_QUADIMAGE_PI_ODD_COMMENT       "RMS of a pi-odd quadimage [ADU]"
#define SPH_COMMON_KEYWORD_QC_RMS_QUADIMAGE_PI_ODD			     "ESO QC QUAD IMAGE PI ODD RMS"
//descr Mean value of a pi-even quadimage (ZIMPOL)
#define SPH_COMMON_KEYWORD_QC_MEAN_QUADIMAGE_PI_EVEN_COMMENT     "Mean value of a pi-even quadimage [ADU]"
#define SPH_COMMON_KEYWORD_QC_MEAN_QUADIMAGE_PI_EVEN     	     "ESO QC QUAD IMAGE PI EVEN MEAN"
//descr Median value of a pi-even quadimage (ZIMPOL)
#define SPH_COMMON_KEYWORD_QC_MEDIAN_QUADIMAGE_PI_EVEN_COMMENT   "Median value of a pi-even quadimage [ADU]"
#define SPH_COMMON_KEYWORD_QC_MEDIAN_QUADIMAGE_PI_EVEN   	     "ESO QC QUAD IMAGE PI EVEN MEDIAN"
//descr RMS of a pi-even quadimage (ZIMPOL)
#define SPH_COMMON_KEYWORD_QC_RMS_QUADIMAGE_PI_EVEN_COMMENT      "RMS of a pi-evn quadimage [ADU]"
#define SPH_COMMON_KEYWORD_QC_RMS_QUADIMAGE_PI_EVEN  		     "ESO QC QUAD IMAGE PI EVEN RMS"

//descr Mean dark RON estimate (ADU)
#define SPH_COMMON_KEYWORD_DARK_MEAN_RON_COMMENT      "mean dark RON estimate [ADU]"
#define SPH_COMMON_KEYWORD_DARK_MEAN_RON              "ESO QC MEAN RON"
//descr Mean dark count (ADU)
#define SPH_COMMON_KEYWORD_DARK_MEAN_COUNT_COMMENT    "mean dark count [ADU]"
#define SPH_COMMON_KEYWORD_DARK_MEAN_COUNT            "ESO DRS DARK MEAN"
//descr Mean instrument background count (ADU)
#define SPH_COMMON_KEYWORD_INSBG_MEAN_COUNT_COMMENT    "mean instrument background count [ADU]"
#define SPH_COMMON_KEYWORD_INSBG_MEAN_COUNT            "ESO QC INSBG MEAN"
//descr Mean instrument background count (ADU)
#define SPH_COMMON_KEYWORD_INSBG_RMS_COUNT_COMMENT    "mean instrument background RMS [ADU]"
#define SPH_COMMON_KEYWORD_INSBG_RMS_COUNT            "ESO QC INSBG RMS"
//descr Mean sky background count (ADU)
#define SPH_COMMON_KEYWORD_SKYBG_MEAN_COUNT_COMMENT    "mean sky background count [ADU]"
#define SPH_COMMON_KEYWORD_SKYBG_MEAN_COUNT            "ESO QC SKYBG MEAN"
//descr Mean sky background count (ADU)
#define SPH_COMMON_KEYWORD_SKYBG_RMS_COUNT_COMMENT    "mean sky background RMS [ADU]"
#define SPH_COMMON_KEYWORD_SKYBG_RMS_COUNT            "ESO QC SKYBG RMS"

//descr RMS of mean dark count (ADU)
#define SPH_COMMON_KEYWORD_DARK_RMS_COUNT_COMMENT     "RMS of mean dark count [ADU]"
#define SPH_COMMON_KEYWORD_DARK_RMS_COUNT             "ESO DRS DARK RMS"
//descr Number of identified hot pixels
#define SPH_COMMON_KEYWORD_NUMBER_HOTPIXELS_COMMENT   "No. of identified hot pixels [1]"
#define SPH_COMMON_KEYWORD_NUMBER_HOTPIXELS           "ESO QC NUM HOTPIXELS"

//descr Lenslet image scale (micron/pix)
#define SPH_COMMON_KEYWORD_LENSLET_IMAGE_SCALE_COMMENT "Lenslet image scale [micron/px])"
#define SPH_COMMON_KEYWORD_LENSLET_IMAGE_SCALE         "ESO DRS IMAG MICR PER PIX"

//descr Fixed pattern noise
#define SPH_COMMON_KEYWORD_FLAT_FPN_COMMENT             "Fixed pattern noise [1]"
#define SPH_COMMON_KEYWORD_FLAT_FPN                     "ESO QC FPN"
//descr Root mean squared
#define SPH_COMMON_KEYWORD_FLAT_RMS_COMMENT             "Root mean squared [1]"
#define SPH_COMMON_KEYWORD_FLAT_RMS                     "ESO QC RMS"
//descr nonlinearity coefficient
#define SPH_COMMON_KEYWORD_FLAT_NONLIN_FACTOR_COMMENT   "nonlinearity coefficient [1]"
#define SPH_COMMON_KEYWORD_FLAT_NONLIN_FACTOR           "ESO QC FLAT NONLINEARITY"
//descr Mean counts in flat field
#define SPH_COMMON_KEYWORD_FLAT_MEAN_COUNT_COMMENT      "Mean counts in flat field [ADU]"
#define SPH_COMMON_KEYWORD_FLAT_MEAN_COUNT              "ESO QC FLAT MEAN"
//descr number of identified bad pixels
#define SPH_COMMON_KEYWORD_NUMBER_BADPIXELS_COMMENT     "No. of identified bad pixels [1]"
#define SPH_COMMON_KEYWORD_NUMBER_BADPIXELS             "ESO QC NUM BADPIXELS"
//descr Lamp flux (counts/s in single frame)
#define SPH_COMMON_KEYWORD_FLAT_LAMP_FLUX_COMMENT       "Lamp flux in single frame [ADU/s]"
#define SPH_COMMON_KEYWORD_FLAT_LAMP_FLUX               "ESO QC LAMP FLUX AVG"
//descr Lamp ADU (counts in single frame)
#define SPH_COMMON_KEYWORD_FLAT_LAMP_COUNTS_COMMENT     "Lamp counts in single frame [ADU]"
#define SPH_COMMON_KEYWORD_FLAT_LAMP_COUNTS             "ESO QC LAMP ADU AVG"
//descr Lamp flux stdev (counts/s in single frame)
#define SPH_COMMON_KEYWORD_FLAT_LAMP_FLUX_STDEV_COMMENT "Lamp flux stdev in single frame [ADU/s]"
#define SPH_COMMON_KEYWORD_FLAT_LAMP_FLUX_STDEV         "ESO QC LAMP FLUX VARIANCE"
//descr median resolving power
#define SPH_COMMON_KEYWORD_MEDIAN_RESOLVING_POWER_COMMENT "median resolving power [1]"
#define SPH_COMMON_KEYWORD_MEDIAN_RESOLVING_POWER         "ESO QC MEDIAN RESOLVING POWER"
//descr median value of dispersion
#define SPH_COMMON_KEYWORD_MEDIAN_DISPERSION_COMMENT      "median dispersion [micron/px]"
#define SPH_COMMON_KEYWORD_MEDIAN_DISPERSION              "ESO QC MEDIAN DISPERSION"
// Median minimum value of wavelength
#define SPH_COMMON_KEYWORD_MEDIAN_MIN_WAVL_COMMENT        "Median minimum wavelength"
#define SPH_COMMON_KEYWORD_MEDIAN_MIN_WAVL                "ESO QC MEDIAN MIN WAVEL"
//descr median value of longest wavelength
#define SPH_COMMON_KEYWORD_MEDIAN_MAXWAVEL_COMMENT        "median value of longest wavelength [micron]"
#define SPH_COMMON_KEYWORD_MEDIAN_MAXWAVEL                "ESO QC MEDIAN MAX WAVEL"
//descr median value of shortest wavelength
#define SPH_COMMON_KEYWORD_MEDIAN_MINWAVEL_COMMENT        "median value of shortest wavelength [micron]"
#define SPH_COMMON_KEYWORD_MEDIAN_MINWAVEL                "ESO DRS MEDIAN MIN WAVEL"
//descr median value of central wavelength
#define SPH_COMMON_KEYWORD_MEDIAN_CENTWAVEL_COMMENT       "median value of central wavelength [micron]"
#define SPH_COMMON_KEYWORD_MEDIAN_CENTWAVEL               "ESO DRS MEDIAN CENT WAVEL"
//descr no. of bad wavelength fits
#define SPH_COMMON_KEYWORD_QC_WAVE_NSINGFITS_COMMENT      "no. of bad wavelength fits [1]"
#define SPH_COMMON_KEYWORD_QC_WAVE_NSINGFITS              "ESO DRS NUM BAD WAVEFITS"
//descr no. of fits out of spec
#define SPH_COMMON_KEYWORD_QC_WAVE_NOUTOFSPEC_COMMENT     "no. of fits out of spec [1]"
#define SPH_COMMON_KEYWORD_QC_WAVE_NOUTOFSPEC             "ESO DRS NUM OUT OF SPEC"
//descr no. of wavelengths out of 2 dispersions
#define SPH_COMMON_KEYWORD_QC_WAVE_N2DISP_COMMENT         "no. of wavelengths out of 2 dispersions [1]"
#define SPH_COMMON_KEYWORD_QC_WAVE_N2DISP                 "ESO DRS NUM OUT OF 2DISP"
//descr no. of wavelengths out of 1 dispersion
#define SPH_COMMON_KEYWORD_QC_WAVE_NDISP_COMMENT          "no. of wavelengths out of 1 dispersion [1]"
#define SPH_COMMON_KEYWORD_QC_WAVE_NDISP                  "ESO QC NUM OUT OF DISP"
//descr no. of bad spectra
#define SPH_COMMON_KEYWORD_QC_WAVE_BADSPEC_COMMENT        "no. of bad spectra [1]"
#define SPH_COMMON_KEYWORD_QC_WAVE_BADSPEC                "ESO QC BAD SPECTRA"

//descr no. of points removed from distortion map
#define SPH_COMMON_KEYWORD_DISTMAP_NREMOVED_COMMENT       "no. of points removed from distortion map [1]"
#define SPH_COMMON_KEYWORD_DISTMAP_NREMOVED               "ESO QC DISTMAP NREMOVED"
//descr distortion map pixel scale
#define SPH_COMMON_KEYWORD_DISTMAP_PIXSCALE_COMMENT       "relative distortion map pixel scale [1]"
#define SPH_COMMON_KEYWORD_DISTMAP_PIXSCALE               "ESO QC DISTMAP PIXSCALE"

//descr number of bad pixels
#define SPH_COMMON_KEYWORD_QC_NUMBER_BADPIXELS_ZPLEXP_ZERO_ODD_COMMENT "number of bad pixels[1]"
#define SPH_COMMON_KEYWORD_QC_NUMBER_BADPIXELS_ZPLEXP_ZERO_ODD		   "ESO QC ZPL EXP ZERO ODD NUMBER BADPIXELS"
//descr number of bad pixels
#define SPH_COMMON_KEYWORD_QC_NUMBER_BADPIXELS_ZPLEXP_ZERO_EVEN_COMMENT "number of bad pixels [1]"
#define SPH_COMMON_KEYWORD_QC_NUMBER_BADPIXELS_ZPLEXP_ZERO_EVEN		    "ESO QC ZPL EXP ZERO EVEN NUMBER BADPIXELS"
//descr number of bad pixels
#define SPH_COMMON_KEYWORD_QC_NUMBER_BADPIXELS_ZPLEXP_PI_ODD_COMMENT    "number of bad pixels [1]"
#define SPH_COMMON_KEYWORD_QC_NUMBER_BADPIXELS_ZPLEXP_PI_ODD		    "ESO QC ZPL EXP PI ODD NUMBER BADPIXELS"
//descr number of bad pixels
#define SPH_COMMON_KEYWORD_QC_NUMBER_BADPIXELS_ZPLEXP_PI_EVEN_COMMENT   "number of bad pixels [1]"
#define SPH_COMMON_KEYWORD_QC_NUMBER_BADPIXELS_ZPLEXP_PI_EVEN		    "ESO QC ZPL EXP PI EVEN NUMBER BADPIXELS"

//descr number of bad pixels
#define SPH_COMMON_KEYWORD_QC_NUMBER_BADPIXELS_QUAD_IMAGE_ZERO_ODD_COMMENT "number of bad pixels [1]"
#define SPH_COMMON_KEYWORD_QC_NUMBER_BADPIXELS_QUAD_IMAGE_ZERO_ODD		   "ESO QC QUAD IMAGE ZERO ODD NUMBER BADPIXELS"
//descr number of bad pixels
#define SPH_COMMON_KEYWORD_QC_NUMBER_BADPIXELS_QUAD_IMAGE_ZERO_EVEN_COMMENT "number of bad pixels [1]"
#define SPH_COMMON_KEYWORD_QC_NUMBER_BADPIXELS_QUAD_IMAGE_ZERO_EVEN		    "ESO QC QUAD IMAGE ZERO EVEN NUMBER BADPIXELS"
//descr number of bad pixels
#define SPH_COMMON_KEYWORD_QC_NUMBER_BADPIXELS_QUAD_IMAGE_PI_ODD_COMMENT    "number of bad pixels [1]"
#define SPH_COMMON_KEYWORD_QC_NUMBER_BADPIXELS_QUAD_IMAGE_PI_ODD		    "ESO QC QUAD IMAGE PI ODD NUMBER BADPIXELS"
//descr number of bad pixels
#define SPH_COMMON_KEYWORD_QC_NUMBER_BADPIXELS_QUAD_IMAGE_PI_EVEN_COMMENT   "number of bad pixels [1]"
#define SPH_COMMON_KEYWORD_QC_NUMBER_BADPIXELS_QUAD_IMAGE_PI_EVEN		    "ESO QC QUAD IMAGE PI EVEN NUMBER BADPIXELS"


//descr number of bad pixels
#define SPH_COMMON_KEYWORD_QC_NUMBER_BADPIXELS_ZPLEXP_IMG_ODD_COMMENT       "number of bad pixels [1]"
#define SPH_COMMON_KEYWORD_QC_NUMBER_BADPIXELS_ZPLEXP_IMG_ODD		        "ESO QC ZPL EXP IMAGING ODD NUMBER BADPIXELS"
//descr number of bad pixels
#define SPH_COMMON_KEYWORD_QC_NUMBER_BADPIXELS_ZPLEXP_IMG_EVEN_COMMENT      "number of bad pixels [1]"
#define SPH_COMMON_KEYWORD_QC_NUMBER_BADPIXELS_ZPLEXP_IMG_EVEN		        "ESO QC ZPL EXP IMAGING EVEN NUMBER BADPIXELS"

//descr number of bad pixels
#define SPH_COMMON_KEYWORD_QC_NUMBER_BADPIXELS_DOUBLE_IMAGE_ODD_COMMENT     "number of bad pixels [1]"
#define SPH_COMMON_KEYWORD_QC_NUMBER_BADPIXELS_DOUBLE_IMAGE_ODD		        "ESO QC DOUBLE IMAGE ODD-I NUMBER BADPIXELS"
//descr number of bad pixels
#define SPH_COMMON_KEYWORD_QC_NUMBER_BADPIXELS_DOUBLE_IMAGE_EVEN_COMMENT    "number of bad pixels [1]"
#define SPH_COMMON_KEYWORD_QC_NUMBER_BADPIXELS_DOUBLE_IMAGE_EVEN	        "ESO QC DOUBLE IMAGE EVEN-P NUMBER BADPIXELS"

//descr number of rings used by LOCI
#define SPH_COMMON_KEYWORD_QC_LOCI_NRINGS_COMMENT                           "number of rings used by LOCI [1]"
#define SPH_COMMON_KEYWORD_QC_LOCI_NRINGS     	                            "ESO QC LOCI NRINGS"
//descr number of sub-sections used by LOCI
#define SPH_COMMON_KEYWORD_QC_LOCI_NSUBSECTIONS_COMMENT                     "number of sub-sections used by LOCI [1]"
#define SPH_COMMON_KEYWORD_QC_LOCI_NSUBSECTIONS                             "ESO QC LOCI NSECT"
//descr number of bad sub-sections
#define SPH_COMMON_KEYWORD_QC_LOCI_NBADSECTIONS_COMMENT                     "number of bad sub-sections [1]"
#define SPH_COMMON_KEYWORD_QC_LOCI_NBADSECTIONS                             "ESO QC LOCI NSECT BAD"

//descr Strehl ratio measured on brightest source in field
#define SPH_STREHL_QC_STREHL_COMMENT          "Strehl ratio measured on brightest source in field"
#define SPH_STREHL_QC_STREHL                  "ESO QC STREHL"
//descr Error of Strehl ratio measured on brightest source in field
#define SPH_STREHL_QC_STREHL_ERR_COMMENT      "Error of Strehl ratio measured on brightest source in field"
#define SPH_STREHL_QC_STREHL_ERR              "ESO QC STREHL ERROR"
//descr X coordinate of position of source used for Strehl measurement
#define SPH_STREHL_QC_STREHL_POSX_COMMENT     "X coordinate of position of source used for Strehl measurement"
#define SPH_STREHL_QC_STREHL_POSX             "ESO QC STREHL POSX"
//descr Y coordinate of position of source used for Strehl measurement
#define SPH_STREHL_QC_STREHL_POSY_COMMENT     "Y coordinate of position of source used for Strehl measurement"
#define SPH_STREHL_QC_STREHL_POSY             "ESO QC STREHL POSY"
//descr Sigma of Strehl measurement
#define SPH_STREHL_QC_STREHL_SIGMA_COMMENT    "Sigma of Strehl measurement (?)"
#define SPH_STREHL_QC_STREHL_SIGMA            "ESO QC STREHL SIGMA"
//descr Flux measured in aperture for Strehl measurement
#define SPH_STREHL_QC_STREHL_FLUX_COMMENT     "Flux measured in aperture for Strehl measurement [ADU]"
#define SPH_STREHL_QC_STREHL_FLUX             "ESO QC STREHL FLUX"
//descr Peak intensity in aperture used for Strehl measurement
#define SPH_STREHL_QC_STREHL_PEAK_COMMENT     "Peak intensity in aperture used for Strehl measurement [ADU]"
#define SPH_STREHL_QC_STREHL_PEAK             "ESO QC STREHL PEAK"
//descr Background flux per pixel in aperture used for Strehl measurement
#define SPH_STREHL_QC_STREHL_BKG_COMMENT      "Background flux per pixel in aperture used for Strehl measurement [ADU]"
#define SPH_STREHL_QC_STREHL_BKG              "ESO QC STREHL BACKGROUND"
//descr Noise of background flux per pixel in aperture used for Strehl measurement
#define SPH_STREHL_QC_STREHL_BKGNOISE_COMMENT "Noise of background flux per pixel in aperture used for Strehl measurement [ADU]"
#define SPH_STREHL_QC_STREHL_BKGNOISE         "ESO QC STREHL BACKGROUND NOISE"

//descr Calculated zeropoint for left quadrant
#define SPH_PHOT_QC_IRD_LEFT_COMMENT          "Calculated zeropoint for left quadrant [mag]"
#define SPH_PHOT_QC_IRD_LEFT                  "ESO QC ZPOINT LEFT"
//descr Calculated zeropoint for left quadrant
#define SPH_PHOT_QC_IRD_LEFTCORR_COMMENT      "ND Corrected zeropoint for left quadrant [mag]"
#define SPH_PHOT_QC_IRD_LEFTCORR              "ESO QC ZPOINTCORR LEFT"
//descr Calculated zeropoint for right quadrant
#define SPH_PHOT_QC_IRD_RIGHT_COMMENT         "Calculated zeropoint for right quadrant [mag]"
#define SPH_PHOT_QC_IRD_RIGHT                 "ESO QC ZPOINT RIGHT"
//descr Corrected zeropoint for right quadrant
#define SPH_PHOT_QC_IRD_RIGHTCORR_COMMENT     "ND Corrected zeropoint for right quadrant [mag]"
#define SPH_PHOT_QC_IRD_RIGHTCORR             "ESO QC ZPOINTCORR RIGHT"
//descr Calculated zeropoint for ZIMPOL camera 1/2
#define SPH_PHOT_QC_ZPL_CAMERA_COMMENT        "Calculated zeropoint for camera [mag]"
#define SPH_PHOT_QC_ZPL_CAMERA                "ESO QC ZPOINT"
//descr Corrected zeropoint for ZIMPOL camera 1/2
#define SPH_PHOT_QC_ZPL_CAMERACORR_COMMENT    "ND Corrected zeropoint for camera [mag]"
#define SPH_PHOT_QC_ZPL_CAMERACORR            "ESO QC ZPOINTCORR"

#define SPH_COMMON_KEYWORD_PRO_FIRST_RAW_FRAME         "ESO PRO REC1 RAW1 NAME"
#define SPH_COMMON_KEYWORD_PRO_REDLEVEL                "ESO REDLEVEL"
#define SPH_COMMON_KEYWORD_PRO_TYPE                    "ESO TYPE"
#define SPH_COMMON_KEYWORD_PRO_TECH                    "ESO TECH"
#define SPH_COMMON_KEYWORD_PRO_REC1_START              "ESO REC1 START"
#define SPH_COMMON_KEYWORD_PRO_REC1_STOP               "ESO REC1 STOP"


#define SPH_COMMON_KEYWORD_DROT2_MODE					"ESO INS4 DROT2 MODE"

//Chips index (ZPL)
#define SPH_COMMOM_KEYWORD_CHIP_INDEX					"ESO DET CHIP INDEX"
//Dithering keywords (ZPL)
#define SPH_COMMON_KEYWORD_CAM1_DITHERING_X			 	"ESO INS3 POS3 POS"
#define SPH_COMMON_KEYWORD_CAM1_DITHERING_Y			 	"ESO INS3 POS4 POS"
#define SPH_COMMON_KEYWORD_CAM2_DITHERING_X			 	"ESO INS3 POS6 POS"
#define SPH_COMMON_KEYWORD_CAM2_DITHERING_Y			 	"ESO INS3 POS7 POS"
#define SPH_COMMON_KEYWORD_VALUE_CAM1_POS0_X            0.0
#define SPH_COMMON_KEYWORD_VALUE_CAM1_POS0_Y           -20.1
#define SPH_COMMON_KEYWORD_VALUE_CAM2_POS0_X            0.0
#define SPH_COMMON_KEYWORD_VALUE_CAM2_POS0_Y            0.0

//De-rotator (ZPL)
#define SPH_COMMON_KEYWORD_DROT2_ANGLE_BEGIN			"ESO INS4 DROT2 BEGIN"
#define SPH_COMMON_KEYWORD_DROT2_ANGLE_END				"ESO INS4 DROT2 END"

//Adaptive Optics (ZPL)
#define SPH_PHOT_ZPL_AOS_HOLOOP  "ESO AOS HOLOOP STATE"
#define SPH_PHOT_ZPL_AOS_IRLOOP  "ESO AOS IRLOOP STATE"
#define SPH_PHOT_ZPL_AOS_PUPLOOP "ESO AOS PUPLOOP STATE"
#define SPH_PHOT_ZPL_AOS_TTLOOP  "ESO AOS TTLOOP STATE"

#define SPH_COMMON_KEYWORD_DET_SYSTEM_ID               "ESO DET DEV1 ID"
#define SPH_COMMON_KEYWORD_VALUE_DET_ID_ZIMPOL         "ZIMPOL"


/*---------------------------------------------------------------------------*/
/*
 * Definition of SPHERE specific keywords and values
 */
/*---------------------------------------------------------------------------*/

#define SPH_COMMON_KEYWORD_VALUE_DROT2_MODE_FIELD_STAB		"SKY"
#define SPH_COMMON_KEYWORD_VALUE_DROT2_MODE_PUPIL_STAB		"ELEV"
#define SPH_COMMON_KEYWORD_VALUE_DROT2_MODE_NO_DEROT		"STAT"

//Chip index values (ZPL)
#define SPH_COMMON_KEYWORD_VALUE_CHIP_INDEX_CAM1				1
#define SPH_COMMON_KEYWORD_VALUE_CHIP_INDEX_CAM2				2


#define SPH_COMMON_KEYWORD_DIT_ID                      "ESO INS DIT ID"
#define SPH_COMMON_KEYWORD_LAMP                        "ESO INS LAMP"

#define SPH_COMMON_KEYWORD_LAMP                        "ESO INS LAMP"
#define SPH_COMMON_KEYWORD_CALIB_LAMBDA                "ESO DRS CALIB WAVELENGTH"
#define SPH_COMMON_KEYWORD_SPH_CUBE_INTERPOL_ALGORITHM "ESO DRS INTERPOL ALGORITHM"
#define SPH_COMMON_KEYWORD_VALUE_LAMP_BB				1

#define SPH_COMMON_KEYWORD_SPH_FLUX_COMP_CORO           "ESO DRS FLUX CORO"
#define SPH_COMMON_KEYWORD_SPH_FLUX_COMP_NOCORO         "ESO DRS FLUX NO_CORO"
#define SPH_COMMON_KEYWORD_SPH_FLUX_ZP                  "ESO DRS FLUX ZERO POINT"
#define SPH_COMMON_KEYWORD_SPH_FLUX_RATIO               "ESO DRS FLUX RATIO"
#define	SPH_COMMON_KEYWORD_SPH_COMANION_X               "ESO DRS COMPANION POSX"
#define	SPH_COMMON_KEYWORD_SPH_COMANION_Y               "ESO DRS COMPANION POSY"

#define SPH_COMMON_KEYWORD_VALUE_PRO_REDLEVEL_FULL     "FULL"
#define SPH_COMMON_KEYWORD_VALUE_DIC_ID                "ESO-VLT-DIC.PRO-1.15"

#define SPH_COMMON_KEYWORD_VALUE_PRO_TYPE_REDUCED		"REDUCED"
#define SPH_COMMON_KEYWORD_VALUE_PRO_TYPE_RAW			"RAW"

#define SPH_COMMON_KEYWORD_VALUE_PRO_TECH_IMAGE			"IMAGE"

#define SPH_COMMON_KEYWORD_VALUE_PRO_CATG_MASTER_DARK	"MASTER_DARK"

#define SPH_COMMON_KEYWORD_VALUE_PRO_CATG_INSTUMENT_FLAT "MASTER_IFF"

#define SPH_COMMON_KEYWORD_SPH_TYPE 							"ESO DRS PC PROD TYPE"
#define SPH_COMMON_KEYWORD_VALUE_SPH_TYPE_MASTER_FRAME			"SPH PC MASTER FRAME"
#define SPH_COMMON_KEYWORD_VALUE_SPH_TYPE_RAW_FRAME     		"SPH PC RAW FRAME"
#define SPH_COMMON_KEYWORD_VALUE_SPH_TYPE_PREPROC_ZPL_EXP		"SPH PC PREPROC ZPL EXP"
#define SPH_COMMON_KEYWORD_VALUE_SPH_TYPE_PREPROC_ZPL_EXP_IMG	"SPH PC PREPROC ZPL EXP IMAGING"
#define SPH_COMMON_KEYWORD_VALUE_SPH_TYPE_DOUBLE_IMAGE			"SPH PC DOUBLE IMAGE"
#define SPH_COMMON_KEYWORD_VALUE_SPH_TYPE_TRIPLE_IMAGE			"SPH PC TRIPLE IMAGE"
#define SPH_COMMON_KEYWORD_VALUE_SPH_TYPE_QUAD_IMAGE			"SPH PC QUAD IMAGE"
#define SPH_COMMON_KEYWORD_VALUE_SPH_TYPE_CUBE					"SPH PC CUBE"

#define SPH_COMMON_KEYWORD_SPH_DITHERX                  "ESO INS2 DITH POSX"
#define SPH_COMMON_KEYWORD_SPH_DITHERY                  "ESO INS2 DITH POSY"
#define SPH_COMMON_KEYWORD_SPH_POSANG                   "ESO INS CPRT POSANG"
#define SPH_COMMON_KEYWORD_SPH_ANGLE_TO_NORTH           "ESO DRS ANGLETONORTH"
#define SPH_COMMON_KEYWORD_SPH_PLATE_SCALE              "ESO DRS PLATESCALE"
#define SPH_COMMON_KEYWORD_SPH_IMAGE_MEAN               "ESO DRS MEANVLAUE"
#define SPH_COMMON_KEYWORD_OFFSET_ID                    "ESO DRS OFFSET ID"
#define SPH_COMMON_KEYWORD_CALIB_PRISM_ID               "ESO DRS PRISM ID"
#define SPH_COMMON_KEYWORD_SPH_CUBE_NX                  "ESO DRS IMAGE NX"
#define SPH_COMMON_KEYWORD_SPH_CUBE_NY                  "ESO DRS IMAGE NY"

#define SPH_COMMON_KEYWORD_DISTMAP_COEFFX               "ESO DRS DIST X COEFF"
#define SPH_COMMON_KEYWORD_DISTMAP_COEFFY               "ESO DRS DIST Y COEFF"

//descr average of  raw data cube
#define SPH_COMMON_KEYWORD_RAW_MEDIANS_AVG_COMMENT "average of raw data cube"
#define SPH_COMMON_KEYWORD_RAW_MEDIANS_AVG              "ESO DRS RAW MED AVG"
//descr median of  raw data cube
#define SPH_COMMON_KEYWORD_RAW_MEDIANS_MED_COMMENT "median of raw data cube"
#define SPH_COMMON_KEYWORD_RAW_MEDIANS_MED              "ESO DRS RAW MED MEDIAN"
//descr minimum of  raw data cube
#define SPH_COMMON_KEYWORD_RAW_MEDIANS_MIN_COMMENT "minimum of raw data cube"
#define SPH_COMMON_KEYWORD_RAW_MEDIANS_MIN              "ESO DRS RAW MED MIN"
//descr maximum of  raw data cube
#define SPH_COMMON_KEYWORD_RAW_MEDIANS_MAX_COMMENT "maximum of raw data cube"
#define SPH_COMMON_KEYWORD_RAW_MEDIANS_MAX              "ESO DRS RAW MED MAX"
//descr value range of  raw data cube
#define SPH_COMMON_KEYWORD_RAW_MEDIANS_RANGE_COMMENT "value range of raw data cube"
#define SPH_COMMON_KEYWORD_RAW_MEDIANS_RANGE            "ESO DRS RAW MED RANGE"

//ZERO ODD
//descr average median of zpl exposure phase zero odd sub-frame of raw data cube
#define SPH_COMMON_KEYWORD_QC_ZERO_ODD_RAW_MEDIANS_AVG_COMMENT      "average median of raw data cube [ADU]"
#define SPH_COMMON_KEYWORD_QC_ZERO_ODD_RAW_MEDIANS_AVG              "ESO DRS ZERO ODD RAW MED AVG "
//descr median of the median of zpl exposure phase zero odd sub-frame of raw data cube
#define SPH_COMMON_KEYWORD_QC_ZERO_ODD_RAW_MEDIANS_MED_COMMENT      "median of raw data cube [ADU]"
#define SPH_COMMON_KEYWORD_QC_ZERO_ODD_RAW_MEDIANS_MED              "ESO DRS ZERO ODD RAW MED MEDIAN"
//descr minimum median of zpl exposure phase zero odd sub-frame of raw data cube
#define SPH_COMMON_KEYWORD_QC_ZERO_ODD_RAW_MEDIANS_MIN_COMMENT      "minimum median of raw data cube [ADU]"
#define SPH_COMMON_KEYWORD_QC_ZERO_ODD_RAW_MEDIANS_MIN              "ESO DRS ZERO ODD RAW MED MIN"
//descr maximum median of zpl exposure phase zero odd sub-frame of raw data cube
#define SPH_COMMON_KEYWORD_QC_ZERO_ODD_RAW_MEDIANS_MAX_COMMENT      "maximum median of raw data cube [ADU]"
#define SPH_COMMON_KEYWORD_QC_ZERO_ODD_RAW_MEDIANS_MAX              "ESO DRS ZERO ODD RAW MED MAX"
//descr median range of zpl exposure phase zero odd sub-frame of  raw data cube
#define SPH_COMMON_KEYWORD_QC_ZERO_ODD_RAW_MEDIANS_RANGE_COMMENT    "median range of raw data cube [ADU]"
#define SPH_COMMON_KEYWORD_QC_ZERO_ODD_RAW_MEDIANS_RANGE            "ESO DRS ZERO ODD RAW MED RANGE"

//ZERO EVEN
//descr average median of zpl exposure phase zero even sub-frame of raw data cube
#define SPH_COMMON_KEYWORD_QC_ZERO_EVEN_RAW_MEDIANS_AVG_COMMENT      "average median of raw data cube [ADU]"
#define SPH_COMMON_KEYWORD_QC_ZERO_EVEN_RAW_MEDIANS_AVG              "ESO DRS ZERO EVEN RAW MED AVG "
//descr median of the median of zpl exposure phase zero even sub-frame of raw data cube
#define SPH_COMMON_KEYWORD_QC_ZERO_EVEN_RAW_MEDIANS_MED_COMMENT      "median of the median of raw data cube [ADU]"
#define SPH_COMMON_KEYWORD_QC_ZERO_EVEN_RAW_MEDIANS_MED              "ESO DRS ZERO EVEN RAW MED MEDIAN"
//descr minimum median of zpl exposure phase zero even sub-frame of raw data cube
#define SPH_COMMON_KEYWORD_QC_ZERO_EVEN_RAW_MEDIANS_MIN_COMMENT      "minimum median of raw data cube [ADU]"
#define SPH_COMMON_KEYWORD_QC_ZERO_EVEN_RAW_MEDIANS_MIN              "ESO DRS ZERO EVEN RAW MED MIN"
//descr maximum median of zpl exposure phase zero even sub-frame of raw data cube
#define SPH_COMMON_KEYWORD_QC_ZERO_EVEN_RAW_MEDIANS_MAX_COMMENT      "maximum median of data cube [ADU]"
#define SPH_COMMON_KEYWORD_QC_ZERO_EVEN_RAW_MEDIANS_MAX              "ESO DRS ZERO EVEN RAW MED MAX"
//descr median range of zpl exposure phase zero even sub-frame of  raw data cube
#define SPH_COMMON_KEYWORD_QC_ZERO_EVEN_RAW_MEDIANS_RANGE_COMMENT    "median of raw data cube [ADU]"
#define SPH_COMMON_KEYWORD_QC_ZERO_EVEN_RAW_MEDIANS_RANGE            "ESO DRS ZERO EVEN RAW MED RANGE"

//PI ODD
//descr average median of zpl exposure phase PI odd sub-frame of raw data cube
#define SPH_COMMON_KEYWORD_QC_PI_ODD_RAW_MEDIANS_AVG_COMMENT      "average median of raw data cube [ADU]"
#define SPH_COMMON_KEYWORD_QC_PI_ODD_RAW_MEDIANS_AVG              "ESO DRS PI ODD RAW MED AVG "
//descr median of the median of zpl exposure phase PI odd sub-frame of raw data cube
#define SPH_COMMON_KEYWORD_QC_PI_ODD_RAW_MEDIANS_MED_COMMENT      "median of the median of raw data cube [ADU]"
#define SPH_COMMON_KEYWORD_QC_PI_ODD_RAW_MEDIANS_MED              "ESO DRS PI ODD RAW MED MEDIAN"
//descr minimum median of zpl exposure phase PI odd sub-frame of raw data cube
#define SPH_COMMON_KEYWORD_QC_PI_ODD_RAW_MEDIANS_MIN_COMMENT      "minimum median of raw data cube [ADU]"
#define SPH_COMMON_KEYWORD_QC_PI_ODD_RAW_MEDIANS_MIN              "ESO DRS PI ODD RAW MED MIN"
//descr maximum median of zpl exposure phase PI odd sub-frame of raw data cube
#define SPH_COMMON_KEYWORD_QC_PI_ODD_RAW_MEDIANS_MAX_COMMENT      "maximum median of raw data cube [ADU]"
#define SPH_COMMON_KEYWORD_QC_PI_ODD_RAW_MEDIANS_MAX              "ESO DRS PI ODD RAW MED MAX"
//descr median range of zpl exposure phase PI odd sub-frame of raw data cube
#define SPH_COMMON_KEYWORD_QC_PI_ODD_RAW_MEDIANS_RANGE_COMMENT    "median range of raw data cube [ADU]"
#define SPH_COMMON_KEYWORD_QC_PI_ODD_RAW_MEDIANS_RANGE            "ESO DRS PI ODD RAW MED RANGE"

//PI ODD
//descr average median of zpl exposure phase PI odd sub-frame of raw data cube
#define SPH_COMMON_KEYWORD_QC_PI_EVEN_RAW_MEDIANS_AVG_COMMENT      "average median of raw data cube [ADU]"
#define SPH_COMMON_KEYWORD_QC_PI_EVEN_RAW_MEDIANS_AVG              "ESO DRS PI EVEN RAW MED AVG "
//descr median of the median of zpl exposure phase PI odd sub-frame of raw data cube
#define SPH_COMMON_KEYWORD_QC_PI_EVEN_RAW_MEDIANS_MED_COMMENT      "median of the median of raw data cube [ADU]"
#define SPH_COMMON_KEYWORD_QC_PI_EVEN_RAW_MEDIANS_MED              "ESO DRS PI EVEN RAW MED MEDIAN"
//descr minimum median of zpl exposure phase PI odd sub-frame of raw data cube
#define SPH_COMMON_KEYWORD_QC_PI_EVEN_RAW_MEDIANS_MIN_COMMENT      "minimum median of raw data cube [ADU]"
#define SPH_COMMON_KEYWORD_QC_PI_EVEN_RAW_MEDIANS_MIN              "ESO DRS PI EVEN RAW MED MIN"
//descr maximum median of zpl exposure phase PI odd sub-frame of raw data cube
#define SPH_COMMON_KEYWORD_QC_PI_EVEN_RAW_MEDIANS_MAX_COMMENT      "maximum median of raw data cube [ADU]"
#define SPH_COMMON_KEYWORD_QC_PI_EVEN_RAW_MEDIANS_MAX              "ESO DRS PI EVEN RAW MED MAX"
//descr median range of zpl exposure phase PI odd sub-frame of raw data cube
#define SPH_COMMON_KEYWORD_QC_PI_EVEN_RAW_MEDIANS_RANGE_COMMENT    "median range of raw data cube [ADU]"
#define SPH_COMMON_KEYWORD_QC_PI_EVEN_RAW_MEDIANS_RANGE            "ESO DRS PI EVEN RAW MED RANGE"

//DOUBLE IMAGE IFRAME
//descr average median of double images of raw data cube
#define SPH_COMMON_KEYWORD_QC_DOUBLE_IMAGE_IFRAME_RAW_MEDIANS_AVG_COMMENT "average median of raw (or stokes) data cube [ADU]"
#define SPH_COMMON_KEYWORD_QC_DOUBLE_IMAGE_IFRAME_RAW_MEDIANS_AVG         "ESO DRS DOUBLE IMAGE IFRAME RAW MED AVG "
//descr median of the median of double images of raw  data cube
#define SPH_COMMON_KEYWORD_QC_DOUBLE_IMAGE_IFRAME_RAW_MEDIANS_MED_COMMENT "median of the median of double images raw (oder stokes) data cube [ADU]"
#define SPH_COMMON_KEYWORD_QC_DOUBLE_IMAGE_IFRAME_RAW_MEDIANS_MED              "ESO DRS DOUBLE IMAGE IFRAME RAW MED MEDIAN"
//descr minimum median of double images of raw data cube
#define SPH_COMMON_KEYWORD_QC_DOUBLE_IMAGE_IFRAME_RAW_MEDIANS_MIN_COMMENT "minimum median of double images raw (oder stokes) data cube [ADU]"
#define SPH_COMMON_KEYWORD_QC_DOUBLE_IMAGE_IFRAME_RAW_MEDIANS_MIN              "ESO DRS DOUBLE IMAGE IFRAME RAW MED MIN"
//descr maximum median of double images of raw data cube
#define SPH_COMMON_KEYWORD_QC_DOUBLE_IMAGE_IFRAME_RAW_MEDIANS_MAX_COMMENT "maximum median of double images raw (oder stokes) data cube [ADU]"
#define SPH_COMMON_KEYWORD_QC_DOUBLE_IMAGE_IFRAME_RAW_MEDIANS_MAX              "ESO DRS DOUBLE IMAGE IFRAME RAW MED MAX"
//descr median range of double images of raw data cube
#define SPH_COMMON_KEYWORD_QC_DOUBLE_IMAGE_IFRAME_RAW_MEDIANS_RANGE_COMMENT "median range of double images raw (oder stokes) data cube [ADU]"
#define SPH_COMMON_KEYWORD_QC_DOUBLE_IMAGE_IFRAME_RAW_MEDIANS_RANGE             "ESO DRS DOUBLE IMAGE IFRAME RAW MED RANGE"

#define SPH_COMMON_KEYWORD_QC_IFRAME_RAW_COUNTS "ESO QC IFRAME RAW COUNTS"
#define SPH_COMMON_KEYWORD_QC_IFRAME_SNR "ESO QC IFRAME SNR"
#define SPH_COMMON_KEYWORD_QC_LEAKAGE_SNR "ESO QC LEAKAGE SNR"
#define SPH_COMMON_KEYWORD_QC_PLANE_AVG "ESO QC PLANE AVG"
#define SPH_COMMON_KEYWORD_QC_PLANE_SIG "ESO QC PLANE SIG"

#define SPH_COMMON_KEYWORD_QC_ZERO_ODD_SNR "ESO QC ZERO ODD SNR"
#define SPH_COMMON_KEYWORD_QC_ZERO_EVEN_SNR "ESO QC ZERO EVEN SNR"
#define SPH_COMMON_KEYWORD_QC_PI_ODD_SNR "ESO QC PI ODD SNR"
#define SPH_COMMON_KEYWORD_QC_PI_EVEN_SNR "ESO QC PI EVEN SNR"

//DOUBLE IMAGE PFRAME
//descr average median of double images of raw data cube
#define SPH_COMMON_KEYWORD_QC_DOUBLE_IMAGE_PFRAME_RAW_MEDIANS_AVG_COMMENT "average median of double images of raw (oder stokes) data cube [ADU]"
#define SPH_COMMON_KEYWORD_QC_DOUBLE_IMAGE_PFRAME_RAW_MEDIANS_AVG              "ESO DRS DOUBLE IMAGE PFRAME RAW MED AVG "
//descr median of the median of double images of raw  data cube
#define SPH_COMMON_KEYWORD_QC_DOUBLE_IMAGE_PFRAME_RAW_MEDIANS_MED_COMMENT "median of the median of double images raw (oder stokes) data cube [ADU]"
#define SPH_COMMON_KEYWORD_QC_DOUBLE_IMAGE_PFRAME_RAW_MEDIANS_MED              "ESO DRS DOUBLE IMAGE PFRAME RAW MED MEDIAN"
//descr minimum median of double images of raw data cube
#define SPH_COMMON_KEYWORD_QC_DOUBLE_IMAGE_PFRAME_RAW_MEDIANS_MIN_COMMENT "minimum median of double images raw (oder stokes) data cube [ADU]"
#define SPH_COMMON_KEYWORD_QC_DOUBLE_IMAGE_PFRAME_RAW_MEDIANS_MIN              "ESO DRS DOUBLE IMAGE PFRAME RAW MED MIN"
//descr maximum median of double images of raw data cube
#define SPH_COMMON_KEYWORD_QC_DOUBLE_IMAGE_PFRAME_RAW_MEDIANS_MAX_COMMENT "maximum median of double images raw (oder stokes) data cube [ADU]"
#define SPH_COMMON_KEYWORD_QC_DOUBLE_IMAGE_PFRAME_RAW_MEDIANS_MAX              "ESO DRS DOUBLE IMAGE PFRAME RAW MED MAX"
//descr median range of double images of raw data cube
#define SPH_COMMON_KEYWORD_QC_DOUBLE_IMAGE_PFRAME_RAW_MEDIANS_RANGE_COMMENT "median range of double images raw (oder stokes) data cube [ADU]"
#define SPH_COMMON_KEYWORD_QC_DOUBLE_IMAGE_PFRAME_RAW_MEDIANS_RANGE             "ESO DRS DOUBLE IMAGE PFRAME RAW MED RANGE"

#define SPH_COMMON_KEYWORD_QC_BACKGROUND_RATE "ESO QC BACKGROUND RATE"
#define SPH_COMMON_KEYWORD_QC_MAX_LEFT     "ESO QC MAX LEFT"
#define SPH_COMMON_KEYWORD_QC_MAX_RIGHT    "ESO QC MAX RIGHT"
#define SPH_COMMON_KEYWORD_QC_STDEV_LEFT   "ESO QC STDEV LEFT"
#define SPH_COMMON_KEYWORD_QC_STDEV_RIGHT  "ESO QC STDEV RIGHT"
#define SPH_COMMON_KEYWORD_QC_COUNTS_LEFT  "ESO QC COUNTS LEFT"
#define SPH_COMMON_KEYWORD_QC_COUNTS_RIGHT "ESO QC COUNTS RIGHT"
#define SPH_COMMON_KEYWORD_QC_LX "ESO QC LX"
#define SPH_COMMON_KEYWORD_QC_LY "ESO QC LY"
#define SPH_COMMON_KEYWORD_QC_RX "ESO QC RX"
#define SPH_COMMON_KEYWORD_QC_RY "ESO QC RY"

#ifndef SPH_COMMON_KEYWORD_QC_DX_1
#define SPH_COMMON_KEYWORD_QC_DX_1 -250
#endif
#ifndef SPH_COMMON_KEYWORD_QC_DX_2
#define SPH_COMMON_KEYWORD_QC_DX_2 250
#endif
#ifndef SPH_COMMON_KEYWORD_QC_DY_1
#define SPH_COMMON_KEYWORD_QC_DY_1 -250
#endif
#ifndef SPH_COMMON_KEYWORD_QC_DY_2
#define SPH_COMMON_KEYWORD_QC_DY_2 250
#endif

/* Generate all 16 keys from this one (which is assumed to have 'X') */
#define SPH_COMMON_KEYWORD_QC_DXL_12 "ESO QC DXL_12"
/* Length of the above string, incl. NULL-terminator */
#define SPH_COMMON_KEYWORD_QC_DXL_SZ 14

/* Needed for anamorphism, below */
#define SPH_COMMON_KEYWORD_QC_DYL_12 "ESO QC DYL_12"
#define SPH_COMMON_KEYWORD_QC_DXL_21 "ESO QC DXL_21"

#define SPH_COMMON_KEYWORD_QC_DYR_12 "ESO QC DYR_12"
#define SPH_COMMON_KEYWORD_QC_DXR_21 "ESO QC DXR_21"

#ifndef SPH_COMMON_KEYWORD_QC_EDX_1
#define SPH_COMMON_KEYWORD_QC_EDX_1 -500
#endif
#ifndef SPH_COMMON_KEYWORD_QC_EDX_2
#define SPH_COMMON_KEYWORD_QC_EDX_2 500
#endif
#ifndef SPH_COMMON_KEYWORD_QC_EDY_1
#define SPH_COMMON_KEYWORD_QC_EDY_1 -500
#endif
#ifndef SPH_COMMON_KEYWORD_QC_EDY_2
#define SPH_COMMON_KEYWORD_QC_EDY_2 500
#endif

/* Anamorphism */
#define SPH_COMMON_KEYWORD_QC_ANAM_LEFT  "ESO QC ANAM LEFT"
#define SPH_COMMON_KEYWORD_QC_ANAM_RIGHT "ESO QC ANAM RIGHT"

/* Generate all 16 keys from this one (which is assumed to have 'X') */
#define SPH_COMMON_KEYWORD_QC_DEXL_12 "ESO QC DEXL_12"
/* Length of the above string, incl. NULL-terminator */
#define SPH_COMMON_KEYWORD_QC_DEXL_SZ 15

#define SPH_COMMON_KEYWORD_QC_FWHM "ESO QC FWHM"

#define SPH_COMMON_KEYWORD_QC_LAMPCOUNT_SZ 23
#define SPH_COMMON_KEYWORD_QC_LAMPCOUNT "ESO QC LAMP COUNTS AVG 0"

#define SPH_COMMON_KEYWORD_RA							"ESO TEL TARG ALPHA"
#define SPH_COMMON_KEYWORD_DEC							"ESO TEL TARG DELTA"
#define SPH_COMMON_KEYWORD_EPOCH						"ESO TEL TARG EPOCH"


// RA & DEC keywords used to create WCS
#define SPH_COMMON_KEYWORD_WCS_RA                           "RA"
#define SPH_COMMON_KEYWORD_WCS_DEC                          "DEC"
/*---------------------------------------------------------------------------*/
/*
 * WCS Keys
 */
/*---------------------------------------------------------------------------*/
#define SPH_COMMON_KEYWORD_WCS_CRPIXX             "CRPIX1"
#define SPH_COMMON_KEYWORD_WCS_CRPIXY             "CRPIX2"
#define SPH_COMMON_KEYWORD_WCS_CRPIXZ             "CRPIX3"
#define SPH_COMMON_KEYWORD_WCS_CRPIXX_COMMENT     "Ref pixel in X"
#define SPH_COMMON_KEYWORD_WCS_CRPIXY_COMMENT     "Ref pixel in Y"
#define SPH_COMMON_KEYWORD_WCS_CRPIXZ_COMMENT     "Ref pixel in Z"
#define SPH_COMMON_KEYWORD_WCS_CRPIXXVAL          "CRVAL1"
#define SPH_COMMON_KEYWORD_WCS_CRPIXYVAL          "CRVAL2"
#define SPH_COMMON_KEYWORD_WCS_CRPIXZVAL          "CRVAL3"
#define SPH_COMMON_KEYWORD_WCS_CRPIXXTYPE         "CTYPE1"
#define SPH_COMMON_KEYWORD_WCS_CRPIXXTYPE_VAL     "RA---TAN"
#define SPH_COMMON_KEYWORD_WCS_CRPIXYTYPE         "CTYPE2"
#define SPH_COMMON_KEYWORD_WCS_CRPIXYTYPE_VAL     "DEC--TAN"
#define SPH_COMMON_KEYWORD_WCS_CRPIXZTYPE         "CTYPE3"
#define SPH_COMMON_KEYWORD_WCS_CRPIXTYPE_COMMENT  "pixel coordinate system"
#define SPH_COMMON_KEYWORD_WCS_CRPIXXUNIT         "CUNIT1"
#define SPH_COMMON_KEYWORD_WCS_CRPIXXUNIT_VAL     "deg"
#define SPH_COMMON_KEYWORD_WCS_CRPIXYUNIT         "CUNIT2"
#define SPH_COMMON_KEYWORD_WCS_CRPIXYUNIT_VAL     "deg"
#define SPH_COMMON_KEYWORD_WCS_CRPIXZUNIT         "CUNIT3"
#define SPH_COMMON_KEYWORD_WCS_CRPIXUNIT_COMMENT  "unit of pixel step"
#define SPH_COMMON_KEYWORD_WCS_CD11               "CD1_1"
#define SPH_COMMON_KEYWORD_WCS_CD12               "CD1_2"
#define SPH_COMMON_KEYWORD_WCS_CD13               "CD1_3"
#define SPH_COMMON_KEYWORD_WCS_CD21               "CD2_1"
#define SPH_COMMON_KEYWORD_WCS_CD22               "CD2_2"
#define SPH_COMMON_KEYWORD_WCS_CD23               "CD2_3"
#define SPH_COMMON_KEYWORD_WCS_CD31               "CD3_1"
#define SPH_COMMON_KEYWORD_WCS_CD32               "CD3_2"
#define SPH_COMMON_KEYWORD_WCS_CD33               "CD3_3"
#define SPH_COMMON_KEYWORD_WCS_CD_COMMENT         "Transformation matrix element"
#define SPH_COMMON_KEYWORD_WCS_RADECSYS           "RADECSYS"
#define SPH_COMMON_KEYWORD_WCS_RADECSYS_COMMENT   "Coordinate reference frame"


/*---------------------------------------------------------------------------*/
/*
 * Keywords specific for 3D format (cf. Harald Kuntschner, ESO)
 */
/*---------------------------------------------------------------------------*/
#define SPH_COMMON_KEYWORD_3D_HDUCLASS                 "HDUCLASS"
#define SPH_COMMON_KEYWORD_3D_HDUDOC                   "HDUDOC"
#define SPH_COMMON_KEYWORD_3D_HDUVERS                  "HDUVERS"
#define SPH_COMMON_KEYWORD_3D_HDUCLAS1                 "HDUCLAS1"
#define SPH_COMMON_KEYWORD_3D_HDUCLAS2                 "HDUCLAS2"
#define SPH_COMMON_KEYWORD_3D_HDUCLAS3                 "HDUCLAS3"
#define SPH_COMMON_KEYWORD_3D_SCIDATA                  "SCIDATA"
#define SPH_COMMON_KEYWORD_3D_QUALDATA                 "QUALDATA"
#define SPH_COMMON_KEYWORD_3D_ERRDATA                  "ERRDATA"
#define SPH_COMMON_KEYWORD_3D_EXTNAME                  "EXTNAME"
#define SPH_COMMON_KEYWORD_3D_EXTVERS                  "EXTVERS"

/*---------------------------------------------------------------------------*/
/*
 * Keywords and values for testing and simulation purposes only
 */
/*---------------------------------------------------------------------------*/
#define SPH_SIM_KEYWORD_READOUTNOISE             "ESO SIMUL READOUTNOISE"
#define SPH_SIM_KEYWORD_BIAS_LVL      		      	"ESO SIMUL BIAS LEVEL"
#define SPH_SIM_KEYWORD_MEAN_LVL      		      	"ESO SIMUL MEAN LEVEL"
#define SPH_SIM_KEYWORD_MEDIAN_LVL      		  	"ESO SIMUL MEDIAN LEVEL"
#define SPH_SIM_KEYWORD_DARK_LVL        	    	"ESO SIMUL DARK CURRENT"
#define SPH_SIM_KEYWORD_LAMP_XC          	        "ESO SIMUL CALIB LAMP XC"
#define SPH_SIM_KEYWORD_LAMP_YC        		        "ESO SIMUL CALIB LAMP YC"
#define SPH_SIM_KEYWORD_LAMP_CONST       	        "ESO SIMUL CALIB LAMP CONSTFLUX"
#define SPH_SIM_KEYWORD_LAMP_RADIUS                 "ESO SIMUL CALIB LAMP RADIUS"
#define SPH_SIM_KEYWORD_LAMP_PEAK                   "ESO SIMUL CALIB LAMP PEAK"
#define SPH_SIM_KEYWORD_LAMP_WAVELENGTH_PEAK        "ESO SIMUL CALIB LAMP WAVELENGTH_PEAK"
#define SPH_SIM_KEYWORD_LAMP_WAVELENGTH_FILE        "ESO SIMUL CALIB LAMP WAVELENGTH_PROFILE_FILENAME"

#endif /* SPH_COMMON_KEYWORDS_H_ */
