/* $Id: $
 * This file is part of the SPHERE Pipeline
 * Copyright (C) 2007-2010 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 * $Author: $
 * $Date: $
 * $Revision: $
 * $Name: $
 */

#ifndef SPH_COMMON_SCIENCE_H_
#define SPH_COMMON_SCIENCE_H_

/*-----------------------------------------------------------------------------
 Includes
 -----------------------------------------------------------------------------*/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "sph_error.h"
#include "sph_master_frame.h"
#include "sph_distortion_model.h"
#include "sph_framecombination.h"
#include "sph_ird_instrument_model.h"
#include "sph_zpl_exposure.h"
#include "sph_fft.h"
#include <cpl.h>

sph_error_code
sph_common_science_reject_badpix(
        cpl_imagelist* imlist,
        cpl_imagelist* badpixs);
cpl_imagelist*
sph_common_science_calc_weights(cpl_imagelist* imlist,
                                cpl_imagelist* badpixs,
                                const cpl_image* medim) CPL_ATTR_ALLOC;
sph_error_code
sph_common_science_reject_badpix_image(
        cpl_image* im,
        cpl_image* badpixs);
cpl_frame*
sph_common_science_get_current_raw_frame(void);
sph_error_code
sph_common_science_set_weights_zero(cpl_imagelist* weights,
                                    const cpl_imagelist* badpixs);
cpl_image*
sph_common_science_remap_badpix(cpl_image* inbadpix,
        double angle, double centx,
        double centy,double dx, double dy,
        sph_distortion_model* distmap,
        double scale,
        sph_ird_instrument_model* irdmodel)
    CPL_ATTR_ALLOC;

cpl_vector*
sph_common_science_extract_angles_from_fctables( const cpl_frameset* fctables )
    CPL_ATTR_ALLOC;

sph_error_code
sph_common_science_combine_imlists(
        sph_collapse_algorithm coll_alg,
        cpl_imagelist* imlist,
        cpl_imagelist* bpixlist,
        cpl_imagelist* wlist,
        sph_master_frame** result);

sph_master_frame*
sph_common_science_calibrate_raw( const cpl_image* rawimage,
                                  const sph_master_frame* dark,
                                  const sph_master_frame* flat)
    CPL_ATTR_ALLOC;

sph_master_frame*
sph_common_science_combine(
        cpl_frameset* inframeset,
        sph_collapse_algorithm coll_alg,
        unsigned int ext_im,
        int ext_bp,
        int ext_wm) CPL_ATTR_ALLOC;
int
sph_common_science_get_current_plane(void);

sph_master_frame*
sph_common_science_combine_single_cube(
        cpl_frame* cube_frame,
        sph_collapse_algorithm coll_alg,
        unsigned int ext_im,
        int ext_bp,
        int ext_wm) CPL_ATTR_ALLOC;

sph_double_image*
sph_common_science_combine_weight_double_image_frameset( cpl_frameset* inframes)
    CPL_ATTR_ALLOC;
cpl_image*
sph_common_science_get_next_raw(cpl_frameset* rawframes, int ext)
    CPL_ATTR_ALLOC;
sph_master_frame*
sph_common_science_get_next_master_frame(cpl_frameset* frames) CPL_ATTR_ALLOC;
sph_zpl_exposure*
sph_common_science_get_next_zpl_exposure(cpl_frameset* rawframes)
    CPL_ATTR_ALLOC;
sph_zpl_exposure_imaging*
sph_common_science_get_next_zpl_exposure_imaging(cpl_frameset* rawframes)
    CPL_ATTR_ALLOC;
sph_double_image*
sph_common_science_get_next_double_image(cpl_frameset* frames) CPL_ATTR_ALLOC;
int sph_common_science_get_nraws(const cpl_frameset* rawframes, int ext);

// PIPE-6081
cpl_frameset* sph_common_science_frameset_extract_raw_single(const cpl_frameset* self,
                                                             const cpl_frame* raw);

#endif /* SPH_COMMON_SCIENCE_H_ */
