/* $Id: $
 * This file is part of the SPHERE Pipeline
 * Copyright (C) 2007-2010 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 * $Author: $
 * $Date: $
 * $Revision: $
 * $Name: $
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

/*-----------------------------------------------------------------------------
 Includes
 -----------------------------------------------------------------------------*/
#include <cpl.h>
#include "sph_error.h"
#ifndef SPH_CREATE_DETECTOR_FLAT_H_
#define SPH_CREATE_DETECTOR_FLAT_H_

sph_master_frame*
sph_create_flat(const cpl_frameset* rawframes, int do_robust, const cpl_mask* badpix,
        const sph_master_frame* dark, cpl_image** linbadpix,
        double badpix_lowtolerance, double badpix_uptolerance,
        double badpix_chisqtolerance,
        cpl_vector** lampflux_out,
        cpl_vector** counts_out,
        int extension,
        cpl_vector** lampfluxstdev_out)
                CPL_ATTR_ALLOC;

#endif /* SPH_CREATE_DETECTOR_FLAT_H_ */
