/* $Id: $
 * This file is part of the SPHERE Pipeline
 * Copyright (C) 2007-2010 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 * $Author: $
 * $Date: $
 * $Revision: $
 * $Name: $
 */

#ifndef SPH_DATASET_STATS_H_
#define SPH_DATASET_STATS_H_
#include <cpl.h>
#include "sph_dataset.h"
#include "sph_dataset_peak.h"
typedef struct _sph_dataset_stats
{
    sph_dataset*            dataset;        /* Reference to the dataset analysed */
    short                   peak_flag;      /* Flag if peak detection done */
    int                     npeaks;         /* Number of peaks detected by peak detection*/
    double                  peakthresh;     /* Threshold used for peak detection */
    double*                 peakloc;
    double                  peakproduct;
    sph_dataset_peak*		rootpeak;
} sph_dataset_stats;

sph_dataset_stats*
sph_dataset_stats_new( sph_dataset* datat );

int sph_dataset_stats_find_peaks( sph_dataset_stats* self, double fthreshold, int minpix );

int sph_dataset_stats_find_peaks_exact_number( sph_dataset_stats* self, int npeaks, double acc );

int
sph_dataset_stats_delete( sph_dataset_stats* self );

cpl_vector*
sph_dataset_stats_get_peaks_as_cpl_vector( sph_dataset_stats* self );
int sph_dataset_stats_find_peaks_tree_method( sph_dataset_stats* self,
                                  double fthreshold, int minpix );

int sph_dataset_stats_find_peaks_simple_method( sph_dataset_stats* self,
                                  double fthreshold );
#endif /*SPH_DATASET_STATS_H_*/
