/* $Id: $
 * This file is part of the SPHERE Pipeline
 * Copyright (C) 2007-2010 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 * $Author: $
 * $Date: $
 * $Revision: $
 * $Name: $
 */


#ifndef SPH_DISTORTION_MAP_H_
#define SPH_DISTORTION_MAP_H_

/*-----------------------------------------------------------------------------
                                   New types
 -----------------------------------------------------------------------------*/

#include <cpl.h>

typedef struct _sph_distortion_map_ {
    cpl_table* distvectlist;
    cpl_size   sz;
} sph_distortion_map;

typedef struct _sph_distortion_vector_ {
    double x;
    double y;
    double dx;
    double dy;
    cpl_size key;
} sph_distortion_vector;

/*-----------------------------------------------------------------------------
                                   Includes
 -----------------------------------------------------------------------------*/

#include "sph_point_pattern.h"
#include "sph_distortion_model.h"

/*-----------------------------------------------------------------------------
                              Function prototypes
 -----------------------------------------------------------------------------*/

sph_distortion_map* sph_distortion_map_new(const sph_point_pattern*,
                                           const sph_point_pattern*)
    CPL_ATTR_ALLOC;

cpl_table *
sph_distortion_map_table_create(const sph_distortion_map *,
                                const sph_distortion_model *,
                                const sph_point_pattern *,
                                double, double)
    CPL_ATTR_ALLOC;

int sph_distortion_map_get_size(const sph_distortion_map*);

cpl_error_code sph_distortion_map_get_one(const sph_distortion_map*, cpl_size,
                                          sph_distortion_vector*);

const double * sph_distortion_map_get_data_x(const sph_distortion_map*);
const double * sph_distortion_map_get_data_y(const sph_distortion_map*);
const double * sph_distortion_map_get_data_dx(const sph_distortion_map*);
const double * sph_distortion_map_get_data_dy(const sph_distortion_map*);

cpl_error_code sph_distortion_map_append_one(sph_distortion_map*,
                                             double, double,
                                             double, double);

int sph_distortion_map_remove_offset(sph_distortion_map*,
                                     double*, double*);

void sph_distortion_map_add(sph_distortion_map*,
                            const sph_point_pattern*)
    CPL_ATTR_NONNULL;


int sph_distortion_map_threshold(sph_distortion_map*, double, cpl_boolean);

int sph_distortion_map_delete_multi(sph_distortion_map*);

void sph_distortion_map_delete(sph_distortion_map*);

#endif /* SPH_DISTORTION_MAP_H_ */
