/* $Id: $
 * This file is part of the SPHERE Pipeline
 * Copyright (C) 2007-2010 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 * $Author: $
 * $Date: $
 * $Revision: $
 * $Name: $
 */

#ifndef SPH_FCTABLE_H_
#define SPH_FCTABLE_H_

/*-----------------------------------------------------------------------------
 Includes
 -----------------------------------------------------------------------------*/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "sph_error.h"
#include <cpl.h>

enum _sph_fctab_mode_ {
        SPH_FCTAB_UNDEFINED = 0,
        SPH_FCTAB_SINGLE = 1,
        SPH_FCTAB_DOUBLE = 2
};

typedef enum _sph_fctab_mode_ sph_fctab_mode__;

typedef struct _sph_fc_table_ {
    cpl_vector*     centresL_x;
    cpl_vector*     centresL_y;
    cpl_vector*     centresR_x;
    cpl_vector*     centresR_y;
    cpl_vector*     centresL_x_err;
    cpl_vector*     centresL_y_err;
    cpl_vector*     centresR_x_err;
    cpl_vector*     centresR_y_err;
    cpl_vector*     angles;
    cpl_vector*     times;
    cpl_vector*     angles_err;
    sph_fctab_mode__    mode;
} sph_fctable;


sph_fctable*  sph_fctable_new(void)
    CPL_ATTR_ALLOC;

int sph_fctable_get_size(const sph_fctable* self);

sph_fctable*
sph_fctable_load_ascii(const char* filename)
    CPL_ATTR_ALLOC;

cpl_vector*
sph_fctable_get_times(const sph_fctable* self)
    CPL_ATTR_ALLOC;

sph_error_code
sph_fctable_add_row_single(sph_fctable* self,
        double mjd,
        double cx, double cy, double angle);

sph_fctable*
sph_fctable_load_fits(const char* filename)
    CPL_ATTR_ALLOC;
sph_fctable*
sph_fctable_load_fits_IRDIS(const char* filename)
    CPL_ATTR_ALLOC;
sph_error_code
sph_fctable_set_cent_double(
		sph_fctable* self,
		int row,
		double clx, double cly, double crx, double cry);
double
sph_fctable_get_time(const sph_fctable* self, int idx);
double
sph_fctable_get_centre_x_element(const sph_fctable* self, int idx);
double
sph_fctable_get_centre_y_element(const sph_fctable* self, int idx);
cpl_vector*
sph_fctable_get_centre_x(const sph_fctable* self)
    CPL_ATTR_ALLOC;
cpl_vector*
sph_fctable_get_centre_y(const sph_fctable* self)
    CPL_ATTR_ALLOC;
char*
sph_fctable_construct_filename( const cpl_frame* inframe, int txtflag )
    CPL_ATTR_ALLOC;
double
sph_fctable_get_centre_x_left_element(const sph_fctable* self, int idx);
double
sph_fctable_get_centre_y_left_element(const sph_fctable* self, int idx);
double
sph_fctable_get_centre_x_right_element(const sph_fctable* self, int idx);
double
sph_fctable_get_centre_y_right_element(const sph_fctable* self, int idx);

cpl_vector*
sph_fctable_get_centre_x_left(const sph_fctable* self)
    CPL_ATTR_ALLOC;
cpl_vector*
sph_fctable_get_centre_y_left(const sph_fctable* self)
    CPL_ATTR_ALLOC;
cpl_vector*
sph_fctable_get_centre_x_right(const sph_fctable* self)
    CPL_ATTR_ALLOC;
cpl_vector*
sph_fctable_get_centre_y_right(const sph_fctable* self)
    CPL_ATTR_ALLOC;
cpl_vector*
sph_fctable_get_angles(const sph_fctable* self)
    CPL_ATTR_ALLOC;

double
sph_fctable_get_angle(const sph_fctable* self, int idx);

sph_error_code
sph_fctable_save_ascii( const sph_fctable* self, const char* filename );
sph_error_code
sph_fctable_add_row_double(sph_fctable* self,
        double mjd,
        double clx, double cly, double crx,
        double cry, double angle);
void sph_fctable_delete(sph_fctable* self);
cpl_table*
sph_fctable_get_as_cpl_table(const sph_fctable* self)
    CPL_ATTR_ALLOC;

//Two functions below should be merged! Used for the moment to avoid the problem between sub-systems
sph_fctable*
sph_fctable_create_fctable( const cpl_frame* raw_science_frame, int mode )
    CPL_ATTR_ALLOC;
sph_fctable*
sph_fctable_create_fctable_new( const cpl_frame* raw_science_frame, int mode )
    CPL_ATTR_ALLOC;


sph_error_code
sph_fctable_set_angle(
		sph_fctable* self,
		int row,
		double angle,
		double angle_err);

sph_error_code
sph_fctable_fill_angle(
        sph_fctable* self,
        double angle,
        double angle_err);


sph_fctable*
sph_fctable_find_fctable(
        const cpl_frame* raw_science_frame,
        const cpl_frameset* star_centre_calib_frameset
        )
    CPL_ATTR_ALLOC;

sph_error_code
sph_fctable_add_angle_scalar( sph_fctable* self, double angle );

sph_error_code
sph_fctable_add_center_offset_single_mode( sph_fctable* self, double cx, double cy );

sph_error_code
sph_fctable_add_center_offset_double_mode( sph_fctable* self, double clx, double cly, double crx, double cry ) ;

#endif /* SPH_FCTABLE_H_ */
