/* $Id: $
 * This file is part of the SPHERE Pipeline
 * Copyright (C) 2007-2010 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 * $Author: $
 * $Date: $
 * $Revision: $
 * $Name: $
 */

#ifndef SPH_FRAME_VALIDATOR_H_
#define SPH_FRAME_VALIDATOR_H_

#include <cpl.h>

typedef enum _sph_frame_validator_result_ {
	SPH_FRAME_VALIDATOR_VALIDATED,
	SPH_FRAME_VALIDATOR_NOT_VALIDATED,
	SPH_FRAME_VALIDATOR_ERROR
} sph_frame_validator_result;

sph_frame_validator_result
sph_frame_validator_validate_contains_keywords_soft( const cpl_frame* is,
                                                     int ext,
                                                     const cpl_propertylist* plist,
                                                     short care_about_value );
sph_frame_validator_result
sph_frame_validator_validate_identical( const cpl_frame* is,
                                        const cpl_frame* shouldbe );
#ifdef SPH_FRME_VALIDATOR_UNUSED
sph_frame_validator_result
sph_frame_validator_validate_identical_image_nearest_int_ignore_bads( cpl_frame* is, cpl_frame* shouldbe );
sph_frame_validator_result
sph_frame_validator_validate_identical_nearest_int( cpl_frame* is, cpl_frame* shouldbe );
sph_frame_validator_result
sph_frame_validator_validate_identical_image_ignore_bads( cpl_frame* is, cpl_frame* shouldbe );
#endif
sph_frame_validator_result
sph_frame_validator_warn_keyword_tolerance( const cpl_frameset* inframes,
        int ext, const char* keyname, double tol, cpl_frameset* badoutlist );
#endif /* SPH_FRAME_VALIDATOR_H_ */
