/* $Id: $
 * This file is part of the SPHERE Pipeline
 * Copyright (C) 2007-2010 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 * $Author: $
 * $Date: $
 * $Revision: $
 * $Name: $
 */

#ifndef SPH_FRAMECOMBINATION_H_
#define SPH_FRAMECOMBINATION_H_

enum _sph_coll_alg_ {
	    SPH_COLL_ALG_MEAN = 0,
	    SPH_COLL_ALG_MEDIAN = 1,
	    SPH_COLL_ALG_CLEAN_MEAN = 2,
	    SPH_COLL_ALG_WGT_MEAN = 3
};

typedef enum _sph_coll_alg_ sph_collapse_algorithm;
#include "sph_ldt.h"
#include "sph_master_frame.h"
#include "sph_double_image.h"
#include "sph_triple_image.h"
#include "sph_quad_image.h"


typedef enum _sph_framecombination_method_ {
	SPH_FRAMECOMBINATION_METHOD_GIMROS = 1,
	SPH_FRAMECOMBINATION_METHOD_CPLWARP = 2,
	SPH_FRAMECOMBINATION_METHOD_GSLFFT = 3
} sph_framecombination_method;

typedef struct _sph_framecombination_cplwarp_params_ {
	cpl_image*		dx;
	cpl_image*		dy;
	cpl_kernel		kernel;
} sph_framecombination_cplwarp_params ;

typedef struct _sph_framecombination_ {
	sph_framecombination_method method;
	void*	pmethod;
	sph_master_frame*	subtract_mframe;
	sph_ldt* subtract_ldt;
	int	ignoreang;
	int	ignoredither;
	double tr_radius;
} sph_framecombination;

cpl_frameset*
sph_framecombination_collapse_cubes(cpl_frameset* rawframes,
        sph_collapse_algorithm collalg,
        cpl_parameterlist* framecomb_parameterlist,
        const char* recname,
        const char* tagname);
sph_framecombination*
sph_framecombination_new( void );
cpl_image*
sph_framecombination_rotate_image( sph_framecombination* self, cpl_image* im, double degrees);

cpl_image*
sph_framecombination_apply_gimros( cpl_image* im, double degrees, double dx, double dy );
cpl_image*
sph_framecombination_apply_gslfft( cpl_image* imin, double degrees, double dx, double dy, double top_hat_radius );
cpl_image*
sph_framecombination_apply_cplwarp( sph_framecombination_cplwarp_params* params, cpl_image* im, double degrees, double dx, double dy );
void sph_framecombination_set_method_gimros( sph_framecombination* self );
void sph_framecombination_set_method_gslfft( sph_framecombination* self, double filter_radius );
void sph_framecombination_set_method_cplwarp( sph_framecombination* self, cpl_kernel kernel );

sph_master_frame*
sph_framecombination_new_master_frame_from_cpl_frame_multi_ext( cpl_frame* inframe, int extension,
                                        const sph_collapse_algorithm alg,
                                        cpl_parameterlist* parlist );

sph_master_frame*
sph_framecombination_master_frame_from_master_frameset( cpl_frameset* inframes,
                                        const sph_collapse_algorithm alg,
                                        cpl_parameterlist* parlist );
sph_master_frame*
sph_framecombination_master_frame_from_frameset(const cpl_frameset* inframes,
                                                const sph_collapse_algorithm alg,
                                                const cpl_parameterlist* parlist,
                                                int extension );

sph_ldt*
sph_framecombination_rotate_ldt( sph_framecombination* self, sph_ldt* ldtin, double degrees);

cpl_image*
sph_framecombination_shift_image( sph_framecombination* self, cpl_image* im, double dx, double dy);
sph_master_frame*
sph_framecombination_combine_master_frames_overwrite( sph_framecombination* self,
				cpl_frameset* frames, sph_collapse_algorithm collalg, cpl_parameterlist* colparams );
sph_ldt*
sph_framecombination_combine_ldt_overwrite( sph_framecombination* self,
					    cpl_frameset* frames );
void
sph_framecombination_delete( sph_framecombination* self );
sph_master_frame*
sph_framecombination_master_frame_from_cpl_frameset( const cpl_frameset* inframes,
                                                     const sph_collapse_algorithm alg,
                                                     const cpl_parameterlist* parlist );
sph_master_frame* sph_framecombination_master_frame_new_collapse(cpl_imagelist* imagelist,
											const sph_collapse_algorithm collapse_alg,
											const cpl_parameterlist* allgparlist);

sph_master_frame* sph_framecombination_master_frame_new_mean_weight_from_cpl_framest( const cpl_frameset* inframes )
    CPL_ATTR_ALLOC;


sph_double_image*
sph_framecombination_double_image_new_from_cpl_frameset( cpl_frameset* inframes,
                                        const sph_collapse_algorithm alg,
                                        const cpl_parameterlist* parlist );
sph_double_image*
sph_framecombination_double_image_from_frameset( cpl_frameset* inframes,
										const sph_collapse_algorithm alg,
										cpl_parameterlist*	parlist );


sph_quad_image* sph_framecombination_quad_image_new_from_cpl_frameset( cpl_frameset* inframes,
                                       const sph_collapse_algorithm alg,
                                       const cpl_parameterlist* parlist );

sph_quad_image*
sph_framecombination_quad_image_new_from_cpl_frameset_multi_cubes( cpl_frameset* inframes,
                                        const sph_collapse_algorithm alg,
                                        cpl_parameterlist* parlist );

sph_quad_image*
sph_framecombination_quad_image_from_frameset( cpl_frameset* inframes,
										const sph_collapse_algorithm alg,
										cpl_parameterlist*	parlist );


sph_triple_image*
sph_framecombination_triple_image_new_from_cpl_frameset(cpl_frameset*,
                                                        const sph_collapse_algorithm,
                                                        const cpl_parameterlist*);


#endif /*SPH_FRAMECOMBINATION_H_*/

