/* $Id: $
 * This file is part of the SPHERE Pipeline
 * Copyright (C) 2007-2010 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 * $Author: $
 * $Date: $
 * $Revision: $
 * $Name: $
 */

#ifndef SPH_IMAGE_GRID_H_
#define SPH_IMAGE_GRID_H_
#include "sph_polygon.h"
#include "cpl.h"
#include "sph_error.h"

enum _sph_image_grid_av_method_ {
    SPH_IMAGE_GRID_TOTAL = 0,
    SPH_IMAGE_GRID_MIN = 1,
    SPH_IMAGE_GRID_MAX = 2,
};

typedef enum _sph_image_grid_av_method_ sph_image_grid_av_method;


typedef struct _sph_image_grid_ {
    int nx;
    int ny;
    sph_polygon*	boundbox;
    sph_polygon**    polys;
    double*         values;
} sph_image_grid;


sph_image_grid* sph_image_grid_new( void ) CPL_ATTR_ALLOC;
cpl_image*
sph_image_grid_extract_image( sph_image_grid* self ) CPL_ATTR_ALLOC;
sph_error_code
sph_image_grid_get_xy( sph_image_grid* target, double x, double y, int* pix, int* piy );

sph_error_code sph_image_grid_rotate_and_shift( sph_image_grid* self, double cx, double cy, double degrees, double dx, double dy );

sph_image_grid* sph_image_grid_new_from_image( cpl_image*,
                                               double minx,
                                               double maxx,
                                               double miny,
                                               double maxy ) CPL_ATTR_ALLOC;

sph_error_code
sph_image_grid_map_polygon( sph_image_grid* target, sph_polygon* poly, double val );

sph_error_code sph_image_grid_map_to_target( sph_image_grid* self,
                                             sph_image_grid* target );
double
sph_image_grid_map_to_polygon( sph_image_grid* source, sph_polygon* targetpoly );
sph_error_code
sph_image_grid_map_polygon_midpoint( sph_image_grid* target, sph_polygon* poly, double value, sph_image_grid_av_method method );
void sph_image_grid_delete( sph_image_grid* self);
sph_error_code
sph_image_grid_mark_point( sph_image_grid* self, double x, double y, double val );
sph_polygon* sph_image_grid_get_element( sph_image_grid* self, int x, int y);

#endif /*SPH_IMAGE_GRID_H_*/
