/* $Id: $
 * This file is part of the SPHERE Pipeline
 * Copyright (C) 2007-2010 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 * $Author: $
 * $Date: $
 * $Revision: $
 * $Name: $
 */
#ifndef SPH_KEYWORD_MANAGER_H_
#define SPH_KEYWORD_MANAGER_H_

#include <cpl_propertylist.h>

#include "sph_error.h"
#include "sph_keywordnode.h"

typedef struct _sph_keyword_manager_ {
    sph_keywordnode*         root;
    cpl_propertylist*       plist;
    cpl_propertylist*       plistsoft;
    cpl_frame*              current_frame;
} sph_keyword_manager;
extern sph_error_code SPH_KEYWORD_MANAGER_GENERAL;
extern sph_error_code SPH_KEYWORD_MANAGER_CANT_READ_CONFIG;
extern sph_error_code SPH_KEYWORD_MANAGER_NO_ROOT;
extern sph_error_code SPH_KEYWORD_MANAGER_NO_SOFTPLIST;
extern sph_error_code SPH_KEYWORD_MANAGER_NOT_FOUND_IN_SOFTPLIST;
extern sph_error_code SPH_KEYWORD_MANAGER_NOT_FOUND;

sph_keyword_manager* sph_keyword_manager_new( void );

const char* sph_keyword_manager_set_cfg(const char*)
    CPL_ATTR_NONNULL;
const char* sph_keyword_manager_get_cfg(void);

const char* sph_keyword_manager_get_keyword( const char* key );

int sph_keyword_manager_get_int( const char* key );
sph_error_code
sph_keyword_manager_read_config( const char* filename );
const char* sph_keyword_manager_get_string( const char* key );
sph_error_code
sph_keyword_manager_get_properties_from_file( const char* czFilename, int ext );

sph_error_code
sph_keyword_manager_get_properties_from_frame( cpl_frame* frame, int ext );

sph_error_code
sph_keyword_manager_get_properties_from_ascii( const char* czFilename, const char* sect );

sph_error_code
sph_keyword_manager_traverse( sph_keywordnode* node );

sph_error_code
sph_keyword_manager_update_int1(
        cpl_propertylist* proplist,
        const char* keyname,
        int x,
        int value );

sph_error_code
sph_keyword_manager_update_int_char(
        cpl_propertylist* proplist,
        const char* keyname,
        char x,
        int value );

sph_error_code
sph_keyword_manager_update_string_char(
        cpl_propertylist* proplist,
        const char* keyname,
        char x,
        const char* value );
sph_error_code
sph_keyword_manager_update_double_char_int2(
        cpl_propertylist* proplist,
        const char* keyname,
        char x,
        int n,
        int i,
        double value );
sph_error_code
sph_keyword_manager_vector2proplist(
        cpl_propertylist* pl,
        const cpl_vector* vec,
        const char* keybase);
sph_error_code
sph_keyword_manager_update_double1(
        cpl_propertylist* proplist,
        const char* keyname,
        int x,
        double value );
sph_error_code
sph_keyword_manager_update_double_char(
        cpl_propertylist* proplist,
        const char* keyname,
        char x,
        double value );
sph_error_code
sph_keyword_manager_update_double_char_int(
        cpl_propertylist* proplist,
        const char* keyname,
        char x,
        int y,
        double value );
sph_error_code
sph_keyword_manager_update_double2(
        cpl_propertylist* proplist,
        const char* keyname,
        int x,
        int y,
        double value );

cpl_propertylist*
sph_keyword_manager_load_properties( const char* czFilename, int ext )
    CPL_ATTR_ALLOC;
sph_error_code
sph_keyword_manager_load_keywords( const char* czFilename, int ext );
cpl_propertylist*
sph_keyword_manager_trans_keywords( const cpl_propertylist* plist )
    CPL_ATTR_ALLOC;
sph_error_code sph_keyword_manager_delete( void );

#endif /*SPH_KEYWORD_MANAGER_H_*/
