/* $Id: $
 * This file is part of the SPHERE Pipeline
 * Copyright (C) 2007-2010 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 * $Author: $
 * $Date: $
 * $Revision: $
 * $Name: $
 */

#ifndef SPH_KEYWORD_READER_H_
#define SPH_KEYWORD_READER_H_

#include "sph_error.h"
#include <cpl.h>

typedef struct _sph_keyword_reader_ {
	cpl_table* 			table;
	cpl_propertylist*   proplist;
	
	short				alwaysoverride;
	int					nrows;
} sph_keyword_reader;

sph_keyword_reader* 
sph_keyword_reader_new(void) CPL_ATTR_ALLOC;
sph_keyword_reader* 
sph_keyword_reader_new_load( const char* czFilename ) CPL_ATTR_ALLOC;

char*
sph_keyword_reader_get_value_string( const sph_keyword_reader* self,
                                     const char* tag ) CPL_ATTR_ALLOC;
int
sph_keyword_reader_get_value_int( const sph_keyword_reader* self,
                                  const char* tag );
double
sph_keyword_reader_get_value_double( const sph_keyword_reader* self,
                                     const char* tag );
sph_error_code
sph_keyword_reader_set_proplist_from_file( sph_keyword_reader* self,
                                           const char* czFilename,
                                           int extension );
sph_error_code 
sph_keyword_reader_delete( sph_keyword_reader* self );

#endif /*SPH_KEYWORD_READER_H_*/
