/* $Id: $
 * This file is part of the SPHERE Pipeline
 * Copyright (C) 2007-2010 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 * $Author: $
 * $Date: $
 * $Revision: $
 * $Name: $
 */

#ifndef SPH_LINE_H_
#define SPH_LINE_H_
#include "sph_point.h"

typedef struct _sph_line_ {
    sph_point* p1;
    sph_point* p2;
} sph_line;


sph_line* sph_line_new(double x1,
                       double y1,
                       double x2,
                       double y2) CPL_ATTR_ALLOC;

void sph_line_delete( sph_line* self );

short sph_line_intersect_test(const sph_line* lineA,
                              const sph_line* lineB)
    CPL_ATTR_NONNULL;

sph_error_code sph_line_intersect_point(sph_point* self,
                                        const sph_line* lineA,
                                        const sph_line* lineB)
    CPL_ATTR_NONNULL;

#endif /*SPH_LINE_H_*/
