/* $Id: $
 * This file is part of the SPHERE Pipeline
 * Copyright (C) 2007-2010 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 * $Author: $
 * $Date: $
 * $Revision: $
 * $Name: $
 */

#ifndef SPH_PAINT_POLYGON_H_
#define SPH_PAINT_POLYGON_H_

/*-----------------------------------------------------------------------------
                                   Includes
 -----------------------------------------------------------------------------*/

#include "sph_master_frame.h"

/*-----------------------------------------------------------------------------
                              Function prototypes
 -----------------------------------------------------------------------------*/

sph_error_code
sph_paint_polygon_on_master(
        sph_master_frame* self,
        sph_polygon* poly,
        double imval,
        double bpixval,
        double rmsval,
        double weightval,
        cpl_image* overlaps );

sph_error_code
sph_paint_polygon_on_master_image(
        sph_master_frame* self,
        sph_polygon* poly,
        double val );
sph_error_code
sph_paint_polygon_on_master_image_avg(
        sph_master_frame* self,
        sph_polygon* poly,
        double val );
sph_error_code
sph_paint_polygon_on_master_bpix(
        sph_master_frame* self,
        sph_polygon* poly,
        double val );
sph_error_code
sph_paint_polygon_on_master_weightmap(
        sph_master_frame* self,
        sph_polygon* poly,
        double val );
sph_error_code
sph_paint_polygon_on_master_rmsmap(
        sph_master_frame* self,
        sph_polygon* poly,
        double val );

cpl_image* sph_paint_polygon_get_overlap_image(const sph_master_frame* self,
                                               const sph_polygon* poly,
                                               sph_polygon_workspace* ws)
    CPL_ATTR_ALLOC ;

#endif /* SPH_PAINT_POLYGON_H_ */
