/* $Id: $
 * This file is part of the SPHERE Pipeline
 * Copyright (C) 2007-2010 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 * $Author: $
 * $Date: $
 * $Revision: $
 * $Name: $
 */

/*----------------------------------------------------------------------------*/
/**
 * @defgroup sph_pixel_descriptor Pixel Descriptor Object   
 *
 * @par Synopsis:
 * @code
 * typedef struct _sph_pixel_descriptor
{
    short                   x;  // pixel x
    short                   y;  // pixel y
    float                   value;
    short                   lensid; // lenslet id
    float                   wavelength; // mean wavelength
    float                   illumination; // illumination fraction
    float                   dlambda; // the range of wavelength in the pixel
    float                   ddlambda; // the second derivative within the pixel
} sph_pixel_descriptor;
 * @endcode
 * @par Descirption:
 * This module provides functions to define and operate on a pixel
 * in the IFS wavelength calibration pixel description table (PDT).
 * 
 * In the present design, this module only contains a structure that is 
 * directly accessed in recipes and other API functions. 
 */
/*----------------------------------------------------------------------------*/
/**@{*/

/*-----------------------------------------------------------------------------
 Function definitions
 -----------------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/**
 * 
 * 
 * 
 */
/*----------------------------------------------------------------------------*/

/**@}*/
