/* $Id: $
 * This file is part of the SPHERE Pipeline
 * Copyright (C) 2007-2010 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 * $Author: $
 * $Date: $
 * $Revision: $
 * $Name: $
 */

#ifndef SPH__H_
#define SPH__H_

/*-----------------------------------------------------------------------------
 Includes
 -----------------------------------------------------------------------------*/
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "sph_error.h"
#include <cpl.h>

typedef struct _sph_psfcube_ {
    cpl_imagelist*    imlist;
    cpl_vector*       xpos;
    cpl_vector*       ypos;
} sph_psfcube;

sph_psfcube* sph_psfcube_new( cpl_imagelist* imlistin,
                              cpl_vector* xin,
                              cpl_vector* yin)
    CPL_ATTR_ALLOC;

void
sph_psfcube_delete(sph_psfcube* self);

const cpl_image*
sph_psfcube_get_exact( const sph_psfcube* self, double dx, double dy);
const cpl_image*
sph_psfcube_get( const sph_psfcube* self, double dx, double dy);
sph_error_code
sph_psfcube_insert( sph_psfcube* self, cpl_image* im, double dx, double dy);
int
sph_psfcube_get_size( const sph_psfcube* self);
int
sph_psfcube_get_npix_side( const sph_psfcube* self);

#endif /* SPH__H_ */
