/* $Id: $
 * This file is part of the SPHERE Pipeline
 * Copyright (C) 2007-2010 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 * $Author: $
 * $Date: $
 * $Revision: $
 * $Name: $
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

/*-----------------------------------------------------------------------------
 Includes
 -----------------------------------------------------------------------------*/
#include <cpl.h>
#include "sph_error.h"
#include "sph_pixel_polyfit_table.h"
#include "sph_framecombination.h"
#ifndef SPH_PTC_H_
#define SPH_PTC_H_
sph_error_code
sph_ptc_fit( sph_pixel_polyfit_table* fittab,
        int ox,
        int oy,
        cpl_imagelist* valimlist,
        cpl_imagelist* errimlist, int order );


sph_pixel_polyfit_table*
sph_ptc_create_full(
        cpl_frameset* inframes,
        int order);
cpl_vector* sph_ptc_calculate_means(
        cpl_frameset* rawframes,
        sph_collapse_algorithm collalg,
        cpl_parameterlist* params,
        cpl_mask*   mask,
        cpl_vector** stdev,
        cpl_vector** errs);
sph_pixel_polyfit_table*
sph_ptc_create(
        cpl_frameset* inframes,
        cpl_parameterlist* params,
        cpl_vector** means_out,
        cpl_vector** vals_out,
        sph_collapse_algorithm colalg,
        int order, double sigclip);
cpl_vector* sph_ptc_calculate_medians(
        cpl_frameset* collapsed_frames,
        cpl_mask*   mask,
        cpl_vector** stdev,
        cpl_vector** errs);
#endif /* SPH_PTC_H_ */
