/* $Id: $
 * This file is part of the SPHERE Pipeline
 * Copyright (C) 2007-2010 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 * $Author: $
 * $Date: $
 * $Revision: $
 * $Name: $
 */

#ifndef SHARED_IRDIFS_H_
#define SHARED_IRDIFS_H_

/*-----------------------------------------------------------------------------
 Includes
 -----------------------------------------------------------------------------*/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <cpl.h>
#include "sph_error.h"
#include "sph_framecombination.h"

/*-----------------------------------------------------------------------------
 Defines
 -----------------------------------------------------------------------------*/
#ifndef SPH_IRD_MASTER_DARK_RON_LLX
#define SPH_IRD_MASTER_DARK_RON_LLX 500
#endif
#ifndef SPH_IRD_MASTER_DARK_RON_URX
#define SPH_IRD_MASTER_DARK_RON_URX 1300
#endif
#ifndef SPH_IRD_MASTER_DARK_RON_LLY
#define SPH_IRD_MASTER_DARK_RON_LLY 200
#endif
#ifndef SPH_IRD_MASTER_DARK_RON_URY
#define SPH_IRD_MASTER_DARK_RON_URY 800
#endif
#ifndef SPH_IRD_MASTER_DARK_RON_NIMG
#define SPH_IRD_MASTER_DARK_RON_NIMG 3
#endif
#ifndef SPH_IRD_MASTER_DARK_RON_NLAST
#define SPH_IRD_MASTER_DARK_RON_NLAST 10
#endif

#ifndef SPH_IFS_MASTER_DARK_RON_LLX
#define SPH_IFS_MASTER_DARK_RON_LLX 200
#endif
#ifndef SPH_IFS_MASTER_DARK_RON_URX
#define SPH_IFS_MASTER_DARK_RON_URX 1900
#endif
#ifndef SPH_IFS_MASTER_DARK_RON_LLY
#define SPH_IFS_MASTER_DARK_RON_LLY 200
#endif
#ifndef SPH_IFS_MASTER_DARK_RON_URY
#define SPH_IFS_MASTER_DARK_RON_URY 1900
#endif
#ifndef SPH_IFS_MASTER_DARK_RON_NIMG
#define SPH_IFS_MASTER_DARK_RON_NIMG 5
#endif
#ifndef SPH_IFS_MASTER_DARK_RON_NLAST
#define SPH_IFS_MASTER_DARK_RON_NLAST 10
#endif

/*-----------------------------------------------------------------------------
                        Private function prototypes
 -----------------------------------------------------------------------------*/

sph_master_frame*
sph_irdifs_master_dark_create(cpl_frameset* rawframes,
        sph_collapse_algorithm coll_alg, cpl_parameterlist* framecomb,
        double sigma_clip, double smoothing, double min_accept,
        double max_accept, int nskip, cpl_image** static_bpix);

sph_pixel_polyfit_table*
sph_irdifs_detector_persistence_create_fit(sph_master_frame* dark, int fitorder,
        cpl_frameset* rawframes);
cpl_error_code
sph_irdifs_detector_persistence_run(cpl_frame* static_badpixel_frame,
        cpl_frame* master_dark_frame, cpl_frameset* satframes,
        cpl_frameset* unsatframes, sph_collapse_algorithm coll_alg,
        cpl_parameterlist* framecomb_parameterlist, cpl_frameset* rawframes,
        cpl_frameset* inframes, cpl_parameterlist * inparams,
        double threshold_dark, double threshold_ill, double fitorder,
        const char* outfilename, const char* tag, const char* recipe,
        const char* pipeline);
cpl_vector*
sph_irdifs_detector_persistence_get_timing(cpl_frameset** prawframes,
        double atime0);

double sph_irdifs_compute_ron(const cpl_frameset* self,
                              cpl_size nimg,
                              cpl_size nlast,
                              cpl_size llx,
                              cpl_size lly,
                              cpl_size urx,
                              cpl_size ury);

void sph_irdifs_qc_persistance(cpl_propertylist* self,
                               sph_master_frame* mframe,
                               const cpl_propertylist* plist,
                               cpl_size lollx,
                               cpl_size lolly,
                               cpl_size lourx,
                               cpl_size loury,
                               cpl_size hillx,
                               cpl_size hilly,
                               cpl_size hiurx,
                               cpl_size hiury);

void sph_irdifs_bg_qc_rate(cpl_propertylist* self,
                           const cpl_propertylist* other,
                           const char * mediankey);

#endif /* SHARED_IRDIFS_H_ */
