/* $Id: $
 * This file is part of the SPHERE Pipeline
 * Copyright (C) 2007-2010 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 * $Author: $
 * $Date: $
 * $Revision: $
 * $Name: $
 */
#include <stdlib.h>
#include "sph_spectral_region.h"
#include <cpl.h>
/*----------------------------------------------------------------------------*/
/**
 @brief Create a new empty spectral region

 @return the new region

 */
/*----------------------------------------------------------------------------*/
sph_spectral_region* sph_spectral_region_new( void ) {
    sph_spectral_region* region    = NULL;

    region = cpl_calloc( 1, sizeof( sph_spectral_region ) );
    return region;
}
/*----------------------------------------------------------------------------*/
/**
 @brief Delete the spectral region

 @param self     the spectral region to delete

*/
/*----------------------------------------------------------------------------*/
void sph_spectral_region_delete( sph_spectral_region* self ) {
    if ( self ) {
        cpl_free( self );
    }
}
