/* $Id: $
 * This file is part of the SPHERE Pipeline
 * Copyright (C) 2007-2010 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 * $Author: $
 * $Date: $
 * $Revision: $
 * $Name: $
 */

#ifndef SPH_SPECTRAL_REGION_H_
#define SPH_SPECTRAL_REGION_H_

typedef struct _sph_spectral_region_ {
	int				specid;
	int				lensid;
	double			minx;
	double			maxx;
	double			miny;
	double			maxy;
} sph_spectral_region;

sph_spectral_region* sph_spectral_region_new( void );

void sph_spectral_region_delete( sph_spectral_region* self );

#endif /* SPH_SPECTRAL_REGION_H_ */
