/* $Id: $
 * This file is part of the SPHERE Pipeline
 * Copyright (C) 2007-2010 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 * $Author: $
 * $Date: $
 * $Revision: $
 * $Name: $
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

/*-----------------------------------------------------------------------------
 Includes
 -----------------------------------------------------------------------------*/
#include <cpl.h>
#include "sph_error.h"
#include "sph_fft.h"
#include "sph_ird_instrument_model.h"
#include "sph_distortion_model.h"
#include "sph_master_frame.h"
#include "sph_double_image.h"
#ifndef SPH_TRANSFORM_H_
#define SPH_TRANSFORM_H_

typedef enum sph_transform_method____ {
    SPH_TRANSFORM_METHOD_FFT,
    SPH_TRANSFORM_METHOD_CPL_WARP
} sph_transform_method;

typedef struct sph_transform____ {
    sph_transform_method method;
    sph_fft_filter_method filt_method;
    double  fft_filter_radius;
    double  fft_fermi_temp;
    double  fft_butter_pass;
    double  fft_butter_stop;
    cpl_kernel          kerneltype;
     double              radius;
} sph_transform;

sph_transform* sph_transform_new_default(void) CPL_ATTR_ALLOC;

sph_transform* sph_transform_new_cpl_warp(void) CPL_ATTR_ALLOC;

sph_transform* sph_transform_new_fft(sph_fft_filter_method filtmethod,
                                     double param1,
                                     double param2)   CPL_ATTR_ALLOC;
sph_error_code
sph_transform_apply(
        sph_transform* self,
        sph_master_frame* mframe,
        sph_distortion_model* distortionmap,
        double centx,
        double centy,
        double angle,
        double scale,
        sph_ird_instrument_model* irdmodel);
sph_error_code
sph_transform_apply_to_doubleimage_doublemode(
        sph_transform* self,
        sph_double_image* doubleimage,
        sph_distortion_model* distortionmap,
        double centlx,
        double cently,
        double centrx,
        double centry,
        double angle,
        double scale);
sph_error_code
sph_transform_apply_to_doubleimage(
        sph_transform* self,
        sph_double_image* doubleimage,
        sph_distortion_model* distortionmap,
        double centx,
        double centy,
        double angle,
        double scale);

sph_error_code
sph_transform_apply_to_images(
        sph_transform* self,
        cpl_image** image,
        cpl_image** badpix,
        cpl_image** ncombmap,
        cpl_image** rmsmap,
        sph_distortion_model* distortionmap,
        double centx,
        double centy,
        double angle,
        double scale,
        sph_ird_instrument_model* irdmodel);
cpl_image*
sph_transform_remap_badpix(
        sph_transform* self,
        const cpl_image* inbadpix,
        double angle, double centx,
        double centy,double dx0, double dy0,
        sph_distortion_model* distmap,
        double      scale,
        const sph_ird_instrument_model* irdmodel)
                            CPL_ATTR_ALLOC;

void
sph_transform_delete(sph_transform* self);

#endif /* SPH_TRANSFROM_H_ */
