/* $Id: $
 * This file is part of the SPHERE Pipeline
 * Copyright (C) 2007-2010 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 * $Author: $
 * $Date: $
 * $Revision: $
 * $Name: $
 */

/*-----------------------------------------------------------------------------
 Includes
 -----------------------------------------------------------------------------*/

#include "sph_unsharp_mask.h"
#include "sph_utils.h"
#include "sph_fitting.h"

#include <cpl.h>

/*-----------------------------------------------------------------------------
 Definition of Functions
 -----------------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/**
 @internal
 @brief  TODO
 @param  inimage Input image
 @param  winsize Window size
 @return Created image or NULL on error
 @note This function needs more documentation
 */
/*----------------------------------------------------------------------------*/
cpl_image* sph_unsharp_mask( const cpl_image* inimage, cpl_size winsize) {
    cpl_image* temp = NULL;
    cpl_image* result = NULL;
    const cpl_size nx = cpl_image_get_size_x(inimage);
    const cpl_size ny = cpl_image_get_size_y(inimage);

    cpl_ensure(inimage != NULL, CPL_ERROR_NULL_INPUT,    NULL);
    cpl_ensure(winsize >= 0,    CPL_ERROR_ILLEGAL_INPUT, NULL);

    temp = cpl_image_duplicate(inimage);
    for (cpl_size xx = 0; xx < nx ; ++xx) {
        for (cpl_size yy = 0; yy < ny; ++yy) {
            const cpl_size llx = CPL_MAX(xx - winsize, 0);
            const cpl_size lly = CPL_MAX(yy - winsize, 0);
            const cpl_size urx = CPL_MIN(xx + winsize, nx - 1);
            const cpl_size ury = CPL_MIN(yy + winsize, ny - 1);
            const double median =
                cpl_image_get_median_window(inimage,
                                            llx + 1, lly + 1,
                                            urx + 1, ury + 1);
            if ( cpl_error_get_code() == CPL_ERROR_ILLEGAL_INPUT ||
                 cpl_error_get_code() == CPL_ERROR_DATA_NOT_FOUND ) {
                cpl_error_reset();
                cpl_image_reject(temp, xx + 1, yy + 1);
            }
            else {
                cpl_image_set(temp, xx + 1, yy + 1, median);
            }
        }
    }
    result = cpl_image_subtract_create( inimage, temp );
    cpl_image_delete(temp); temp = NULL;
    return result;
}
