/* $Id: $
 * This file is part of the SPHERE Pipeline
 * Copyright (C) 2007-2010 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 * $Author: $
 * $Date: $
 * $Revision: $
 * $Name: $
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
/*-----------------------------------------------------------------------------
 Includes
 -----------------------------------------------------------------------------*/
#include <cpl.h>
#include "sph_error.h"

#ifndef SPH_ZPL_DETECTOR_TIME_MODEL_H_
#define SPH_ZPL_DETECTOR_TIME_MODEL_H_

extern const double SPH_ZPL_DETECTOR_TIME_MODEL_START_TIME_DELAY_STD_IMAGING;
extern const double SPH_ZPL_DETECTOR_TIME_MODEL_DIT_GAP_STD_IMAGING;

extern const double SPH_ZPL_DETECTOR_TIME_MODEL_START_TIME_DELAY_FAST_POL;
extern const double SPH_ZPL_DETECTOR_TIME_MODEL_DIT_GAP_FAST_POL;

extern const double SPH_ZPL_DETECTOR_TIME_MODEL_START_TIME_DELAY_SLOW_POL;
extern const double SPH_ZPL_DETECTOR_TIME_MODEL_DIT_GAP_SLOW_POL;

extern const int SPH_ZPL_DETECTOR_MODE_ID_FASTPOL;
extern const int SPH_ZPL_DETECTOR_MODE_ID_WIN;
extern const int SPH_ZPL_DETECTOR_MODE_ID_SLOWPOL;
extern const int SPH_ZPL_DETECTOR_MODE_ID_STDIMG;



typedef struct _sph_zpl_detector_time_model {
    double start_time_delay;         /* start time overhead in sec */
    double dit_gap;                  /* gap between dit in sec (called DELTAT in the HM document) */
    int    detmod_id;                /* detector read out mode id curid,  "ESO DET READ CURID" */
    cpl_boolean days;                /* true if time in days (otherwise in sec) */
} sph_zpl_detector_time_model;

sph_zpl_detector_time_model* sph_zpl_detector_time_model_new_days(const int detmode_id)   CPL_ATTR_ALLOC;
sph_zpl_detector_time_model* sph_zpl_detector_time_model_new(const int detmode_id, cpl_boolean set_days)   CPL_ATTR_ALLOC;
sph_zpl_detector_time_model* sph_zpl_detector_time_model_new_fastpol(void)   CPL_ATTR_ALLOC;
sph_zpl_detector_time_model* sph_zpl_detector_time_model_new_slowpol(void)   CPL_ATTR_ALLOC;
sph_zpl_detector_time_model* sph_zpl_detector_time_model_new_stdimg(void)   CPL_ATTR_ALLOC;
sph_error_code sph_zpl_detector_time_model_set_days( sph_zpl_detector_time_model* self );
sph_error_code sph_zpl_detector_time_model_delete( sph_zpl_detector_time_model* self );




#endif /* SPH_ZPL_DETECTOR_TIME_MODEL_H_ */
