#include "sph_zpl_science_pol_product.h"

sph_zpl_science_pol_product *
sph_zpl_science_pol_product_create(sph_master_frame* mf_odd, sph_master_frame* mf_even){

	sph_double_image * img = sph_double_image_new_from_master_frames(mf_odd, mf_even);

	if(img == NULL){
        sph_error_raise(CPL_ERROR_NULL_INPUT, __FILE__, __func__, __LINE__,
                SPH_ERROR_ERROR, "Null image.");
        return NULL;
    }

	sph_zpl_science_pol_product  * to_ret = cpl_calloc(1, sizeof(*to_ret));
	to_ret->image = img;
	to_ret->header = NULL;
	to_ret->inherit_frame = NULL;
	return to_ret;
}

sph_error_code sph_zpl_science_pol_product_delete(
		sph_zpl_science_pol_product * prod){

	if(prod == NULL) return cpl_error_get_code();

	sph_double_image_delete(prod->image);
	cpl_propertylist_delete(prod->header);
	cpl_frame_delete(prod->inherit_frame);
	cpl_free(prod->tag);
	cpl_free(prod->out_filename);
	cpl_free(prod);
	return cpl_error_get_code();
}

static inline
char *  safe_strdup(const char * s){
	if(s == NULL) return NULL;
	return cpl_strdup(s);
}

sph_zpl_science_pol_product * sph_zpl_science_pol_product_duplicate(sph_zpl_science_pol_product * p){

    if (p == NULL || p->image == NULL || p->tag == NULL || p->out_filename == NULL) {
        sph_error_raise(CPL_ERROR_NULL_INPUT, __FILE__, __func__, __LINE__,
                SPH_ERROR_ERROR, "Null input pointer.");
        return NULL;
    }

	sph_zpl_science_pol_product  * to_ret = cpl_calloc(1, sizeof(*to_ret));
	to_ret->image = sph_double_image_duplicate(p->image);
	to_ret->tag = safe_strdup(p->tag);
	to_ret->out_filename = safe_strdup(p->out_filename);
	to_ret->header = p->header ? cpl_propertylist_duplicate(p->header) : NULL;
	to_ret->inherit_frame = p->inherit_frame ? cpl_frame_duplicate(p->inherit_frame) : NULL;
	return to_ret;
}

void sph_zpl_science_pol_product_set_tag(sph_zpl_science_pol_product * p, const char * s){
	if(p == NULL) return;

	cpl_free(p->tag);
	p->tag = safe_strdup(s);
}

void sph_zpl_science_pol_product_set_filename(sph_zpl_science_pol_product * p, const char * s){
	if(p == NULL) return;

	cpl_free(p->out_filename);
	p->out_filename = safe_strdup(s);
}


void sph_zpl_science_pol_product_set_inherit_frame(sph_zpl_science_pol_product * p, const cpl_frame * frame){
	if(p == NULL) return;

	cpl_frame_delete(p->inherit_frame);
	p->inherit_frame = NULL;
	if(frame == NULL) return;

	p->inherit_frame = cpl_frame_duplicate(frame);
}

void sph_zpl_science_pol_product_wrap_header(sph_zpl_science_pol_product * p, cpl_propertylist * header){
	if(p == NULL) return;

	cpl_propertylist_delete(p->header);
	p->header = header;
}

