/*
 * sph_test_pupilimage_creator.h
 *
 *  Created on: Jan 15, 2010
 *      Author: test
 */

#ifndef SPH_TEST_PUPILIMAGE_CREATOR_H_
#define SPH_TEST_PUPILIMAGE_CREATOR_H_
#include "sph_error.h"
#include <cpl.h>
#include <gsl/gsl_rng.h>
#define SPH_TEST_PUPILIMAGE_TAG "PUPILIMAGE"
#define SPH_TEST_PUPILIMAGE_KEYWORD_POSANG0 "ESO POS ANG ZERO"
#define SPH_TEST_PUPILIMAGE_KEYWORD_POSANG "ESO DRS PC POSANG"

typedef struct _sph_test_pupilimage_creator_ {
    cpl_frameset* frameset;
    int nx; // pixel size of images to create
    int ny; // pixel size of images to create
    short coronagraph_in; // flag to set if coronagraph is in
    cpl_image* coronagraph; // image placeholder for coronagraph image
    cpl_image* base_image;
} sph_test_pupilimage_creator;

sph_test_pupilimage_creator*
sph_test_pupilimage_creator_new(void)
    CPL_ATTR_ALLOC;

sph_error_code
sph_test_pupilimage_creator_create_frames(sph_test_pupilimage_creator* self,
        int nframes);

void sph_test_pupilimage_creator_set_image(sph_test_pupilimage_creator* self,
        cpl_image* im);
cpl_frameset* sph_test_pupilimage_creator_get_frameset(
        sph_test_pupilimage_creator* self);

void
sph_test_pupilimage_creator_create_const_image(
        sph_test_pupilimage_creator* self, double value, int nframes);

void
sph_test_pupilimage_creator_add_speckles(sph_test_pupilimage_creator* self,
        int nspeckles, double value, gsl_rng* pRNG);

void
sph_test_pupilimage_creator_create_binary_star_frames(
        sph_test_pupilimage_creator* self, double dist, double angle0,
        double dangle, double counts, double contrast, double psf_size,
        int nframes);

cpl_frame* sph_test_pupilimage_creator_get_first_frame(
        sph_test_pupilimage_creator* self);

int sph_test_pupilimage_creator_get_nx(sph_test_pupilimage_creator* self);

int sph_test_pupilimage_creator_get_ny(sph_test_pupilimage_creator* self);

void sph_test_pupilimage_creator_set_size(sph_test_pupilimage_creator* self,
        int nx, int ny);
cpl_image*
sph_test_pupilimage_creator_create_binary_star_image(
        sph_test_pupilimage_creator* self, double dist, double angle,
        double counts, double contrast, double psf_size);

void
sph_test_pupilimage_creator_delete(sph_test_pupilimage_creator* self);

#endif /* SPH_TEST_PUPILIMAGE_CREATOR_H_ */
