/* $Id: $
 * This file is part of the SPHERE Pipeline
 * Copyright (C) 2007-2010 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 * $Author: $
 * $Date: $
 * $Revision: $
 * $Name: $
 */

/*-----------------------------------------------------------------------------
 Includes
 -----------------------------------------------------------------------------*/
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "sph_zpl_exposure.h"
#include "sph_zpl_exposure_imaging.h"
#include "sph_double_image.h"
#include "sph_triple_image.h"
#include "sph_quad_image.h"
#include "sph_master_frame.h"
#include "sph_error.h"
#include <cpl.h>

#ifndef SPH_TEST_ZPL_SIMULATOR_H_
#define SPH_TEST_ZPL_SIMULATOR_H_

/*-----------------------------------------------------------------------------
 Static variables
 -----------------------------------------------------------------------------*/
#define ZERO_ODD_DOUBLE		100.0
#define ZERO_EVEN_DOUBLE	200.0
#define PI_ODD_DOUBLE		300.0
#define PI_EVEN_DOUBLE		400.0

sph_zpl_exposure*
sph_test_zpl_simulator_create_exposure(int nx, int ny)
    CPL_ATTR_ALLOC;

cpl_propertylist*
sph_test_zpl_simulator_create_ovsc_propertylist(double* ovsc)
    CPL_ATTR_ALLOC;

cpl_propertylist*
sph_test_zpl_simulator_create_ovsc_propertylist_imaging(double* ovsc)
    CPL_ATTR_ALLOC;

sph_zpl_exposure_imaging*
sph_test_zpl_simulator_create_exposure_imaging(int nx, int ny)
    CPL_ATTR_ALLOC;

sph_zpl_exposure*
sph_test_zpl_simulator_create_exposure_4flat_double(int nx, int ny,
        double zero_odd, double zero_even, double pi_odd, double pi_even)
    CPL_ATTR_ALLOC;

sph_zpl_exposure_imaging*
sph_test_zpl_simulator_create_exposure_imaging_2flat_double(int nx, int ny,
        double image_odd, double image_even)
    CPL_ATTR_ALLOC;

sph_zpl_exposure*
sph_test_zpl_simulator_create_exposure_4flat_int(int nx, int ny, int zero_odd,
        int zero_even, int pi_odd, int pi_even)
    CPL_ATTR_ALLOC;

cpl_frame*
sph_test_zpl_simulator_create_exposure_cube_frame(int nx, int ny, int nz,
        const char* filename)
    CPL_ATTR_ALLOC;

cpl_frame*
sph_test_zpl_simulator_create_exposure_imaging_cube_frame(int nx, int ny,
        int nz, const char* filename)
    CPL_ATTR_ALLOC;

cpl_frame*
sph_test_zpl_simulator_create_exposure_cube_frame_4flat_double(int nx, int ny,
        int nz, const char* filename, double zero_odd, double zero_even,
        double pi_odd, double p_even)
    CPL_ATTR_ALLOC;

cpl_frame*
sph_test_zpl_simulator_create_exposure_imaging_cube_frame_2flat_double(int nx,
        int ny, int nz, const char* filename, double imaging_odd,
        double imaging_even)
    CPL_ATTR_ALLOC;

sph_error_code
sph_test_zpl_simulator_create_cube_from_exposure_frames_double(
        cpl_frameset* zexpframes, cpl_frame* zexpcube);

sph_error_code sph_test_zpl_simulator_create_cube_from_exposure_imaging_frames_double(
        cpl_frameset* zexpframes, cpl_frame* zexpcube);

sph_error_code
sph_test_zpl_simulator_create_cube_from_exposure_frames_int(
        cpl_frameset* zexpframes, cpl_frame* zexpcube);

cpl_frame* sph_test_zpl_simulator_frame_template(const char *filename)
    CPL_ATTR_ALLOC;

cpl_frame* sph_test_simulator_create_zpl_exposure_overscans_cube(int nx, int ny,
        int nz, const char* filename, double zero_odd, double zero_even,
        double pi_odd, double pi_even, double* ovsc, double dV, double dOVSC)
    CPL_ATTR_ALLOC;

cpl_frame* sph_test_simulator_create_zpl_exposure_overscans_cube_set_hwpz(
        int nx, int ny, int nz, const char* filename, double zero_odd,
        double zero_even, double pi_odd, double pi_even, double* ovsc,
        double dV, double dOVSC, double hwp2)
    CPL_ATTR_ALLOC;

cpl_frame* sph_test_simulator_create_zpl_exposure_imaging_overscans_cube(int nx,
        int ny, int nz, const char* filename, double iframe, double pframe,
        double* ovsc, double dV, double dOVSC)
    CPL_ATTR_ALLOC;

void sph_test_simulator_create_zplpreproc_cube_minus(cpl_frame** zexpcube,
        int nframes);
void sph_test_simulator_create_zplpreproc_cube_plus(cpl_frame** zexpcube,
        int nframes);
void sph_test_simulator_create_zplpreproc_frames(cpl_frameset** zexpframes,
        int nframes);
cpl_frameset* sph_test_simulator_create_quad_image_frames_from_zplexp_frames(void)
    CPL_ATTR_ALLOC;
cpl_frameset* sph_test_simulator_create_quad_image_frames_from_zplexp_cubes(void)
    CPL_ATTR_ALLOC;

sph_double_image*
sph_test_zpl_simulator_create_double_image(int nx, int ny, double iframe_value,
        double pframe_value)
    CPL_ATTR_ALLOC;

cpl_frame*
sph_test_zpl_simulator_create_double_image_frame(const char* filename, int nx,
        int ny, double val1, double val2)
    CPL_ATTR_ALLOC;

void sph_test_simulator_create_zplpreproc_cube_set(cpl_frame** zexpcube,
        double zero_odd, double zero_even, double pi_odd, double pi_even,
        double dV, int nframes);

void sph_test_simulator_create_zplpreproc_cube_set_iff(cpl_frame** zexpcube,
        double zero_odd, double zero_even, double pi_odd, double pi_even,
        double dV, int nframes);

void sph_test_simulator_create_zplpreproc_cube_set_filename(
        cpl_frame** zexpcube, const char* filename, double zero_odd,
        double zero_even, double pi_odd, double pi_even, double dV, int nframes);

void sph_test_simulator_create_zplpreproc_cube_set_hwpz(cpl_frame** zexpcube,
        const char* filename, double zero_odd, double zero_even, double pi_odd,
        double pi_even, double dV, double hwp2, int nframes);

void sph_test_simulator_create_zplpreproc_cube_set_hwp2(cpl_frame** zexpcube,
        const char* filename, double zero_odd, double zero_even, double pi_odd,
        double pi_even, double dV, double hwp2, int nframes);

void sph_test_simulator_create_zplpreproc_cube_set_qplus(cpl_frame** zexpcube,
        const char* filename, double zero_odd, double zero_even, double pi_odd,
        double pi_even, double dV, int nframes);

void sph_test_simulator_create_zplpreproc_cube_set_qminus(cpl_frame** zexpcube,
        const char* filename, double zero_odd, double zero_even, double pi_odd,
        double pi_even, double dV, int nframes);

void sph_test_simulator_create_zplpreproc_imaging_cube(cpl_frame** zexpcube,
        int nframes);

void sph_test_simulator_create_zplpreproc_imaging_cube_ra_dec_time(
        cpl_frame** zexpcube, int nframes, float ra, float dec, double mjd_obs,
        const char* date_obs, double utc, double dit, int curid);

void sph_test_simulator_create_zplpreproc_imaging_cube_set(cpl_frame** zexpcube,
        double image_odd, double image_even, double dV, int nframes);

sph_double_image*
sph_test_zpl_simulator_create_double_image_noise_uniform(int nx, int ny,
        double iframe_value, double pframe_value, double sigma_iframe,
        double sigma_pframe)
    CPL_ATTR_ALLOC;

sph_triple_image*
sph_test_zpl_simulator_create_triple_image(int nx, int ny, double val1,
        double val2, double val3)
    CPL_ATTR_ALLOC;

sph_quad_image*
sph_test_zpl_simulator_create_quad_image(int nx, int ny, double val1,
        double val2, double val3, double val4)
    CPL_ATTR_ALLOC;

cpl_frame*
sph_test_zpl_simulator_create_quad_image_frame(const char* filename, int nx,
        int ny, double val1, double val2, double val3, double val4)
    CPL_ATTR_ALLOC;

sph_master_frame*
sph_test_zpl_simulator_create_master_frame(int nx, int ny, double value)
    CPL_ATTR_ALLOC;

cpl_frame*
sph_test_zpl_simulator_create_masterframe_frame(const char* filename, int nx,
        int ny, double val)
    CPL_ATTR_ALLOC;

cpl_frame*
sph_test_simulator_create_fctable(int nx, int ny, double* dx, double* dy,
        double* angle, int nframes)
    CPL_ATTR_ALLOC;

void sph_test_simulator_create_zplpreproc_science_cube(cpl_frame** zexpcube,
        cpl_frame* fctable_frame, int nx, int ny);
void sph_test_simulator_create_zplpreproc_science_cube_overscan(
        cpl_frame** zexpcube, cpl_frame* fctable_frame, int nx, int ny,
        double *ovsc);

void sph_test_simulator_create_zplpreproc_imaging_science_cube(
        cpl_frame** zexpcube, cpl_frame* fctable_frame, int nx, int ny);

cpl_frame*
sph_test_simulator_create_zplpreproc_imaging_science_cube_with_overscan(
        cpl_frame* fctable_frame, int nx, int ny, double *ovsc)
    CPL_ATTR_ALLOC;

#endif /* SPH_TEST_ZPL_SIMULATOR_H_ */
