/* $Id: $
 * This file is part of the SPHERE Pipeline
 * Copyright (C) 2007-2010 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 * $Author: $
 * $Date: $
 * $Revision: $
 * $Name: $
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

/*-----------------------------------------------------------------------------
 Includes
 -----------------------------------------------------------------------------*/
#include <cpl.h>
#include "sph_error.h"
#include "sph_test_ngc_ir_simulator.h"
#include "sph_test_ifs_instrument_model.h"

#ifndef SPH_IFS_TEST_FIXTURES_SCIENCE_RAW_H_
#define SPH_IFS_TEST_FIXTURES_SCIENCE_RAW_H_

cpl_frameset*
sph_ifs_test_fixtures_raw_constant_flux(sph_test_ngc_ir_simulator* ngc,
        sph_test_ifs_instrument_model* insmodel,
        const char* tag);

cpl_frameset*
sph_ifs_test_fixtures_science_raw_standard(sph_test_ngc_ir_simulator* ngc,
        sph_test_ifs_instrument_model* insmodel);

cpl_frameset*
sph_ifs_test_fixtures_science_raw_point_grid(sph_test_ngc_ir_simulator* ngc,
        sph_test_ifs_instrument_model* insmodel);

cpl_frameset*
sph_ifs_test_fixtures_science_raw_constant_flux(sph_test_ngc_ir_simulator* ngc,
        sph_test_ifs_instrument_model* insmodel);
cpl_frameset*
sph_ifs_test_fixtures_science_raw_constant_flux_dispersed(
        sph_test_ngc_ir_simulator* ngc, sph_test_ifs_instrument_model* insmodel,
        double value, int nframes, int nplanes);
#endif /* SPH_IFS_TEST_FIXTURES_SCIENCE_RAW_H_ */
