/* $Id: $\n
 * This file is part of the SPHERE Pipeline
 * Copyright (C) 2007-2010 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
/*
 * $Author: $
 * $Date: $
 * $Revision: $
 * $Name: $

 ********************************************************
 *  
 *  THIS IS A GENERATED FILE
 *  DO NOT MODIFY
 *  To change it, modify the generating code
 *
 ********************************************************
 */
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <cpl.h>
#include "sph_utils.h"
#include "sph_test.h"
#include "sph_error.h"
#include "sph_test_image_tools.h"
#include "sph_test_image_tools.h"
#include "sph_common_keywords.h"
#include "sph_test_ifs_instrument_model.h"
#include "sph_ifs_test_fixtures_science_raw.h"
#include "sph_ifs_test_fixtures_calib_products.h"
#include "sph_ifs_keywords.h"
#include "sph_ifs_tags.h"
#include "sph_ifs_master_detector_flat.h"

static cpl_image* fixture_imcreate_val_1_0(void) {

    cpl_image* image = NULL;
    image = cpl_image_new(256, 256, CPL_TYPE_INT);
    cpl_image_add_scalar(image, 1.0);
    sph_test_image_tools_add_noise(image, 0.1, NULL);
    return image;
}

static cpl_frameset* fixture_ifs_detector_flat_field_raw(void) {

    cpl_frameset* result = NULL;
    cpl_frame* dumframe = NULL;
    cpl_image* image = NULL;
    cpl_propertylist* pl = NULL;
    int ff = 0;
    int pp = 0;

    result = cpl_frameset_new();
    for (ff = 0; ff < 1; ++ff) {
        dumframe = sph_filemanager_create_temp_frame("TEST_FIXTURE",
                "IFS_DETECTOR_FLAT_FIELD_RAW", CPL_FRAME_GROUP_RAW);
        for (pp = 0; pp < 5; ++pp) {
            image = fixture_imcreate_val_1_0();
            sph_cube_append_image(cpl_frame_get_filename(dumframe), image, pl,
                    0);
            cpl_image_delete(image);
            image = NULL;
        }
        sph_cube_finalise_file(cpl_frame_get_filename(dumframe));
        cpl_frameset_insert(result, dumframe);
    }
    cpl_propertylist_delete(pl);
    pl = NULL;
    return result;
}

static cpl_image* fixture_imcreate_val_2_0(void) {

    cpl_image* image = NULL;
    image = cpl_image_new(256, 256, CPL_TYPE_INT);
    cpl_image_add_scalar(image, 2.0);
    sph_test_image_tools_add_noise(image, 0.1, NULL);
    return image;
}

static cpl_frameset* fixture_ifs_detector_flat_field_raw_0(void) {

    cpl_frameset* result = NULL;
    cpl_frame* dumframe = NULL;
    cpl_image* image = NULL;
    cpl_propertylist* pl = NULL;
    int ff = 0;
    int pp = 0;

    result = cpl_frameset_new();
    for (ff = 0; ff < 1; ++ff) {
        dumframe = sph_filemanager_create_temp_frame("TEST_FIXTURE",
                "IFS_DETECTOR_FLAT_FIELD_RAW", CPL_FRAME_GROUP_RAW);
        for (pp = 0; pp < 5; ++pp) {
            image = fixture_imcreate_val_2_0();
            sph_cube_append_image(cpl_frame_get_filename(dumframe), image, pl,
                    0);
            cpl_image_delete(image);
            image = NULL;
        }
        sph_cube_finalise_file(cpl_frame_get_filename(dumframe));
        cpl_frameset_insert(result, dumframe);
    }
    cpl_propertylist_delete(pl);
    pl = NULL;
    return result;
}

static cpl_image* fixture_imcreate_val_3_0(void) {

    cpl_image* image = NULL;
    image = cpl_image_new(256, 256, CPL_TYPE_INT);
    cpl_image_add_scalar(image, 3.0);
    sph_test_image_tools_add_noise(image, 0.1, NULL);
    return image;
}

static cpl_frameset* fixture_ifs_detector_flat_field_raw_1(void) {

    cpl_frameset* result = NULL;
    cpl_frame* dumframe = NULL;
    cpl_image* image = NULL;
    cpl_propertylist* pl = NULL;
    int ff = 0;
    int pp = 0;

    result = cpl_frameset_new();
    for (ff = 0; ff < 1; ++ff) {
        dumframe = sph_filemanager_create_temp_frame("TEST_FIXTURE",
                "IFS_DETECTOR_FLAT_FIELD_RAW", CPL_FRAME_GROUP_RAW);
        for (pp = 0; pp < 5; ++pp) {
            image = fixture_imcreate_val_3_0();
            sph_cube_append_image(cpl_frame_get_filename(dumframe), image, pl,
                    0);
            cpl_image_delete(image);
            image = NULL;
        }
        sph_cube_finalise_file(cpl_frame_get_filename(dumframe));
        cpl_frameset_insert(result, dumframe);
    }
    cpl_propertylist_delete(pl);
    pl = NULL;
    return result;
}

static cpl_image* fixture_imcreate_val_4_0(void) {

    cpl_image* image = NULL;
    image = cpl_image_new(256, 256, CPL_TYPE_INT);
    cpl_image_add_scalar(image, 4.0);
    sph_test_image_tools_add_noise(image, 0.1, NULL);
    return image;
}

static cpl_frameset* fixture_ifs_detector_flat_field_raw_2(void) {

    cpl_frameset* result = NULL;
    cpl_frame* dumframe = NULL;
    cpl_image* image = NULL;
    cpl_propertylist* pl = NULL;
    int ff = 0;
    int pp = 0;

    result = cpl_frameset_new();
    for (ff = 0; ff < 1; ++ff) {
        dumframe = sph_filemanager_create_temp_frame("TEST_FIXTURE",
                "IFS_DETECTOR_FLAT_FIELD_RAW", CPL_FRAME_GROUP_RAW);
        for (pp = 0; pp < 5; ++pp) {
            image = fixture_imcreate_val_4_0();
            sph_cube_append_image(cpl_frame_get_filename(dumframe), image, pl,
                    0);
            cpl_image_delete(image);
            image = NULL;
        }
        sph_cube_finalise_file(cpl_frame_get_filename(dumframe));
        cpl_frameset_insert(result, dumframe);
    }
    cpl_propertylist_delete(pl);
    pl = NULL;
    return result;
}

static
int cutest_init_sph_ifs_master_detector_flat_testsuite(void) {
    sph_test_nop_code();
    return 0;
}
static
int cutest_clean_sph_ifs_master_detector_flat_testsuite(void) {
    sph_error_dump(SPH_ERROR_ERROR);
    return sph_end_test();
}
static
void cutest_sph_ifs_master_detector_flat(void) {

    sph_ifs_master_detector_flat* rec = NULL;
    cpl_frameset* inframeset = NULL;
    cpl_frameset* tmpset = NULL;
    cpl_parameterlist* inparams = NULL;
    sph_error_code rerr = 0;

    inframeset = cpl_frameset_new();

    tmpset = fixture_ifs_detector_flat_field_raw();
    cpl_frameset_join(inframeset, tmpset);
    cpl_frameset_delete(tmpset);
    tmpset = NULL;
    tmpset = fixture_ifs_detector_flat_field_raw_0();
    cpl_frameset_join(inframeset, tmpset);
    cpl_frameset_delete(tmpset);
    tmpset = NULL;
    tmpset = fixture_ifs_detector_flat_field_raw_1();
    cpl_frameset_join(inframeset, tmpset);
    cpl_frameset_delete(tmpset);
    tmpset = NULL;
    tmpset = fixture_ifs_detector_flat_field_raw_2();
    cpl_frameset_join(inframeset, tmpset);
    cpl_frameset_delete(tmpset);
    tmpset = NULL;
    inparams = sph_ifs_master_detector_flat_create_paramlist();
    rec = sph_ifs_master_detector_flat_new(inframeset, inparams);
    rerr = sph_ifs_master_detector_flat_run(rec);
    cpl_test_eq_error(rerr, CPL_ERROR_NONE);
    cpl_frameset_delete(inframeset);
    inframeset = NULL;
    cpl_parameterlist_delete(inparams);
    inparams = NULL;
    sph_ifs_master_detector_flat_delete(rec);
    rec = NULL;
    cpl_test_eq_error(rerr, CPL_ERROR_NONE);
}
/*----------------------------------------------------------------------------*/
/**
 @brief    Unit tests of sph_ifs_master_detector_flat
 */
/*----------------------------------------------------------------------------*/
int main(void) {
    int result = 0;

    const void* pSuite = NULL;


    if ( 0 != sph_test_init())
        return sph_test_get_error();


    pSuite = sph_add_suite("sph_ifs_master_detector_flat_suite",
            cutest_init_sph_ifs_master_detector_flat_testsuite,
            cutest_clean_sph_ifs_master_detector_flat_testsuite);
    if (NULL == pSuite) {
        return sph_test_get_error();
    }


    if (NULL
            == sph_test_do(pSuite, "sph_ifs_master_detector_flat",
                    cutest_sph_ifs_master_detector_flat)) {
        return sph_test_get_error();
    }
    /* Run all tests using the CUnit Basic interface */
    sph_test_nop_int( 0);
    sph_test_nop_char("results.txt");
    result = sph_test_end();
    return result;
}
