/* $Id: $\n
 * This file is part of the SPHERE Pipeline
 * Copyright (C) 2007-2010 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
/*
 * $Author: $
 * $Date: $
 * $Revision: $
 * $Name: $

 ********************************************************
 *  
 *  THIS IS A GENERATED FILE
 *  DO NOT MODIFY
 *  To change it, modify the generating code
 *
 ********************************************************
 */
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <cpl.h>
#include "sph_utils.h"
#include "sph_test.h"
#include "sph_error.h"
#include "sph_test_image_tools.h"
#include "sph_test_image_tools.h"
#include "sph_common_keywords.h"
#include "sph_test_ifs_instrument_model.h"
#include "sph_ifs_test_fixtures_science_raw.h"
#include "sph_ifs_test_fixtures_calib_products.h"
#include "sph_ifs_keywords.h"
#include "sph_ifs_tags.h"
#include "sph_ifs_spectra_positions.h"

static cpl_frameset* fixture_ifs_specpos_raw(void) {

    cpl_frameset* result = NULL;
    sph_test_ifs_instrument_model* ifsmodel = NULL;
    sph_test_ngc_ir_simulator* ngc = NULL;

    ngc = sph_test_ngc_ir_simulator_new(64, 64);
    ifsmodel = sph_test_ifs_instrument_model_new(ngc->det_size_x,
            SPH_IFS_LENSLET_MODEL_LENSLET_SIZE_MICRONS, 3);
    result = sph_ifs_test_fixtures_science_raw_constant_flux_dispersed(ngc,
            ifsmodel, 10000.0, 1, 1);
    sph_test_retag_frames_by_group(result, CPL_FRAME_GROUP_RAW,
            "IFS_SPECPOS_RAW");
    sph_test_ngc_ir_simulator_delete(ngc);
    sph_test_ifs_instrument_model_delete(ifsmodel);
    return result;
}

static cpl_frameset* fixture_ifs_specpos_raw_badwidth(void) {

    cpl_frameset* result = NULL;
    sph_test_ifs_instrument_model* ifsmodel = NULL;
    sph_test_ngc_ir_simulator* ngc = NULL;

    ngc = sph_test_ngc_ir_simulator_new(64, 64);
    ifsmodel = sph_test_ifs_instrument_model_new(ngc->det_size_x,
            SPH_IFS_LENSLET_MODEL_LENSLET_SIZE_MICRONS, 3);
    ifsmodel->lensmodel->specwidth_pixels *= 0.8;
    ifsmodel->lensmodel->specwidth_microns *= 0.8;
    ifsmodel->lensmodel->lensize_microns *= 0.8;
    ifsmodel->lensmodel->speclength_pixels *= 0.8;
    ifsmodel->lensmodel->speclength_microns *= 0.8;
    result = sph_ifs_test_fixtures_science_raw_constant_flux_dispersed(ngc,
            ifsmodel, 10000.0, 1, 1);
    sph_test_retag_frames_by_group(result, CPL_FRAME_GROUP_RAW,
            "IFS_SPECPOS_RAW");
    sph_test_ngc_ir_simulator_delete(ngc);
    sph_test_ifs_instrument_model_delete(ifsmodel);
    return result;
}

static cpl_frameset* fixture_ifs_lenslet_model(void) {

    cpl_frameset* result = NULL;
    cpl_frame* aframe = NULL;
    sph_ifs_lenslet_model* model = NULL;

    result = cpl_frameset_new();
    model = sph_ifs_lenslet_model_new();
    model->detsize_pixels = 64;
    model->detsize_microns = 64 * SPH_IFS_LENSLET_MODEL_PIX_SIZE_MICRONS;
    model->lensize_microns = SPH_IFS_LENSLET_MODEL_LENSLET_SIZE_MICRONS;
    model->lenslets_per_side = 3;
    aframe = sph_filemanager_create_temp_frame("TEST", "IFS_LENSLET_MODEL",
            CPL_FRAME_GROUP_CALIB);
    sph_ifs_lenslet_model_save(model, cpl_frame_get_filename(aframe));
    cpl_frameset_insert(result, aframe);
    sph_ifs_lenslet_model_delete(model);
    model = NULL;
    return result;
}

static
int cutest_init_sph_ifs_spectra_positions_testsuite(void) {
    sph_test_nop_code();
    return 0;
}
static
int cutest_clean_sph_ifs_spectra_positions_testsuite(void) {
    sph_error_dump(SPH_ERROR_ERROR);
    return sph_end_test();
}
static
void cutest_sph_ifs_spectra_positions(void) {

    sph_ifs_spectra_positions* rec = NULL;
    cpl_frameset* inframeset = NULL;
    cpl_frameset* tmpset = NULL;
    cpl_parameterlist* inparams = NULL;
    cpl_propertylist* plist = NULL;
    sph_error_code rerr = 0;

    inframeset = cpl_frameset_new();

    tmpset = fixture_ifs_specpos_raw();
    cpl_frameset_join(inframeset, tmpset);
    cpl_frameset_delete(tmpset);
    tmpset = NULL;
    tmpset = fixture_ifs_lenslet_model();
    cpl_frameset_join(inframeset, tmpset);
    cpl_frameset_delete(tmpset);
    tmpset = NULL;
    inparams = sph_ifs_spectra_positions_create_paramlist();
    rec = sph_ifs_spectra_positions_new(inframeset, inparams);
    rerr = sph_ifs_spectra_positions_run(rec);
    cpl_test_eq_error(rerr, CPL_ERROR_NONE);
    cpl_frameset_delete(inframeset);
    inframeset = NULL;
    cpl_parameterlist_delete(inparams);
    inparams = NULL;
    sph_ifs_spectra_positions_delete(rec);
    rec = NULL;
    cpl_test_eq_error(rerr, CPL_ERROR_NONE);
    cpl_test_error(CPL_ERROR_NONE);
    plist = cpl_propertylist_load("spectra_positions.fits", 0);
    cpl_test(
            cpl_propertylist_has(plist,SPH_IFS_KEYWORD_DISTMAP_POLFIT_CHIX));
    cpl_test(
            cpl_propertylist_has(plist,SPH_IFS_KEYWORD_DISTMAP_POLFIT_CHIY));
    cpl_propertylist_delete(plist);
    plist = NULL;
}

static
void cutest_sph_ifs_spectra_positions_err_on_badwidth(void) {

    sph_ifs_spectra_positions* rec = NULL;
    cpl_frameset* inframeset = NULL;
    cpl_frameset* tmpset = NULL;
    cpl_parameterlist* inparams = NULL;
    sph_error_code rerr = 0;

    cpl_error_reset();
    inframeset = cpl_frameset_new();

    tmpset = fixture_ifs_specpos_raw_badwidth();
    cpl_frameset_join(inframeset, tmpset);
    cpl_frameset_delete(tmpset);
    tmpset = NULL;
    tmpset = fixture_ifs_lenslet_model();
    cpl_frameset_join(inframeset, tmpset);
    cpl_frameset_delete(tmpset);
    tmpset = NULL;
    inparams = sph_ifs_spectra_positions_create_paramlist();
    rec = sph_ifs_spectra_positions_new(inframeset, inparams);
    cpl_test_nonnull( rec );
    rerr = sph_ifs_spectra_positions_run(rec);
    cpl_test_eq_error(rerr, CPL_ERROR_ILLEGAL_INPUT);
    cpl_frameset_delete(inframeset);
    inframeset = NULL;
    cpl_parameterlist_delete(inparams);
    inparams = NULL;
    sph_ifs_spectra_positions_delete(rec);
    rec = NULL;
    cpl_error_reset();
}

/*----------------------------------------------------------------------------*/
/**
 @brief    Unit tests of sph_ifs_spectra_positions
 */
/*----------------------------------------------------------------------------*/
int main(void) {
    int result = 0;

    const void* pSuite = NULL;


    if ( 0 != sph_test_init())
        return sph_test_get_error();


    pSuite = sph_add_suite("sph_ifs_spectra_positions_suite",
            cutest_init_sph_ifs_spectra_positions_testsuite,
            cutest_clean_sph_ifs_spectra_positions_testsuite);
    if (NULL == pSuite) {
        return sph_test_get_error();
    }


    if (NULL
            == sph_test_do(pSuite, "sph_ifs_spectra_positions",
                    cutest_sph_ifs_spectra_positions)) {
        return sph_test_get_error();
    }

    if (NULL
            == sph_test_do(pSuite, "sph_ifs_spectra_positions_err_on_bad_width",
                    cutest_sph_ifs_spectra_positions_err_on_badwidth)) {
        return sph_test_get_error();
    }
    /* Run all tests using the CUnit Basic interface */
    sph_test_nop_int( 0);
    sph_test_nop_char("results.txt");
    result = sph_test_end();
    return result;
}
