/* $Id: $
 * This file is part of the SPHERE Pipeline
 * Copyright (C) 2007-2010 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 * $Author: $
 * $Date: $
 * $Revision: $
 * $Name: $
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

/*-----------------------------------------------------------------------------
 Includes
 -----------------------------------------------------------------------------*/
#include <cpl.h>
#include "sph_error.h"
#include "sph_ird_instrument_model.h"
#ifndef SPH_TEST_IRD_FIXTURES_H_
#define SPH_TEST_IRD_FIXTURES_H_

cpl_frame*
sph_test_ird_fixtures_create_corresponding_fc_frame(cpl_frame* input_cube_frame,
        int txtflag);

cpl_frame*
sph_test_ird_fixtures_create_dark(sph_ird_instrument_model* model, double val,
        double rms);

cpl_frame*
sph_test_ird_fixtures_create_flat(sph_ird_instrument_model* model, double rms);

cpl_frame*
sph_test_ird_fixtures_instrument_model_frame(int nx, int ny);

cpl_frame*
sph_test_ird_fixtures_create_science_frame_stable_fc(int np,
        sph_ird_instrument_model* model, double fc_offset_x, double fc_offset_y,
        cpl_frame* actual_dark, cpl_frame* actual_flat,
        cpl_frame* actual_distortion);

/*
 void
 sph_test_ird_fixtures_create_centre_vectors_single_frame(
 cpl_frame* aframe,
 sph_ird_instrument_model* model,
 cpl_vector** cent_lx,
 cpl_vector** cent_ly,
 cpl_vector** cent_rx,
 cpl_vector** cent_ry);
 */

cpl_frame*
sph_test_ird_fixtures_create_science_frame_stable_fc_rot(int np,
        sph_ird_instrument_model* model, double fc_offset_x, double fc_offset_y,
        cpl_frame* actual_dark, cpl_frame* actual_flat,
        cpl_frame* actual_distortion, double angle_offset, double dangle,
        double relscale);

cpl_frameset*
sph_test_ird_fixtures_create_star_centre_frames_ascii_no_dither(int nf, int np,
        sph_ird_instrument_model* model, cpl_frameset* rawframes);

cpl_frameset*
sph_test_ird_fixtures_create_frames(int nf, int np, int nx, int ny,
        cpl_frame* actual_dark, cpl_frame* actual_flat,
        sph_distortion_model* distmap);

cpl_frameset*
sph_test_ird_fixtures_create_science_frames_stable_dither(int nf, int np,
        sph_ird_instrument_model* model, cpl_frame* actual_dark,
        cpl_frame* actual_flat, cpl_frame* acutal_distortion, double* dithx,
        double* dithy);
cpl_frameset*
sph_test_ird_fixtures_create_science_frames_no_dither(int nf, int np,
        sph_ird_instrument_model* model, cpl_frame* actual_dark,
        cpl_frame* actual_flat, cpl_frame* actual_distortion);
sph_ird_instrument_model*
sph_test_ird_fixtures_instrument_model(int nx, int ny);

#endif /* SPH_TEST_IRD_FIXTURES_H_ */
