/* $Id: $
 *
 * This file is part of the SPHERE Pipesph_framecombination
 * Copyright (C) 2007-2010 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 * $Author: $
 * $Date: $
 * $Revision: $
 * $Name: $
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

/*-----------------------------------------------------------------------------
 Includes
 -----------------------------------------------------------------------------*/

#include "sph_framecombination.h"
#include "sph_common_keywords.h"
#include "sph_error.h"
#include "sph_test.h"
#include "sph_utils.h"
#include "sph_test_image_tools.h"
#include <cpl.h>

#include <math.h>
#include <math.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

/*----------------------------------------------------------------------------*/
/**
 * @defgroup techcal_master_test  Unit test of techcal_master recipe and
 *                                  associated functions.
 *
 */
/*----------------------------------------------------------------------------*/

/**@{*/
static
int cutest_init_sph_framecombination_testsuite(void) {
    /*--------------------------------------------------------------------
     * -    Prepare CPL and error logging
     * -------------------------------------------------------------------*/
    sph_test_nop_code();
    return 0;
}

static
int cutest_clean_sph_framecombination_testsuite(void) {
    sph_error_dump(SPH_ERROR_ERROR);
    sph_end_test();
    return 0;
}
/*----------------------------------------------------------------------------*/
/**
 @brief    Unit test for the sph_framecombination_new function.
 */
/*----------------------------------------------------------------------------*/
static
void cutest_sph_framecombination_master_frame_from_frameset(void) {
    cpl_frameset* inframes = NULL;
    cpl_parameterlist* params = NULL;
    int nframes = 3;
    int ii = 0;
    cpl_image* image = NULL;
    sph_master_frame* result = NULL;

    params = cpl_parameterlist_new();
    inframes = cpl_frameset_new();

    cpl_parameterlist_append(
            params,
            cpl_parameter_new_range("clean_mean.reject_high", CPL_TYPE_INT,
                    NULL, NULL, 0, 0, 20));
    cpl_parameterlist_append(
            params,
            cpl_parameter_new_range("clean_mean.reject_low", CPL_TYPE_INT, NULL,
                    NULL, 0, 0, 20));

    for (ii = 0; ii < nframes; ++ii) {
        image = sph_test_image_tools_create_flat_image_double(256, 256, 10.0);
        cpl_frameset_insert(
                inframes,
                sph_test_frame_image(image, CPL_BPP_32_SIGNED, "ATAG",
                        CPL_FRAME_GROUP_RAW));
        cpl_image_delete(image);
    }
    result = sph_framecombination_master_frame_from_frameset(inframes,
            SPH_COLL_ALG_CLEAN_MEAN, params, 0);
    //cpl_test_nonnull( result );
    //cpl_test_abs(cpl_image_get_mean(result->image),10.0,0.00001);
    //printf("Mean=%f\n",cpl_image_get_mean(result->image));
    sph_master_frame_delete(result);
    cpl_parameterlist_delete(params);
    cpl_frameset_delete(inframes);
    sph_filemanager_delete(0);
    return;
}

/*----------------------------------------------------------------------------*/
/**
 @brief    Unit tests of techcal_master_dark recipe and associated functions
 */
/*----------------------------------------------------------------------------*/
int main(void) {

    int result = 0;
    const void* pSuite = NULL;


    if ( 0 != sph_test_init())
        return sph_test_get_error();


    pSuite = sph_add_suite("sph_framecombination_test",
            cutest_init_sph_framecombination_testsuite,
            cutest_clean_sph_framecombination_testsuite);
    if (NULL == pSuite) {
        return sph_test_get_error();
    }


    if (NULL
            == sph_test_do(pSuite,
                    "sph_framecombination_master_frame_from_frameset",
                    cutest_sph_framecombination_master_frame_from_frameset)) {
        return sph_test_get_error();
    }

    /* Run all tests using the CUnit Basic interface */
    sph_test_nop_int( 0);
    sph_test_nop_char("results.txt");
    result = sph_test_end();
    return result;
}

/**@}*/
