from edps import (
    data_source,
    RelativeTimeRange,
    SAME_NIGHT,
    ONE_WEEK,
    TWO_WEEKS,
    THREE_WEEKS,
    ONE_MONTH,
    QUARTERLY,
    IN_THE_PAST,
)

from . import sphere_keywords as kwd
from .ifs_classification import *
from .sphere_rules import TEN_DAYS, TWELVE_DAYS

######################
#     DATA SOURCES   #
######################
# Imaging

ifs_raw_dark = (data_source("IFS_DARK_RAW")
                .with_classification_rule(cls_ifs_dark)
                .with_setup_keywords(rules.setupkwd_ifs_dark)
                .with_grouping_keywords(rules.grpkwd_ifs_dark)
                .with_match_keywords(rules.matchkwd_ifs_dark, time_range=TWO_WEEKS, level=0)
                .with_match_keywords(rules.matchkwd_ifs_dark, time_range=TEN_DAYS, level=1)
                .build())

ifs_raw_ins_bg = (data_source("IFS_INS_BG_RAW")
                  .with_classification_rule(cls_ifs_ins_bg)
                  .with_setup_keywords(rules.setupkwd_ifs_bg)
                  .with_grouping_keywords(rules.grpkwd_ifs_bg)
                  .with_match_keywords(rules.matchkwd_ifs_ins_bg, time_range=RelativeTimeRange(-1.5, 1.5), level=0)
                  .with_match_keywords(rules.matchkwd_ifs_ins_bg, time_range=TEN_DAYS, level=1)
                  .build())

ifs_raw_sky_bg = (data_source("IFS_INS_BG_RAW")
                  .with_classification_rule(cls_ifs_sky_bg)
                  .with_setup_keywords(rules.setupkwd_ifs_bg)
                  .with_grouping_keywords(rules.grpkwd_ifs_bg)
                  .with_match_keywords(rules.matchkwd_ifs_sky_bg, time_range=SAME_NIGHT, level=0)
                  .build())

ifs_raw_flat_RONGain = (data_source("IFS_GAIN_RAW")
                        .with_classification_rule(cls_ifs_flat_RonGain)
                        .with_setup_keywords(rules.setupkwd_ifs_flat_rongain)
                        .with_grouping_keywords(rules.grpkwd_ifs_flat_rongain)
                        .build())

ifs_raw_det_flat_nb1 = (data_source("IFS_DETECTOR_FLAT_FIELD_RAW")
                        .with_classification_rule(cls_ifs_det_flat_nb1)
                        .with_setup_keywords(rules.setupkwd_ifs_flat_dflat)
                        .with_grouping_keywords(rules.grpkwd_ifs_flat_dflat)
                        .with_match_keywords(rules.matchkwd_ifs_ifu_cal, time_range=TWELVE_DAYS, level=0)
                        .with_match_keywords(rules.matchkwd_ifs_ifu_cal, time_range=THREE_WEEKS, level=1)
                        .build())

ifs_raw_det_flat_nb2 = (data_source("IFS_DETECTOR_FLAT_FIELD_RAW")
                        .with_classification_rule(cls_ifs_det_flat_nb2)
                        .with_setup_keywords(rules.setupkwd_ifs_flat_dflat)
                        .with_grouping_keywords(rules.grpkwd_ifs_flat_dflat)
                        .with_match_keywords(rules.matchkwd_ifs_ifu_cal, time_range=TWELVE_DAYS, level=0)
                        .with_match_keywords(rules.matchkwd_ifs_ifu_cal, time_range=THREE_WEEKS, level=1)
                        .build())

ifs_raw_det_flat_nb3 = (data_source("IFS_DETECTOR_FLAT_FIELD_RAW")
                        .with_classification_rule(cls_ifs_det_flat_nb3)
                        .with_setup_keywords(rules.setupkwd_ifs_flat_dflat)
                        .with_grouping_keywords(rules.grpkwd_ifs_flat_dflat)
                        .with_match_keywords(rules.matchkwd_ifs_ifu_cal, time_range=TWELVE_DAYS, level=0)
                        .with_match_keywords(rules.matchkwd_ifs_ifu_cal, time_range=THREE_WEEKS, level=1)
                        .build())

ifs_raw_det_flat_nb4 = (data_source("IFS_DETECTOR_FLAT_FIELD_RAW")
                        .with_classification_rule(cls_ifs_det_flat_nb4)
                        .with_setup_keywords(rules.setupkwd_ifs_flat_dflat)
                        .with_grouping_keywords(rules.grpkwd_ifs_flat_dflat)
                        .with_match_keywords(rules.matchkwd_ifs_ifu_cal, time_range=TWELVE_DAYS, level=0)
                        .with_match_keywords(rules.matchkwd_ifs_ifu_cal, time_range=THREE_WEEKS, level=1)
                        .build())

ifs_raw_det_flat_bb = (data_source("IFS_DETECTOR_FLAT_FIELD_RAW")
                       .with_classification_rule(cls_ifs_det_flat_bb)
                       .with_setup_keywords(rules.setupkwd_ifs_flat_dflat)
                       .with_grouping_keywords(rules.grpkwd_ifs_flat_dflat)
                       .with_match_keywords(rules.matchkwd_ifs_ifu_cal, time_range=TWELVE_DAYS, level=0)
                       .with_match_keywords(rules.matchkwd_ifs_ifu_cal, time_range=THREE_WEEKS, level=1)
                       .build())

ifs_raw_specpos = (data_source("IFS_SPECPOS_RAW")
                   .with_classification_rule(cls_ifs_specpos)
                   .with_setup_keywords(rules.setupkwd_ifs_ifu_cal)
                   .with_grouping_keywords(rules.grpkwd_ifs_ifu_cal)
                   .with_match_keywords(rules.matchkwd_ifs_ifu_cal, time_range=ONE_WEEK, level=0)
                   .with_match_keywords(rules.matchkwd_ifs_ifu_cal, time_range=TWO_WEEKS, level=1)
                   .build())

ifs_raw_wavecalib = (data_source("IFS_WAVECALIB_RAW")
                     .with_classification_rule(cls_ifs_wavecal)
                     .with_setup_keywords(rules.setupkwd_ifs_ifu_cal)
                     .with_grouping_keywords(rules.grpkwd_ifs_ifu_cal)
                     .with_match_keywords(rules.matchkwd_ifs_ifu_cal, time_range=ONE_WEEK, level=0)
                     .with_match_keywords(rules.matchkwd_ifs_ifu_cal, time_range=TWO_WEEKS, level=1)
                     .build())

ifs_raw_ins_flat = (data_source("IFS_FLAT_FIELD_RAW")
                    .with_classification_rule(cls_ifs_ins_flat)
                    .with_setup_keywords(rules.setupkwd_ifs_ifu_cal)
                    .with_grouping_keywords(rules.grpkwd_ifs_ifu_cal)
                    .with_match_keywords(rules.matchkwd_ifs_ifu_cal, time_range=ONE_WEEK, level=0)
                    .with_match_keywords(rules.matchkwd_ifs_ifu_cal, time_range=TWO_WEEKS, level=1)
                    .build())

ifs_raw_distortion = (data_source("IFS_DISTORTION_MAP_RAW")
                      .with_classification_rule(cls_ifs_distortion)
                      .with_setup_keywords(rules.setupkwd_ifs_ifu_cal)
                      .with_grouping_keywords([kwd.arcfile])
                      .with_match_keywords(rules.matchkwd_ifs_ifu_cal, time_range=ONE_WEEK, level=0)
                      .with_match_keywords(rules.matchkwd_ifs_ifu_cal, time_range=TWO_WEEKS, level=1)
                      .build())

ifs_raw_standard_flux = (data_source("IFS_SCIENCE_DR_RAW")
                         .with_classification_rule(cls_ifs_standard_flux)
                         .with_setup_keywords(rules.setupkwd_ifs_ifu_cal)
                         .with_grouping_keywords([kwd.arcfile])
                         .with_match_keywords([kwd.instrume, kwd.ins2_opti2_name], time_range=ONE_MONTH, level=0)
                         .build())

ifs_raw_standard_astrometry = (data_source("IFS_SCIENCE_DR_RAW")
                               .with_classification_rule(cls_ifs_standard_astrometry)
                               .with_setup_keywords(rules.setupkwd_ifs_ifu_cal)
                               .with_grouping_keywords([kwd.arcfile])
                               .with_match_keywords([kwd.instrume, kwd.ins2_opti2_name], time_range=QUARTERLY, level=0)
                               .build())

ifs_raw_science_flux = (data_source("IFS_SCIENCE_DR_RAW")
                        .with_classification_rule(cls_ifs_science_flux)
                        .with_setup_keywords(rules.setupkwd_ifs_science)
                        .with_grouping_keywords([kwd.arcfile])
                        .with_match_keywords(rules.matchkwd_ifs_science_flx_ctr, time_range=SAME_NIGHT, level=0)
                        .build())

ifs_raw_coronagraph_center = (data_source("IFS_SCIENCE_DR_RAW")
                              .with_classification_rule(cls_ifs_coronagraph_center)
                              .with_setup_keywords(rules.setupkwd_ifs_science)
                              .with_grouping_keywords([kwd.arcfile])
                              .with_match_keywords(rules.matchkwd_ifs_science_flx_ctr, time_range=SAME_NIGHT, level=0)
                              .build())

ifs_raw_science_object = (data_source("IFS_SCIENCE_DR_RAW")
                          .with_classification_rule(cls_ifs_science_object)
                          .with_setup_keywords(rules.setupkwd_ifs_science)
                          .with_grouping_keywords([kwd.arcfile])
                          .build())

# static calibrations
ifs_point_pattern_table = (data_source("IFS_POINT_PATTERN")
                           .with_classification_rule(IFS_POINT_PATTERN)
                           .with_match_keywords([kwd.instrume, kwd.seq_arm], time_range=IN_THE_PAST, level=0)
                           .build())
