from edps import classification_rule

from . import irdis_rules as rules

########################
# CLASSIFICATION RULES #
########################
# raw data classification: cls_
# product classification rules have the same names as the PRO.CATG
# static calibration classification: _class
# technical and test data
cls_ird_technical = classification_rule("IRD_TECHNICAL_RAW", rules.is_ird_technical)
cls_ird_test = classification_rule("IRD_TEST_RAW", rules.is_ird_test)
# acquisition
cls_ird_acq_object = classification_rule("IRD_SCIENCE_DBI_RAW", rules.is_ird_acq_object)
cls_ird_acq_dark = classification_rule("IRD_DARK_RAW", rules.is_ird_acq_dark)
cls_ird_acq_flat = classification_rule("IRD_FLAT_FIELD_RAW", rules.is_ird_acq_flat)
# dark
cls_ird_dark = classification_rule("IRD_DARK_RAW", rules.is_ird_dark)
IRD_MASTER_DARK = classification_rule("IRD_MASTER_DARK")
IRD_STATIC_BADPIXELMAP = classification_rule("IRD_STATIC_BADPIXELMAP")
# detector monitoring (no pipeline support)
cls_ird_FlatRongain = classification_rule("IRD_GAIN_RAW", rules.is_ird_flat_rongain)

# instrument background (img, pol, lss)
cls_ird_ins_bg = classification_rule("IRD_INS_BG_RAW", rules.is_ird_ins_bg)
IRD_INS_BG = classification_rule("IRD_INS_BG")
IRD_INS_BG_FIT = classification_rule("IRD_INS_BG_FIT")  # not used because the fit is bad

# sky background (img, pol, lss)
cls_ird_sky_bg = classification_rule("IRD_SKY_BG_RAW", rules.is_ird_sky_bg)
IRD_SKY_BG = classification_rule("IRD_SKY_BG")
# IRD_SKY_BG_FIT = classification_rule("IRD_SKY_BG_FIT") # not used because the fit is bad

# flat field (img, lss)
cls_ird_flat = classification_rule("IRD_FLAT_FIELD_RAW", rules.is_ird_flat)
cls_ird_flat_pol_qc1 = classification_rule("IRD_FLAT_FIELD_RAW", rules.is_ird_flat_pol_qc1)
cls_ird_flat_pol_other = classification_rule("IRD_FLAT_FIELD_RAW", rules.is_ird_flat_pol_other)
IRD_FLAT_FIELD = classification_rule("IRD_FLAT_FIELD")
IRD_NON_LINEAR_PIXELMAP = classification_rule("IRD_NON_LINEAR_PIXELMAP")

cls_ird_distortion = classification_rule("IRD_DISTORTION_MAP_RAW", rules.is_ird_distortion)
IRD_DISTORTION_MAP = classification_rule("IRD_DISTORTION_MAP")

# photometry (img)
cls_ird_standard_flux = classification_rule("IRD_SCIENCE_IMAGING_RAW", rules.is_ird_img_standard_flux)
cls_ird_standard_flux_noprocess = classification_rule("IRD_STANDARD_IMAGING_RAW",
                                                      rules.is_ird_img_standard_flux_noprocess)
IRD_SCIENCE_IMAGING = classification_rule("IRD_SCIENCE_IMAGING")
IRD_SCIENCE_IMAGING_LEFT = classification_rule("IRD_SCIENCE_IMAGING_LEFT")
IRD_SCIENCE_IMAGING_RIGHT = classification_rule("IRD_SCIENCE_IMAGING_RIGHT")

# astrometry (img)
cls_ird_standard_astrometry = classification_rule("IRD_SCIENCE_DBI_RAW", rules.is_ird_img_standard_astrometry)
IRD_SCIENCE_DBI = classification_rule("IRD_SCIENCE_DBI")

# img, pol
cls_ird_img_coronagraph_center = classification_rule("IRD_STAR_CENTER_WAFFLE_RAW", rules.is_ird_img_coronagraph_center)
IRD_STAR_CENTER = classification_rule("IRD_STAR_CENTER")

# science
# img
cls_ird_science_img = classification_rule("IRD_SCIENCE_DBI_RAW", rules.is_ird_science_img)
cls_ird_science_flux_img = classification_rule("IRD_SCIENCE_DBI_RAW", rules.is_ird_science_flux_img)
IRD_SCIENCE_DBI_LEFT = classification_rule("IRD_SCIENCE_DBI_LEFT")
IRD_SCIENCE_DBI_RIGHT = classification_rule("IRD_SCIENCE_DBI_RIGHT")

# pol
cls_ird_science_pol = classification_rule("IRD_SCIENCE_DPI_RAW", rules.is_ird_science_pol)
cls_ird_science_flux_pol = classification_rule("IRD_SCIENCE_DPI_RAW", rules.is_ird_science_flux_pol)
IRD_SCIENCE_DPI = classification_rule("IRD_SCIENCE_DPI")
IRD_SCIENCE_DPI_LEFT = classification_rule("IRD_SCIENCE_DPI_LEFT")
IRD_SCIENCE_DPI_RIGHT = classification_rule("IRD_SCIENCE_DPI_RIGHT")

# lss (wavecal products not used anywhere)
cls_ird_wavecal_lss = classification_rule("IRD_WAVECALIB_RAW", rules.is_ird_wavecal_lss)
IRD_WAVECALIB = classification_rule("IRD_WAVECALIB")
cls_ird_science_lss = classification_rule("IRD_SCIENCE_SPECTROSCOPY_RAW", rules.is_ird_science_lss)

# static calibrations polarimetry / imaging
IRD_POINT_PATTERN = classification_rule("IRD_POINT_PATTERN")
IRD_FILTER_TABLE = classification_rule("IRD_FILTER_TABLE")
IRD_PHOT_STAR_TABLE = classification_rule("IRD_PHOT_STAR_TABLE")
IRD_STATIC_WAFFLEMAP = classification_rule("IRD_STATIC_WAFFLEMAP")

# data with unknown purpose
cls_ird_ncpa_unknown = classification_rule("IRD_NCPA_UNKNOWN", rules.is_ird_ncpa_unknown)
cls_ird_psfcalibrator_unknown = classification_rule("IRD_PSFCALIBRATOR_UNKNOWN", rules.is_ird_psfcalibrator_unknown)
cls_ird_polarimetry_unknown = classification_rule("IRD_POLARIMETRY_UNKNOWN", rules.is_ird_polarimetry_unknown)
cls_ird_unknown = classification_rule("IRD_UNKNOWN", rules.is_ird_unknown)
