# Common classification rules

from edps import RelativeTimeRange

from . import sphere_keywords as kwd

TEN_DAYS = RelativeTimeRange(-10, 10)
TWELVE_DAYS = RelativeTimeRange(-12, 12)


def is_sphere(f):
    return f[kwd.instrume] == "SPHERE"


def is_calib(f):
    return f[kwd.dpr_catg] == "CALIB"


def is_science(f):
    return f[kwd.dpr_catg] == "SCIENCE"


def is_technical(f):
    return f[kwd.dpr_catg] == "TECHNICAL"


def is_test(f):
    return f[kwd.dpr_catg] == "TEST"


# classification rules for IMAGING


def is_img_mode(f):
    return f[kwd.dpr_tech] == "IMAGE"


def is_img_calib(f):
    return is_img_mode(f) and is_calib(f)
