from typing import List

from edps import ClassifiedFitsFile, JobParameters, get_parameter, Job

from . import sphere_keywords as kwd


def which_readout_type(files: List[ClassifiedFitsFile]):
    # Note: files are only the main input files, not the associated files
    return files[0].get_keyword_value(kwd.det_read_curname, None)


def which_exptime(files: List[ClassifiedFitsFile]):
    # Note: files are only the main input files, not the associated files
    return files[0].get_keyword_value(kwd.exptime, None)


def which_disperser(files: List[ClassifiedFitsFile]):
    # Note: files are only the main input files, not the associated files
    return files[0].get_keyword_value(kwd.ins2_opti2_name, None)


def is_fast_pol(params: JobParameters) -> bool:
    # Function to determine which readout mode was used
    return params.get_workflow_param("fast_or_slow") == "FastPolarimetry"


def is_long_exp_SlowPol(params: JobParameters) -> bool:
    # Function to determine if exposure time is >= 30 sec
    return params.get_workflow_param("exptime") >= 30 and params.get_workflow_param("fast_or_slow") == "SlowPolarimetry"


def is_YJH(params: JobParameters) -> bool:
    # Function to determine which readout mode was used
    return params.get_workflow_param("IFS_disperser") == "PRI_YJH"


def distortion_mandatory(params: JobParameters) -> bool:
    return get_parameter(params, "force_distortion_correction") == "TRUE"


def distortion_optional(params: JobParameters) -> bool:
    return get_parameter(params, "force_distortion_correction") == "FALSE"


def set_skybackground_parameters(job: Job):
    if len(job.input_files) < 3:
        job.parameters.recipe_parameters["ifs.cal_background.clean_mean.reject_high"] = 0
        job.parameters.recipe_parameters["ifs.cal_background.clean_mean.reject_low"] = 0
