from edps import task, qc0, calchecker

from . import zimpol_rules as rules
from .sphere_task_functions import (
    which_readout_type, which_exptime,
    is_fast_pol, is_long_exp_SlowPol
)
from .zimpol_classification import (
    ZPL_MASTER_BIAS_CAM1, ZPL_MASTER_BIAS_CAM2,
    ZPL_MASTER_DARK_CAM1, ZPL_MASTER_DARK_CAM2,
    ZPL_INT_FLAT_FIELD_MASTER_CAM1, ZPL_INT_FLAT_FIELD_MASTER_CAM2,
)
from .zimpol_datasources import zpl_raw_science_center_pol
from .zimpol_polarimetry_subwkf import (
    process_zpl_internal_calib_pol, process_zpl_standard_pol,
    process_zpl_science_p1, process_zpl_science_p2
)

"""
# Naming conventions

- Classification rules for raw frames start with `cls_`
- Classification rules for products have the same name as the PRO.CATG
- DataSources start with `zpl_raw_`
- Tasks start with `task_zpl_`
"""
__title__ = "SPHERE ZIMPOL polarimetry workflow"
########
# TASK #
########
# Determination of instrumental distortion from observations of pinhole mask
# no pipeline support; kept as a placeholder
# task_zpl_distortion = (task("zimpol_distortion_pol")
#                       .with_main_input(zpl_raw_distortion)
#                       .with_meta_targets([calchecker])
#                       .build())

# for SCI subcascade
# --- Determination of pixel-to-pixel variation in sensitivity (quantum efficiency, filter defects, etc.)
# and the efficiency of the modulation and demodulation of the ZIMPOL detector ----------------------------------------
task_zpl_bias_pol, task_zpl_dark_pol, task_zpl_flat_pol_cam1, task_zpl_flat_pol_cam2, task_zpl_modem_eff_cam1, \
    task_zpl_modem_eff_cam2, task_zpl_flat_pol_qc, task_zpl_modem_eff_qc = process_zpl_internal_calib_pol()

# --- Determine polarization accuracy using polarimetric standard stars
# Not used for science processing, monitoring only ------------------------------------------------
task_zpl_std_pol0, task_zpl_std_polhigh = process_zpl_standard_pol(task_zpl_bias_pol, task_zpl_dark_pol,
                                                                   task_zpl_flat_pol_cam1,
                                                                   task_zpl_flat_pol_cam2, task_zpl_modem_eff_cam1,
                                                                   task_zpl_modem_eff_cam2)

# --- proces raw science ------------------------------------------------------------------------------------
# Determine the star's position behind the coronagraph, needed for precise definition of center of
# rotation in pupil-stabilized data
task_zpl_coronagraph_center_pol = (task("zimpol_coronagraph_center_polarimetry")
                                   .with_recipe("sph_zpl_star_center_pol")
                                   .with_dynamic_parameter("fast_or_slow", which_readout_type)
                                   .with_dynamic_parameter("exptime", which_exptime)
                                   .with_main_input(zpl_raw_science_center_pol)
                                   .with_associated_input(task_zpl_bias_pol,
                                                          [ZPL_MASTER_BIAS_CAM1, ZPL_MASTER_BIAS_CAM2],
                                                          condition=is_fast_pol, min_ret=0)
                                   .with_associated_input(task_zpl_dark_pol,
                                                          [ZPL_MASTER_DARK_CAM1, ZPL_MASTER_DARK_CAM2],
                                                          condition=is_long_exp_SlowPol, min_ret=0)
                                   .with_associated_input(task_zpl_flat_pol_cam1, [ZPL_INT_FLAT_FIELD_MASTER_CAM1],
                                                          min_ret=0, match_rules=rules.zpl_ff_cam1)
                                   .with_associated_input(task_zpl_flat_pol_cam2, [ZPL_INT_FLAT_FIELD_MASTER_CAM2],
                                                          min_ret=0, match_rules=rules.zpl_ff_cam2)
                                   .with_meta_targets([qc0, calchecker])
                                   .build())

task_zpl_science_flux_p1, task_zpl_science_p1 = process_zpl_science_p1(task_zpl_bias_pol, task_zpl_dark_pol,
                                                                       task_zpl_flat_pol_cam1,
                                                                       task_zpl_flat_pol_cam2, task_zpl_modem_eff_cam1,
                                                                       task_zpl_modem_eff_cam2,
                                                                       task_zpl_coronagraph_center_pol)

task_zpl_science_flux_p2, task_zpl_science_p2 = process_zpl_science_p2(task_zpl_bias_pol, task_zpl_dark_pol,
                                                                       task_zpl_flat_pol_cam1,
                                                                       task_zpl_flat_pol_cam2, task_zpl_modem_eff_cam1,
                                                                       task_zpl_modem_eff_cam2,
                                                                       task_zpl_coronagraph_center_pol)
