from adari_core.data_libs.echelle_flatfield import MasterEchelleFlatfieldReport

from adari_core.plots.text import TextPlot
import os

from . import UvesReportMixin

center_size = 200


class UvesEchelleFlatfieldReport(UvesReportMixin, MasterEchelleFlatfieldReport):
    raw_extension_default = None
    flat_type = "FLAT"

    def __init__(self):
        super().__init__("uves_echelle_flatfield")
        self.center_size = center_size

    def set_flat_type(self):
        """Set the FLAT type category to use for producing the report."""
        for _, catg in self.inputs:
            if "DFLAT" in catg:
                self.flat_type = "DFLAT"
                return
            elif "IFLAT" in catg:
                self.flat_type = "IFLAT"
                return

    def parse_sof(self):
        # Need to generate the following sets (master/raw):
        # ORDER_PROFILE_A/ORDER_TABLE_A
        # ORDER_PROFILE_B/ORDER_TABLE_B
        master_b = None
        master_rl = None
        master_ru = None

        first_raw_flat_b = None
        first_raw_flat_rl = None
        first_raw_flat_ru = None

        # First check whether is FLAT, DFLAT or IFLAT
        self.set_flat_type()

        for filename, catg in self.inputs:
            # PRODUCT FILES (BLUE, REDL, or REDU)
            if catg == f"MASTER_{self.flat_type}_BLUE":
                master_b = filename
            elif catg == f"MASTER_{self.flat_type}_REDL":
                master_rl = filename
            elif catg == f"MASTER_{self.flat_type}_REDU":
                master_ru = filename
            # RAW FILES (BLUE or RED)
            elif catg == f"{self.flat_type}_BLUE" and first_raw_flat_b is None:
                first_raw_flat_b = filename
            elif catg == f"{self.flat_type}_RED" and first_raw_flat_rl is None:
                first_raw_flat_rl = filename
            elif catg == f"{self.flat_type}_RED" and first_raw_flat_ru is None:
                first_raw_flat_ru = filename

        file_lists = []
        self.raw_extension_default = []
        if master_b is not None and first_raw_flat_b is not None:
            file_lists.append(
                {
                    "master_product": master_b,
                    "raw": first_raw_flat_b,
                }
            )
            self.raw_extension_default.append(0)
        if master_rl is not None and first_raw_flat_rl is not None:
            file_lists.append(
                {
                    "master_product": master_rl,
                    "raw": first_raw_flat_rl,
                }
            )
            self.raw_extension_default.append(2)
        if master_ru is not None and first_raw_flat_ru is not None:
            file_lists.append(
                {
                    "master_product": master_ru,
                    "raw": first_raw_flat_ru,
                }
            )
            self.raw_extension_default.append(1)
        return file_lists

    def generate_panels(self, **kwargs):
        panels = {}
        new_panels = super().generate_panels(
            master_product_ext="PRIMARY", raw_ext=self.raw_extension_default, direction = "x"
        )
        for i, (panel, panel_descr) in enumerate(new_panels.items()):
            # Modify the number of panel columns
            panel.x = 3

            for yl in [(1, 1), (1, 2)]:
                plt = panel.retrieve(*yl)
                plt.y_label = "counts"
            # Manipulate histogram plots
            exptime = self.hdus[i]["raw"]["PRIMARY"].header.get("EXPTIME")
            # Data for both raw and master files histograms.
            hist_data = [
                [-5e3, 7e4, "counts"],
                [-5e3 / exptime, 7e4 / exptime, "normalized counts"],
            ]
            for xl, hist_d in zip([(2, 1), (2, 2)], hist_data):
                plt = panel.retrieve(*xl)
                plt.x_label = hist_d[2]
                plt.v_min, plt.v_max = hist_d[:2]
            # Metadata
            vspace = 0.3
            master = self.hdus[i]["master_product"]
            hdr = master["PRIMARY"].header

            t2 = TextPlot(columns=1, v_space=vspace, xext=1)
            col2 = [
                "DET.BINX: " + str(hdr.get("HIERARCH ESO DET WIN1 BINX")),
                "DET.BINY: " + str(hdr.get("HIERARCH ESO DET WIN1 BINY")),
                "DET.READ.SPEED: " + str(hdr.get("HIERARCH ESO DET READ SPEED")),
                "INS.MODE: " + str(hdr.get("HIERARCH ESO INS MODE")),
            ]
            for g in [1, 2]:
                keyword = f"HIERARCH ESO INS GRAT{g} NAME"
                grating_name = hdr.get(keyword)
                if grating_name is not None:
                    col2.append(f"INS.GRAT{g}.NAME: " + grating_name)

                keyword = f"HIERARCH ESO INS GRAT{g} WLEN"
                grating_wl = hdr.get(keyword)
                if grating_wl is not None:
                    col2.append(f"INS.GRAT{g}.WLEN: " + str(grating_wl))

            keyword = f"HIERARCH ESO INS SLIT1 NAME"
            slit_name = hdr.get(keyword)
            if slit_name is not None:
                col2.append(f"INS.SLIT1.NAME: " + slit_name)

            for g in [2, 3]:
                keyword = f"HIERARCH ESO INS SLIT{g} WID"
                slit_width = hdr.get(keyword)
                if slit_width is not None:
                    col2.append(f"INS.SLIT{g}.WID: " + str(slit_width))

            t2.add_data(col2)
            panel.assign_plot(t2, 2, 0, xext=1)

            # Update the panel description
            panel_descr["report_name"] = "uves_echelle_flatfield_{}".format(
                hdr.get("HIERARCH ESO PRO CATG").lower()
            )
            panel_descr["report_description"] = (
                f"UVES echelle flatfield - "
                f"{os.path.basename(panel_descr['master_product'])}, "
                f"{panel_descr['master_product_ext']}"
            )

        panels = {**panels, **new_panels}

        return panels


rep = UvesEchelleFlatfieldReport()
