class UvesSetupInfo:

    def get_arm_info(hdul):
        header_list = list(hdul["PRIMARY"].header.keys())
        subs = "ESO PRO CATG"
        if subs in header_list:
            arm_info = str(hdul["PRIMARY"].header.get("HIERARCH ESO PRO CATG"))
        else:
            arm_info = str(hdul["PRIMARY"].header.get("HIERARCH ESO INS PATH"))
        return arm_info

    
    def bias(hdul):
        metadata = [
            "DET.WIN1.BINX: "
            + str(
                hdul["PRIMARY"].header.get("HIERARCH ESO DET WIN1 BINX", "Not found")
            ),
            "DET.WIN1.BINY: "
            + str(
                hdul["PRIMARY"].header.get("HIERARCH ESO DET WIN1 BINY", "Not found")
            ),
            "DET.READ.SPEED: "
            + str(
                hdul["PRIMARY"].header.get("HIERARCH ESO DET READ SPEED", "Not found")
            ),
        ]
        return metadata

    def dark(hdul):
        return UvesSetupInfo.bias(hdul)

    def cd_align_blue(hdul):
        metadata = [
            "DET.READ.SPEED: "
            + str(
                hdul["PRIMARY"].header.get("HIERARCH ESO DET READ SPEED", "Not found")
            ),
            "INS.GRAT1.NAME: "
            + str(
                hdul["PRIMARY"].header.get("HIERARCH ESO INS GRAT1 NAME", "Not found")
            ),
        ]
        return metadata

    def cd_align_red(hdul):
        metadata = [
            "DET.READ.SPEED: "
            + str(
                hdul["PRIMARY"].header.get("HIERARCH ESO DET READ SPEED", "Not found")
            ),
            "INS.GRAT2.NAME: "
            + str(
                hdul["PRIMARY"].header.get("HIERARCH ESO INS GRAT2 NAME", "Not found")
            ),
        ]
        return metadata

    def ccdtest(hdul):
        return UvesSetupInfo.bias(hdul)

    def arc(hdul):
        g1 = "HIERARCH ESO INS GRAT1 NAME"
        g2 = "HIERARCH ESO INS GRAT2 NAME"
        w1 = "HIERARCH ESO INS GRAT1 WLEN"
        w2 = "HIERARCH ESO INS GRAT2 WLEN"
        s2 = "HIERARCH ESO INS SLIT2 WID"
        hdr = hdul["PRIMARY"].header
        metadata = [
            "DET.WIN1.BINX: " + str(hdr.get("HIERARCH ESO DET WIN1 BINX")),
            "DET.WIN1.BINY: " + str(hdr.get("HIERARCH ESO DET WIN1 BINY", "Not found")),
            "DET.READ.SPEED: "
            + str(hdr.get("HIERARCH ESO DET READ SPEED", "Not found")),
            ##
            "INS.MODE: " + str(hdr.get("HIERARCH ESO INS MODE", "Not found")),
            ##
            "INS.GRAT1.NAME: " + str(hdr.get(g1, "Not found"))
            if g1 in hdr
            else "INS.GRAT2.NAME: " + str(hdr.get(g2, "Not found")),
            ##
            "INS.GRAT1.WLEN: " + str(hdr.get(w1, "Not found"))
            if g1 in hdr
            else "INS.GRAT2.WLEN: " + str(hdr.get(w2, "Not found")),
            ##
            "INS.SLIT1.NAME: "
            + str(hdr.get("HIERARCH ESO INS SLIT1 NAME", "Not found")),
            "INS.SLIT2.WID: " + str(hdr.get(s2, "Not found"))
            if s2 in hdr
            else "INS.SLIT3.WID: "
            + str(hdr.get(s2.replace("SLIT2", "SLIT3"), "Not found")),
        ]
        return metadata

    def arc_mos(hdul):
        metadata = UvesSetupInfo.arc(hdul)[:3]
        metadata.append(
            "INS.SLIT3.PLATE: "
            + str(
                hdul["PRIMARY"].header.get("HIERARCH ESO INS SLIT3 PLATE", "Not found")
            )
        )
        metadata.append(
            "INS.SLIT3.MODE: "
            + str(
                hdul["PRIMARY"].header.get("HIERARCH ESO INS SLIT3 MODE", "Not found")
            )
        )
        metadata.append(
            "INS.GRAT2.WLEN: "
            + str(
                hdul["PRIMARY"].header.get("HIERARCH ESO INS GRAT2 WLEN", "Not found")
            )
        )
        return metadata

    def orderpos(hdul):
        metadata = UvesSetupInfo.arc(hdul)
        return metadata[:-1]

    def orderpos_mos(hdul):
        metadata = [
            "DET.WIN1.BINX: "
            + str(
                hdul["PRIMARY"].header.get("HIERARCH ESO DET WIN1 BINX", "Not found")
            ),
            "DET.WIN1.BINY: "
            + str(
                hdul["PRIMARY"].header.get("HIERARCH ESO DET WIN1 BINY", "Not found")
            ),
            "DET.READ.SPEED: "
            + str(
                hdul["PRIMARY"].header.get("HIERARCH ESO DET READ SPEED", "Not found")
            ),
            "INS.SLIT3.PLATE: "
            + str(
                hdul["PRIMARY"].header.get("HIERARCH ESO INS SLIT3 PLATE", "Not found")
            ),
            "INS.GRAT2.WLEN: "
            + str(
                hdul["PRIMARY"].header.get("HIERARCH ESO INS GRAT2 WLEN", "Not found")
            ),
        ]
        return metadata

    def response(hdul):
        metadata = UvesSetupInfo.arc(hdul)
        del metadata[4]
        metadata[-1] = "OBS.TARG.NAME: " + str(
            hdul["PRIMARY"].header.get("HIERARCH ESO OBS TARG NAME", "Not found")
        )
        return metadata

    def predict(hdul):
        metadata = UvesSetupInfo.arc(hdul)
        metadata = metadata[:-2]
        return metadata

    def predict_mos(hdul):
        metadata = UvesSetupInfo.predict(hdul)
        metadata[3] = "INS.SLIT3.PLATE: " + str(
            hdul["PRIMARY"].header.get("HIERARCH ESO INS SLIT3 PLATE", "Not found")
        )
        metadata[4] = "INS.GRAT2.WLEN: " + str(
            hdul["PRIMARY"].header.get("HIERARCH ESO INS GRAT2 WLEN", "Not found")
        )
        del metadata[5:]
        return metadata

    def flat(hdul):
        return UvesSetupInfo.arc(hdul)

    def iflat(hdul):
        return UvesSetupInfo.flat(hdul)

    def dflat(hdul):
        return UvesSetupInfo.flat(hdul)

    def flat_mos(hdul):
        metadata = [
            "DET.WIN1.BINX: "
            + str(
                hdul["PRIMARY"].header.get("HIERARCH ESO DET WIN1 BINX", "Not found")
            ),
            "DET.WIN1.BINY: "
            + str(
                hdul["PRIMARY"].header.get("HIERARCH ESO DET WIN1 BINY", "Not found")
            ),
            "DET.READ.SPEED: "
            + str(
                hdul["PRIMARY"].header.get("HIERARCH ESO DET READ SPEED", "Not found")
            ),
            "INS.GRAT2.WLEN: "
            + str(
                hdul["PRIMARY"].header.get("HIERARCH ESO INS GRAT2 WLEN", "Not found")
            ),
        ]
        return metadata

    def sff_ofpos_mos(hdul):
        metadata = [
            "DET.BINX: "
            + str(
                hdul["PRIMARY"].header.get("HIERARCH ESO DET WIN1 BINX", "Not found")
            ),
            "DET.BINY: "
            + str(
                hdul["PRIMARY"].header.get("HIERARCH ESO DET WIN1 BINY", "Not found")
            ),
            "DET.READ.SPEED: "
            + str(
                hdul["PRIMARY"].header.get("HIERARCH ESO DET READ SPEED", "Not found")
            ),
            "INS.SLIT3.PLATE: "
            + str(
                hdul["PRIMARY"].header.get("HIERARCH ESO INS SLIT3 PLATE", "Not found")
            ),
            "INS.SLIT3.MODE: "
            + str(
                hdul["PRIMARY"].header.get("HIERARCH ESO INS SLIT3 MODE", "Not found")
            ),
            "INS.GRAT2.WLEN: "
            + str(
                hdul["PRIMARY"].header.get("HIERARCH ESO INS GRAT2 WLEN", "Not found")
            ),
        ]
        return metadata
