from edps import classification_rule

from . import uves_keywords as kwd
from . import uves_rules as rules

# Dictionaris containing the values of header keywords that define calibrations and science data
# in the red and blue arms.
uves = {kwd.instrume: "UVES"}
calib_keywords = {**uves, kwd.pro_catg: None, kwd.dpr_catg: "CALIB"}
science_keywords = {**uves, kwd.pro_catg: None, kwd.dpr_catg: "SCIENCE"}
blue_calib_keywords = {**calib_keywords, kwd.det_chips: 1}
red_calib_keywords = {**calib_keywords, kwd.det_chips: 2}
blue_science_keywords = {**science_keywords, kwd.det_chips: 1}
red_science_keywords = {**science_keywords, kwd.det_chips: 2}

# ---- Classification rules  -----------------

# Raw types
bias_blue_class = classification_rule('BIAS_BLUE', {**blue_calib_keywords, kwd.dpr_type: "BIAS"})
bias_red_class = classification_rule('BIAS_RED', {**red_calib_keywords, kwd.dpr_type: "BIAS"})
detmon_on_class = classification_rule("ON_RAW", {**calib_keywords, kwd.dpr_type: "LAMP,FLAT,DETCHAR"})
detmon_off_class = classification_rule("OFF_RAW", {**calib_keywords, kwd.dpr_type: "BIAS,DETCHAR"})
cd_align_blue_class = classification_rule("CD_ALIGN_BLUE", rules.is_cdalign_blue)
cd_align_red_class = classification_rule("CD_ALIGN_RED", rules.is_cdalign_red)

dark_blue_class = classification_rule('DARK_BLUE', {**blue_calib_keywords, kwd.dpr_type: "DARK"})
dark_red_class = classification_rule('DARK_RED', {**red_calib_keywords, kwd.dpr_type: "DARK"})
pdark_blue_class = classification_rule('PDARK_BLUE', {**blue_calib_keywords, kwd.dpr_type: "PARASITIC"})
pdark_red_class = classification_rule('PDARK_RED', {**red_calib_keywords, kwd.dpr_type: "PARASITIC"})

arc_lamp_form_blue_class = classification_rule('ARC_LAMP_FORM_BLUE',
                                               {**blue_calib_keywords, kwd.dpr_type: "LAMP,FMTCHK"})
arc_lamp_form_red_class = classification_rule('ARC_LAMP_FORM_RED',
                                              {**red_calib_keywords, kwd.dpr_type: "LAMP,FMTCHK"})
arc_lamp_form_mos_class = classification_rule('FIB_ARC_LAMP_FORM_RED',
                                              {**red_calib_keywords, kwd.dpr_type: "LAMP,FMTCHK,SimCal"})

order_flat_blue_class = classification_rule('ORDER_FLAT_BLUE',
                                            {**blue_calib_keywords, kwd.dpr_type: "LAMP,ORDERDEF"})
order_flat_red_class = classification_rule('ORDER_FLAT_RED', {**red_calib_keywords, kwd.dpr_type: "LAMP,ORDERDEF"})
order_flat_mos_class = classification_rule('FIB_ORDEF_RED',
                                           {**red_calib_keywords, kwd.dpr_type: "LAMP,ORDERDEF,SimCal"})

flat_blue_class = classification_rule('FLAT_BLUE', {**blue_calib_keywords, kwd.dpr_type: "LAMP,FLAT"})
flat_red_class = classification_rule('FLAT_RED', {**red_calib_keywords, kwd.dpr_type: "LAMP,FLAT"})
flat_mos_class = classification_rule('SFLAT_RED', {**red_calib_keywords, kwd.dpr_type: "LAMP,SFLAT"})

fib_ff_odd_mos_class = classification_rule('FIB_FF_ODD_RED', rules.is_fib_ff_odd_mos)
fib_ff_even_mos_class = classification_rule('FIB_FF_EVEN_RED', rules.is_fib_ff_even_mos)
fib_ff_all_mos_class = classification_rule('FIB_FF_ALL_RED', rules.is_fib_ff_all_mos)

dflat_blue_class = classification_rule('DFLAT_BLUE', {**blue_calib_keywords, kwd.dpr_type: "LAMP,DFLAT"})
dflat_red_class = classification_rule('DFLAT_RED', {**red_calib_keywords, kwd.dpr_type: "LAMP,DFLAT"})
iflat_blue_class = classification_rule('IFLAT_BLUE', {**blue_calib_keywords, kwd.dpr_type: "LAMP,IFLAT"})
iflat_red_class = classification_rule('IFLAT_RED', {**red_calib_keywords, kwd.dpr_type: "LAMP,IFLAT"})
tflat_blue_class = classification_rule('TFLAT_BLUE', {**blue_calib_keywords, kwd.dpr_type: "LAMP,TFLAT"})
tflat_red_class = classification_rule('TFLAT_RED', {**red_calib_keywords, kwd.dpr_type: "LAMP,TFLAT"})

wave_blue_class = classification_rule('ARC_LAMP_BLUE', rules.is_arc_lamp_blue)
wave_red_class_1 = classification_rule('ARC_LAMP_RED', rules.is_arc_lamp_red_1)
wave_red_class_2 = classification_rule('ARC_LAMP_RED', rules.is_arc_lamp_red_2)
focus_red_class_1 = classification_rule('ARC_LAMP_RED', rules.is_arc_focus_1)
focus_red_class_2 = classification_rule('ARC_LAMP_RED', rules.is_arc_focus_2)
wave_mos_class = classification_rule('FIB_ARC_LAMP_RED', rules.is_arc_lamp_mos)

standard_blue_class = classification_rule('STANDARD_BLUE', rules.is_standard_blue)
standard_red_class = classification_rule('STANDARD_RED', rules.is_standard_red)
telluric_blue_class = classification_rule('STANDARD_BLUE', rules.is_telluric_blue)
telluric_red_class = classification_rule('STANDARD_RED', rules.is_telluric_red)
efficiency_blue_class = classification_rule('STANDARD_BLUE', rules.is_efficiency_blue)
efficiency_red_class = classification_rule('STANDARD_RED', rules.is_efficiency_red)

sci_point_blue_class = classification_rule('SCI_POINT_BLUE',
                                           {**blue_science_keywords, kwd.dpr_type: "OBJECT,POINT"})
sci_point_red_class = classification_rule('SCI_POINT_RED', {**red_science_keywords, kwd.dpr_type: "OBJECT,POINT"})
sci_extended_blue_class = classification_rule('SCI_EXTND_BLUE',
                                              {**blue_science_keywords, kwd.dpr_type: "OBJECT,EXTENDED"})
sci_extended_red_class = classification_rule('SCI_EXTND_RED',
                                             {**red_science_keywords, kwd.dpr_type: "OBJECT,EXTENDED"})
sci_generic_blue_class = classification_rule('SCIENCE_BLUE', {**blue_science_keywords, kwd.dpr_type: "OBJECT"})
sci_generic_red_class = classification_rule('SCIENCE_RED', {**red_science_keywords, kwd.dpr_type: "OBJECT"})
solar_extended_blue_class = classification_rule('SCI_EXTND_BLUE', rules.is_solar_blue)
solar_extended_red_class = classification_rule('SCI_EXTND_RED', rules.is_solar_red)
fib_science_mos_class = classification_rule('FIB_SCI_RED', rules.is_science_mos)
acquisition_class = classification_rule("ACQ_ECH", {**uves, kwd.dpr_type: "SLIT", kwd.dpr_tech: "IMAGE"})
# Static calibrations
master_response_redl_class = classification_rule('MASTER_RESPONSE_REDL',
                                                 {**uves, kwd.pro_catg: 'MASTER_RESPONSE_REDL'})
master_response_redu_class = classification_rule('MASTER_RESPONSE_REDU',
                                                 {**uves, kwd.pro_catg: 'MASTER_RESPONSE_REDU'})
master_response_blue_class = classification_rule('MASTER_RESPONSE_BLUE',
                                                 {**uves, kwd.pro_catg: 'MASTER_RESPONSE_BLUE'})

line_refer_table_class = classification_rule('LINE_REFER_TABLE',
                                             {**uves, kwd.pro_catg: 'LINE_REFER_TABLE'})
master_form_blue_class = classification_rule('MASTER_FORM_BLUE',
                                             {**uves, kwd.pro_catg: 'MASTER_FORM_BLUE'})
master_form_redl_class = classification_rule('MASTER_FORM_REDL',
                                             {**uves, kwd.pro_catg: 'MASTER_FORM_REDL'})
master_form_redu_class = classification_rule('MASTER_FORM_REDU',
                                             {**uves, kwd.pro_catg: 'MASTER_FORM_REDU'})
corvel_mask_class = classification_rule('CORVEL_MASK', {**uves, kwd.pro_catg: 'CORVEL_MASK'})
line_intmon_table_class = classification_rule('LINE_INTMON_TABLE',
                                              {**uves, kwd.pro_catg: 'LINE_INTMON_TABLE'})
flux_std_table_class = classification_rule('FLUX_STD_TABLE', {**uves, kwd.pro_catg: 'FLUX_STD_TABLE'})
extcoeff_table_class = classification_rule('EXTCOEFF_TABLE', {**uves, kwd.pro_catg: 'EXTCOEFF_TABLE'})
resp_fit_points_catalog_class = classification_rule('RESP_FIT_POINTS_CATALOG',
                                                    {**uves, kwd.pro_catg: 'RESP_FIT_POINTS_CATALOG'})
efficiency_windows_class = classification_rule('EFFICIENCY_WINDOWS',
                                               {**uves, kwd.pro_catg: 'EFFICIENCY_WINDOWS'})
quality_areas_class = classification_rule('QUALITY_AREAS', {**uves, kwd.pro_catg: 'QUALITY_AREAS'})
fit_areas_class = classification_rule('FIT_AREAS', {**uves, kwd.pro_catg: 'FIT_AREAS'})
tell_mod_catalog_class = classification_rule('TELL_MOD_CATALOG',
                                             {**uves, kwd.pro_catg: 'TELL_MOD_CATALOG'})
pd_mask_blue_class = classification_rule('PD_MASK_BLUE', {**uves, kwd.pro_catg: 'PD_MASK_BLUE'})
pd_mask_redl_class = classification_rule('PD_MASK_REDL', {**uves, kwd.pro_catg: 'PD_MASK_REDL'})
pd_mask_redu_class = classification_rule('PD_MASK_REDU', {**uves, kwd.pro_catg: 'PD_MASK_REDU'})

# Master calibrations
MASTER_BIAS_BLUE = classification_rule('MASTER_BIAS_BLUE', {**uves, kwd.pro_catg: 'MASTER_BIAS_BLUE'})
MASTER_BIAS_REDL = classification_rule('MASTER_BIAS_REDL', {**uves, kwd.pro_catg: 'MASTER_BIAS_REDL'})
MASTER_BIAS_REDU = classification_rule('MASTER_BIAS_REDU', {**uves, kwd.pro_catg: 'MASTER_BIAS_REDU'})
MASTER_DARK_BLUE = classification_rule('MASTER_DARK_BLUE', {**uves, kwd.pro_catg: 'MASTER_DARK_BLUE'})
MASTER_DARK_REDL = classification_rule('MASTER_DARK_REDL', {**uves, kwd.pro_catg: 'MASTER_DARK_REDL'})
MASTER_DARK_REDU = classification_rule('MASTER_DARK_REDU', {**uves, kwd.pro_catg: 'MASTER_DARK_REDU'})

ORDER_GUESS_TABLE_BLUE = classification_rule('ORDER_GUESS_TAB_BLUE',
                                             {**uves, kwd.pro_catg: 'ORDER_GUESS_TAB_BLUE'})
ORDER_GUESS_TABLE_REDL = classification_rule('ORDER_GUESS_TAB_REDL',
                                             {**uves, kwd.pro_catg: 'ORDER_GUESS_TAB_REDL'})
ORDER_GUESS_TABLE_REDU = classification_rule('ORDER_GUESS_TAB_REDU',
                                             {**uves, kwd.pro_catg: 'ORDER_GUESS_TAB_REDU'})

LINE_GUESS_TABLE_BLUE = classification_rule('LINE_GUESS_TAB_BLUE',
                                            {**uves, kwd.pro_catg: 'LINE_GUESS_TAB_BLUE'})
LINE_GUESS_TABLE_REDL = classification_rule('LINE_GUESS_TAB_REDL',
                                            {**uves, kwd.pro_catg: 'LINE_GUESS_TAB_REDL'})
LINE_GUESS_TABLE_REDU = classification_rule('LINE_GUESS_TAB_REDU',
                                            {**uves, kwd.pro_catg: 'LINE_GUESS_TAB_REDU'})

FIB_LIN_GUE_TAB_REDL = classification_rule('FIB_LIN_GUE_REDL', {**uves, kwd.pro_catg: 'FIB_LIN_GUE_REDL'})
FIB_LIN_GUE_TAB_REDU = classification_rule('FIB_LIN_GUE_REDU', {**uves, kwd.pro_catg: 'FIB_LIN_GUE_REDU'})

ORDER_TABLE_BLUE = classification_rule('ORDER_TABLE_BLUE', {**uves, kwd.pro_catg: 'ORDER_TABLE_BLUE'})
ORDER_TABLE_REDL = classification_rule('ORDER_TABLE_REDL', {**uves, kwd.pro_catg: 'ORDER_TABLE_REDL'})
ORDER_TABLE_REDU = classification_rule('ORDER_TABLE_REDU', {**uves, kwd.pro_catg: 'ORDER_TABLE_REDU'})

FIB_ORDER_GUE_REDL = classification_rule('FIB_ORD_GUE_REDL', {**uves, kwd.pro_catg: 'FIB_ORD_GUE_REDL'})
FIB_ORDER_GUE_REDU = classification_rule('FIB_ORD_GUE_REDU', {**uves, kwd.pro_catg: 'FIB_ORD_GUE_REDU'})

LINE_TABLE_BLUE = classification_rule('LINE_TABLE_BLUE', {**uves, kwd.pro_catg: 'LINE_TABLE_BLUE'})
LINE_TABLE_REDL = classification_rule('LINE_TABLE_REDL', {**uves, kwd.pro_catg: 'LINE_TABLE_REDL'})
LINE_TABLE_REDU = classification_rule('LINE_TABLE_REDU', {**uves, kwd.pro_catg: 'LINE_TABLE_REDU'})

FIB_LINE_TABLE_REDL = classification_rule('FIB_LINE_TABLE_REDL',
                                          {**uves, kwd.pro_catg: 'FIB_LINE_TABLE_REDL'})
FIB_LINE_TABLE_REDU = classification_rule('FIB_LINE_TABLE_REDU',
                                          {**uves, kwd.pro_catg: 'FIB_LINE_TABLE_REDU'})

MASTER_FLAT_BLUE = classification_rule('MASTER_FLAT_BLUE', {**uves, kwd.pro_catg: 'MASTER_FLAT_BLUE'})
MASTER_FLAT_REDL = classification_rule('MASTER_FLAT_REDL', {**uves, kwd.pro_catg: 'MASTER_FLAT_REDL'})
MASTER_FLAT_REDU = classification_rule('MASTER_FLAT_REDU', {**uves, kwd.pro_catg: 'MASTER_FLAT_REDU'})
MASTER_IFLAT_BLUE = classification_rule('MASTER_IFLAT_BLUE', {**uves, kwd.pro_catg: 'MASTER_IFLAT_BLUE'})
MASTER_IFLAT_REDL = classification_rule('MASTER_IFLAT_REDL', {**uves, kwd.pro_catg: 'MASTER_IFLAT_REDL'})
MASTER_IFLAT_REDU = classification_rule('MASTER_IFLAT_REDU', {**uves, kwd.pro_catg: 'MASTER_IFLAT_REDU'})
MASTER_SFLAT_REDL1 = classification_rule('MASTER_SFLAT_REDL1', rules.is_master_sflat_redl1)
MASTER_SFLAT_REDU1 = classification_rule('MASTER_SFLAT_REDU1', rules.is_master_sflat_redu1)
MASTER_SFLAT_REDL2 = classification_rule('MASTER_SFLAT_REDL2', rules.is_master_sflat_redl2)
MASTER_SFLAT_REDU2 = classification_rule('MASTER_SFLAT_REDU2', rules.is_master_sflat_redu2)
MASTER_SFLAT_REDL3 = classification_rule('MASTER_SFLAT_REDL3', rules.is_master_sflat_redl3)
MASTER_SFLAT_REDU3 = classification_rule('MASTER_SFLAT_REDU3', rules.is_master_sflat_redu3)
# To avoid double and misleading classifications of master sflats
MASTER_SFLAT_REDL = classification_rule('MASTER_SFLAT_REDL', lambda f: False)
MASTER_SFLAT_REDU = classification_rule('MASTER_SFLAT_REDU', lambda f: False)

MASTER_DFLAT_BLUE = classification_rule('MASTER_DFLAT_BLUE', {**uves, kwd.pro_catg: 'MASTER_DFLAT_BLUE'})
FIB_ORDEF_TABLE_REDL = classification_rule('FIB_ORDEF_TABLE_REDL',
                                           {**uves, kwd.pro_catg: 'FIB_ORDEF_TABLE_REDL'})
FIB_ORDEF_TABLE_REDU = classification_rule('FIB_ORDEF_TABLE_REDU',
                                           {**uves, kwd.pro_catg: 'FIB_ORDEF_TABLE_REDU'})
FIB_ORD_TAB_REDL = classification_rule('FIB_ORD_TAB_REDL', {**uves, kwd.pro_catg: 'FIB_ORD_TAB_REDL'})
FIB_ORD_TAB_REDU = classification_rule('FIB_ORD_TAB_REDU', {**uves, kwd.pro_catg: 'FIB_ORD_TAB_REDU'})

FIB_ORDEF_REDU = classification_rule('FIB_ORDEF_REDU', {**uves, kwd.pro_catg: 'FIB_ORDEF_REDU'})
FIB_ORDEF_REDL = classification_rule('FIB_ORDEF_REDL', {**uves, kwd.pro_catg: 'FIB_ORDEF_REDL'})

FIB_FF_BPC_REDL = classification_rule('FIB_FF_BPC_REDL', {**uves, kwd.pro_catg: 'FIB_FF_BPC_REDL'})
FIB_FF_COM_REDL = classification_rule('FIB_FF_COM_REDL', {**uves, kwd.pro_catg: 'FIB_FF_COM_REDL'})
FIB_FF_DTC_REDL = classification_rule('FIB_FF_DTC_REDL', {**uves, kwd.pro_catg: 'FIB_FF_DTC_REDL'})
FIB_FF_NOR_REDL = classification_rule('FIB_FF_NOR_REDL', {**uves, kwd.pro_catg: 'FIB_FF_NOR_REDL'})
FIB_FF_NSG_REDL = classification_rule('FIB_FF_NSG_REDL', {**uves, kwd.pro_catg: 'FIB_FF_NSG_REDL'})
FIB_FF_SGC_REDL = classification_rule('FIB_FF_SGC_REDL', {**uves, kwd.pro_catg: 'FIB_FF_SGC_REDL'})
FIB_FF_BPC_REDU = classification_rule('FIB_FF_BPC_REDU', {**uves, kwd.pro_catg: 'FIB_FF_BPC_REDU'})
FIB_FF_COM_REDU = classification_rule('FIB_FF_COM_REDU', {**uves, kwd.pro_catg: 'FIB_FF_COM_REDU'})
FIB_FF_DTC_REDU = classification_rule('FIB_FF_DTC_REDU', {**uves, kwd.pro_catg: 'FIB_FF_DTC_REDU'})
FIB_FF_NOR_REDU = classification_rule('FIB_FF_NOR_REDU', {**uves, kwd.pro_catg: 'FIB_FF_NOR_REDU'})
FIB_FF_NSG_REDU = classification_rule('FIB_FF_NSG_REDU', {**uves, kwd.pro_catg: 'FIB_FF_NSG_REDU'})
FIB_FF_SGS_REDU = classification_rule('FIB_FF_SGC_REDU', {**uves, kwd.pro_catg: 'FIB_FF_SGC_REDU'})

SLIT_FF_BPC_REDL = classification_rule('SLIT_FF_BPC_REDL', {**uves, kwd.pro_catg: 'SLIT_FF_BPC_REDL'})
SLIT_FF_COM_REDL = classification_rule('SLIT_FF_COM_REDL', {**uves, kwd.pro_catg: 'SLIT_FF_COM_REDL'})
SLIT_FF_DTC_REDL = classification_rule('SLIT_FF_DTC_REDL', {**uves, kwd.pro_catg: 'SLIT_FF_DTC_REDL'})
SLIT_FF_NOR_REDL = classification_rule('SLIT_FF_NOR_REDL', {**uves, kwd.pro_catg: 'SLIT_FF_NOR_REDL'})
SLIT_FF_BNC_REDL = classification_rule('SLIT_FF_BNC_REDL', {**uves, kwd.pro_catg: 'SLIT_FF_BNC_REDL'})
SLIT_FF_SGC_REDL = classification_rule('SLIT_FF_SGC_REDL', {**uves, kwd.pro_catg: 'SLIT_FF_SGC_REDL'})

SLIT_FF_BPC_REDU = classification_rule('SLIT_FF_BPC_REDU', {**uves, kwd.pro_catg: 'SLIT_FF_BPC_REDU'})
SLIT_FF_COM_REDU = classification_rule('SLIT_FF_COM_REDU', {**uves, kwd.pro_catg: 'SLIT_FF_COM_REDU'})
SLIT_FF_DTC_REDU = classification_rule('SLIT_FF_DTC_REDU', {**uves, kwd.pro_catg: 'SLIT_FF_DTC_REDU'})
SLIT_FF_NOR_REDU = classification_rule('SLIT_FF_NOR_REDU', {**uves, kwd.pro_catg: 'SLIT_FF_NOR_REDU'})
SLIT_FF_BNC_REDU = classification_rule('SLIT_FF_BNC_REDU', {**uves, kwd.pro_catg: 'SLIT_FF_BNC_REDU'})
SLIT_FF_SGC_REDU = classification_rule('SLIT_FF_SGC_REDU', {**uves, kwd.pro_catg: 'SLIT_FF_SGC_REDU'})

INSTR_RESPONSE_FINE_BLUE = classification_rule('INSTR_RESPONSE_FINE_BLUE',
                                               {**uves, kwd.pro_catg: 'INSTR_RESPONSE_FINE_BLUE'})
INSTR_RESPONSE_FINE_REDL = classification_rule('INSTR_RESPONSE_FINE_REDL',
                                               {**uves, kwd.pro_catg: 'INSTR_RESPONSE_FINE_REDL'})
INSTR_RESPONSE_FINE_REDU = classification_rule('INSTR_RESPONSE_FINE_REDU',
                                               {**uves, kwd.pro_catg: 'INSTR_RESPONSE_FINE_REDU'})
