from edps import QC1_CALIB
from edps import task, subworkflow, ReportInput

from .uves_datasources import *
from .uves_job_processing import *


@subworkflow("monitoring", "")
def monitoring():
    # Processing tasks dedicated to instrument monitoring

    # Task to monitor the reproducibility of the cross disperser position
    cdalign = (task('cd_align')
               .with_recipe('uves_cal_cd_align')
               .with_report('uves_rawdisp', ReportInput.RECIPE_INPUTS, driver='png')
               .with_report('uves_cd_alignment', ReportInput.RECIPE_INPUTS_OUTPUTS, driver='png')
               .with_main_input(cd_align)
               .with_meta_targets([QC1_CALIB])
               .build())

    # Task to monitor the detector linearity
    ccdtest = (task('ccdtest')
               .with_recipe('detmon_opt_lg')
               .with_report('uves_rawdisp', ReportInput.RECIPE_INPUTS, driver='png')
               .with_report('uves_detmon', ReportInput.RECIPE_INPUTS_OUTPUTS, driver='png')
               .with_main_input(raw_detmon_off)
               .with_associated_input(raw_detmon_on, max_ret=1000)
               .with_job_processing(detmon_extension)  # sets recipe parameters depending on main input.
               .with_meta_targets([QC1_CALIB])
               .build())

    # Instrument focus exposures.
    # Quality reports for QcFlow are generated. No recipe is executed.
    focus = (task('plot_focus')
             .with_report('uves_rawdisp', ReportInput.RECIPE_INPUTS, driver='png')
             .with_main_input(raw_focus)
             .with_meta_targets([QC1_CALIB])
             .build())

    return cdalign, ccdtest, focus
