from edps import match

from . import uves_keywords as kwd


def is_uves(f):
    return f[kwd.instrume] == "UVES"


def is_raw(f):
    return f[kwd.pro_catg] is None


def is_calib(f):
    return is_uves(f) and is_raw(f) and f[kwd.dpr_catg] == "CALIB"


def is_science(f):
    return is_uves(f) and is_raw(f) and f[kwd.dpr_catg] == "SCIENCE"


def is_technical(f):
    return is_uves(f) and is_raw(f) and f[kwd.dpr_catg] == "TECHNICAL"


def is_test(f):
    return is_uves(f) and is_raw(f) and f[kwd.dpr_catg] == "TEST"


def is_blue(f):
    return f[kwd.det_chips] == 1


def is_red(f):
    return f[kwd.det_chips] == 2


def is_calib_blue(f):
    return is_calib(f) and is_blue(f)


def is_calib_red(f):
    return is_calib(f) and is_red(f)


def is_science_blue(f):
    return is_science(f) and is_blue(f)


def is_science_red(f):
    return is_science(f) and is_red(f)


def is_solar(f):
    return is_calib(f) and f[kwd.pro_catg] is None and \
        f[kwd.dpr_type] in ("OBJECT,EXTENDED", "SKY,RADIAL_VELOCITY", "FLAT,SKY,EXTENDED")


def is_solar_red(f):
    return is_solar(f) and is_red(f)


def is_solar_blue(f):
    return is_solar(f) and is_blue(f)


def is_cdalign_blue(f):
    return is_calib_blue(f) and \
        ((f[kwd.dpr_type] == "LAMP,FLAT" and f[kwd.dpr_tech] == 'IMAGE' and f[kwd.tpl_id] == "UVES_blue_tec_cdtest") or
         (f[kwd.dpr_type] == "LAMP,CDALIGN" and f[kwd.dpr_tech] == "SPECTRUM"))


def is_cdalign_red(f):
    return is_calib_red(f) and \
        ((f[kwd.dpr_type] == "LAMP,FLAT" and f[kwd.dpr_tech] == 'IMAGE' and f[kwd.tpl_id] == "UVES_red_tec_cdtest") or
         (f[kwd.dpr_type] == "LAMP,CDALIGN" and f[kwd.dpr_tech] == "SPECTRUM"))


def is_master_sflat_redl1(f):
    return f[kwd.instrume] == "UVES" and f[kwd.pro_catg] == 'MASTER_SFLAT_REDL' and f[kwd.tpl_expno] == 1


def is_master_sflat_redl2(f):
    return f[kwd.instrume] == "UVES" and f[kwd.pro_catg] == 'MASTER_SFLAT_REDL' and f[kwd.tpl_expno] == 4


def is_master_sflat_redl3(f):
    return f[kwd.instrume] == "UVES" and f[kwd.pro_catg] == 'MASTER_SFLAT_REDL' and f[kwd.tpl_expno] == 7


def is_master_sflat_redu1(f):
    return f[kwd.instrume] == "UVES" and f[kwd.pro_catg] == 'MASTER_SFLAT_REDU' and f[kwd.tpl_expno] == 1


def is_master_sflat_redu2(f):
    return f[kwd.instrume] == "UVES" and f[kwd.pro_catg] == 'MASTER_SFLAT_REDU' and f[kwd.tpl_expno] == 4


def is_master_sflat_redu3(f):
    return f[kwd.instrume] == "UVES" and f[kwd.pro_catg] == 'MASTER_SFLAT_REDU' and f[kwd.tpl_expno] == 7


def is_fib_ff_odd_mos(f):
    return is_calib_red(f) and (f[kwd.dpr_type] == "LAMP,FLAT,ODD,OzPoz" or f[kwd.dpr_type] == "LAMP,FLAT,ODD,SimCal")


def is_fib_ff_even_mos(f):
    return is_calib_red(f) and (f[kwd.dpr_type] == "LAMP,FLAT,EVEN,OzPoz" or f[kwd.dpr_type] == "LAMP,FLAT,EVEN,SimCal")


def is_fib_ff_all_mos(f):
    return is_calib_red(f) and (f[kwd.dpr_type] == "LAMP,FLAT,ALL,OzPoz" or f[kwd.dpr_type] == "LAMP,FLAT,ALL,SimCal")


def is_arc_lamp_blue(f):
    return is_calib_blue(f) and f[kwd.dpr_type] == "LAMP,WAVE"


def is_arc_lamp_red_1(f):
    return (is_calib(f) or is_technical(f) or is_test(f)) and is_red(f) and \
        f[kwd.dpr_type] == "LAMP,WAVE" and f[kwd.obs_name] != "red_focus" and f[kwd.obs_name] != "Calibration" and \
        (f[kwd.dpr_tech] == "ECHELLE" or f[kwd.dpr_tech] == "ECHELLE,ABSORPTION-CELL")


def is_arc_lamp_red_2(f):
    return (is_calib(f) or is_technical(f) or is_test(f)) and is_red(f) and \
        f[kwd.dpr_type] == "LAMP,WAVE" and f[kwd.obs_name] == "Calibration" and \
        (f[kwd.grat2_wlen] != 580.0 or
         (f[kwd.grat2_wlen] == 580.0 and f[kwd.filt3] == "SHP700" and
          ((f[kwd.exptime] > 15.2 or f[kwd.exptime] < 14.8) or ((f[kwd.exptime] < 15.2 or f[kwd.exptime] > 14.8) and
                                                                f[kwd.det_readout] != "4pts/625kHz/lg")))) and \
        (f[kwd.dpr_tech] == "ECHELLE" or f[kwd.dpr_tech] == "ECHELLE,ABSORPTION-CELL")


def is_arc_focus(f):
    return is_calib_red(f) and f[kwd.dpr_type] == "LAMP,WAVE" and \
        (f[kwd.obs_name] == "red_focus" or f[kwd.obs_name] == "Calibration") and \
        f[kwd.grat2_wlen] == 580.0 and 14.8 <= f[kwd.exptime] <= 15.2 and \
        f[kwd.det_readout] == "4pts/625kHz/lg" and \
        (f[kwd.dpr_tech] == "ECHELLE" or f[kwd.dpr_tech] == "ECHELLE,ABSORPTION-CELL")


def is_arc_focus_1(f):
    return is_arc_focus(f) and f[kwd.filt3] == "SHP700"


def is_arc_focus_2(f):
    return is_arc_focus(f) and f[kwd.filt3] != "SHP700"


def is_arc_lamp_mos(f):
    return is_calib_red(f) and (f[kwd.dpr_type] == "LAMP,WAVE,OzPoz" or f[kwd.dpr_type] == "LAMP,WAVE,SimCal")


def is_standard_blue(f):
    return is_calib_blue(f) and f[kwd.dpr_type] == "STD" and 'efficiency' not in f[kwd.obs_name]


def is_standard_red(f):
    return is_calib_red(f) and f[kwd.dpr_type] == "STD" and 'efficiency' not in f[kwd.obs_name]


def is_telluric_blue(f):
    return is_calib_blue(f) and f[kwd.dpr_type] == "STD,TELLURIC"


def is_telluric_red(f):
    return is_calib_red(f) and f[kwd.dpr_type] == "STD,TELLURIC"


def is_efficiency_blue(f):
    return is_calib_blue(f) and f[kwd.dpr_type] == "STD" and 'efficiency' in f[kwd.obs_name]


def is_efficiency_red(f):
    return is_calib_red(f) and f[kwd.dpr_type] == "STD" and 'efficiency' in f[kwd.obs_name]


def is_science_mos(f):
    return is_science_red(f) and (f[kwd.dpr_type] == "OBJECT,OzPoz" or f[kwd.dpr_type] == "OBJECT,SimCal")


def is_fib_science_red(f):
    return is_science_red(f) and "OBJECT" in f[kwd.dpr_type] and (
            "OzPoz" in f[kwd.dpr_type] or "SimCal" in f[kwd.dpr_type])


# ASSOCIATION RULES
#  -  first, e.g.  ref=trigger (e.g. science)
#  -  second, e.g.  f=file to associate (e.g. calibration)
def assoc_arc(ref, f):
    result = match(ref, f, [kwd.det_chips, kwd.det_binx, kwd.det_biny, kwd.ins_mode, kwd.grat1_wlen, kwd.grat2_wlen])

    if ref[kwd.slit2_wid]:
        if ref[kwd.slit2_wid] < 2.1:  # blue narrow slit
            return result and f[kwd.slit2_wid] == ref[kwd.slit2_wid]
        else:  # blue wide slit
            return result and f[kwd.slit2_wid] == 1

    if ref[kwd.slit3_wid]:
        if ref[kwd.slit3_wid] < 2.1:  # red narrow slit
            return result and f[kwd.slit3_wid] == ref[kwd.slit3_wid]
        else:  # red wide slit
            return result and f[kwd.slit3_wid] == 1

    return False
