from adari_core.data_libs.master_formatcheck import MasterFormatCheckReport
from adari_core.plots.text import TextPlot
from . import UvesReportMixin
import os
from .uves_util import UvesSetupInfo


class UvesFormatCheckReport(UvesReportMixin, MasterFormatCheckReport):
    def __init__(self):
        super().__init__("uves_formatcheck")

    def parse_sof(self):
        # building one report set
        line_guess_b = None
        line_guess_ru = None
        line_guess_rl = None

        arc_lamp_b = None
        arc_lamp_r = None

        for filename, catg in self.inputs:
            if catg == "LINE_GUESS_TAB_BLUE":
                line_guess_b = filename
            if catg == "LINE_GUESS_TAB_REDL":
                line_guess_rl = filename
            if catg == "LINE_GUESS_TAB_REDU":
                line_guess_ru = filename

            if catg == "ARC_LAMP_FORM_BLUE":
                arc_lamp_b = filename
            if catg == "ARC_LAMP_FORM_RED":
                arc_lamp_r = filename

            # FLAMES-UVES data
            if catg == "FIB_LIN_GUE_REDL":
                line_guess_rl = filename
            if catg == "FIB_LIN_GUE_REDU":
                line_guess_ru = filename
            if catg == "FIB_ARC_LAMP_FORM_RED":
                arc_lamp_r = filename

        # Build and return the (one) file name list
        file_lists = []
        if line_guess_b is not None and arc_lamp_b is not None:
            # for ext in ['WIN1','WIN2']:
            file_lists.append(
                {
                    "line_guess": line_guess_b,
                    "arc_lamp": arc_lamp_b,
                }
            )
        if line_guess_rl is not None and arc_lamp_r is not None:
            file_lists.append(
                {
                    "line_guess": line_guess_rl,
                    "arc_lamp": arc_lamp_r,
                }
            )
        if line_guess_ru is not None and arc_lamp_r is not None:
            file_lists.append(
                {
                    "line_guess": line_guess_ru,
                    "arc_lamp": arc_lamp_r,
                }
            )
        return file_lists

    def generate_panels(self, **kwargs):
        # Never get mixed red & blue runs - can check first element of self.hdus
        # to check which arm
        exts = []
        data_ext = []
        
        plot_params = {"ext": "LINE_GUESS_TAB", "mask_data":"SELPLOT", "mask":1, "pos_plot_x":"X", "pos_plot_y":"Order", "pos_plot_limits":"y", "xres_plot_x":"XPRED", "xres_plot_y":"XDIF", "yres_plot_x":"XPRED", "yres_plot_y":"YDIF", "fres_plot_x":"XDIF", "fres_plot_y":"YDIF",  "raw_cutX_vclip":"sigma", "raw_cutX_vclip_kwargs":{}, "raw_cutX":"x", "raw_hist_x":"X", "raw_hist_y":"YNEW", "overlay_x":"X", "overlay_y":"YNEW", "arc_yoffset":True}

        arm = UvesSetupInfo.get_arm_info(self.hdus[0]["arc_lamp"])
        for file_lists in self.hdus:
            if "BLUE" in arm and "625kHz" in file_lists["arc_lamp"]["PRIMARY"].header.get("HIERARCH ESO DET READ SPEED"):
                exts.append("PRIMARY")
                data_ext.append(["WIN1", "WIN2"])
                plot_params["raw_cutX_rot"] = -90.
                plot_params["raw_cutX_flip"] = None
            elif "RED" in arm:
                extchip1 = file_lists["line_guess"]["PRIMARY"].header.get("HIERARCH ESO DET CHIP1 ID")
                extchip2 = file_lists["line_guess"]["PRIMARY"].header.get("HIERARCH ESO DET CHIP2 ID")
                if extchip1 != None:
                    exts.append(extchip1)
                    data_ext.append([extchip1])
                elif extchip2 != None:
                    exts.append(extchip2)
                    data_ext.append([extchip2])
                
                plot_params["raw_cutX_rot"] = 270.
                plot_params["raw_cutX_flip"] = "y"
            else:
                exts.append("PRIMARY")
                data_ext.append(["PRIMARY"])
                plot_params["raw_cutX_rot"] = -90.
                plot_params["raw_cutX_flip"] = None
                
                
        
                
        new_panels = super().generate_panels(arc_lamp_ext=exts,data_ext=data_ext,plot_params=plot_params)
        
        
        
        
        for i, (panel, panel_descr) in enumerate(new_panels.items()):
        
            vspace = 0.3
            
            file_lists = self.hdus[i]
            mdata_hdul = file_lists["line_guess"]
            mdata_ext = "PRIMARY"
            extchip1 = file_lists["line_guess"]["PRIMARY"].header.get("HIERARCH ESO DET CHIP1 ID")
            extchip2 = file_lists["line_guess"]["PRIMARY"].header.get("HIERARCH ESO DET CHIP2 ID")
            if "BLUE" in arm:
                ext = "N/A"
            elif extchip1 != None:
                ext = str(extchip1)
            elif extchip2 != None:
                ext = str(extchip2)
            else:
                ext = "N/A"
            arm = UvesSetupInfo.get_arm_info(file_lists["line_guess"])
            # Text Plot
            if "LINE_GUESS" in arm:
                px = 0
                py = 0
                # which hdul and ext to use
                 
                t1 = TextPlot(columns=1, v_space=vspace)
                fname = os.path.basename(str(mdata_hdul.filename()))

                col1 = (
                    str(mdata_hdul[mdata_ext].header.get("INSTRUME")),
                    "EXTNAME: "
                    + ext,
                    "PRO CATG: "
                    + str(mdata_hdul[mdata_ext].header.get("HIERARCH ESO PRO CATG")
                    ),
                    "FILE NAME: " + fname,
                    "RAW1 NAME: "
                    + str(
                        mdata_hdul["PRIMARY"].header.get(
                            "HIERARCH ESO PRO REC1 RAW1 NAME"
                        )
                    ),
                )
                t1.add_data(col1)
                panel.assign_plot(t1, px, py, xext=2)

                t2 = TextPlot(columns=1, v_space=vspace, xext=1)
                hdr = mdata_hdul[mdata_ext].header
                g1 = "HIERARCH ESO INS GRAT1 NAME"
                g2 = "HIERARCH ESO INS GRAT2 NAME"
                w1 = "HIERARCH ESO INS GRAT1 WLEN"
                w2 = "HIERARCH ESO INS GRAT2 WLEN"
                col2 = (
                    "DET.WIN1.BINX: " + str(hdr.get("HIERARCH ESO DET WIN1 BINX")),
                    "DET.WIN1.BINY: " + str(hdr.get("HIERARCH ESO DET WIN1 BINY")),
                    "DET.READ.SPEED: " + str(hdr.get("HIERARCH ESO DET READ SPEED")),
                    "INS.MODE: " + str(hdr.get("HIERARCH ESO INS MODE")),
                    "INS.GRAT1.NAME: " + str(hdr.get(g1))
                    if g1 in hdr
                    else "INS.GRAT2.NAME: " + str(hdr.get(g2)),
                    "INS.GRAT1.WLEN: " + str(hdr.get(w1))
                    if g1 in hdr
                    else "INS.GRAT2.WLEN: " + str(hdr.get(w2)),
                )
                t2.add_data(col2)
                panel.assign_plot(t2, 2, 0, xext=1)
            else:
                vspace = 0.3
                t1 = TextPlot(columns=1, v_space=vspace)
                fname = os.path.basename(str(mdata_hdul.filename()))

                col1 = (
                    str(mdata_hdul[mdata_ext].header.get("INSTRUME")),
                    "EXTNAME: "
                    + ext,
                    "PRO CATG: "
                    + str(mdata_hdul[mdata_ext].header.get("HIERARCH ESO PRO CATG")
                    ),
                    "FILE NAME: " + fname,
                    "RAW1 NAME: "
                    + str(
                        mdata_hdul["PRIMARY"].header.get(
                            "HIERARCH ESO PRO REC1 RAW1 NAME"
                        )
                    ),
                )
                t1.add_data(col1)
                panel.assign_plot(t1, 0, 0, xext=2)

                t2 = TextPlot(columns=1, v_space=vspace, xext=1)
                hdr = mdata_hdul[mdata_ext].header
                g1 = "HIERARCH ESO INS GRAT1 NAME"
                g2 = "HIERARCH ESO INS GRAT2 NAME"
                w1 = "HIERARCH ESO INS GRAT1 WLEN"
                w2 = "HIERARCH ESO INS GRAT2 WLEN"
                col2 = (
                    "DET.WIN1.BINX: " + str(hdr.get("HIERARCH ESO DET WIN1 BINX")),
                    "DET.WIN1.BINY: " + str(hdr.get("HIERARCH ESO DET WIN1 BINY")),
                    "DET.READ.SPEED: " + str(hdr.get("HIERARCH ESO DET READ SPEED")),
                    "INS.SLIT3.PLATE: " + str(hdr.get("HIERARCH ESO INS SLIT3 PLATE")),
                    "INS.GRAT1.WLEN: " + str(hdr.get(w1))
                    if g1 in hdr
                    else "INS.GRAT2.WLEN: " + str(hdr.get(w2)),
                )
                t2.add_data(col2)
                panel.assign_plot(t2, 2, 0, xext=1)

        
            panel_descr["report_description"] = (
                f"UVES formatcheck panel - " f"{panel_descr['ext']}"
            )
            panel_descr["report_name"] = "UVES_" + panel_descr["report_name"]

        return new_panels


rep = UvesFormatCheckReport()
