from adari_core.plots.text import TextPlot
from adari_core.data_libs.master_raw_cuts import MasterRawCutsReport
from astropy.io import fits

import os

from . import UvesReportMixin

center_size = 200


class UvesMasterDarkReport(UvesReportMixin, MasterRawCutsReport):
    def __init__(self):
        super().__init__("uves_master_dark")
        self.center_size = center_size

    def parse_sof(self):
        # Need to generate two report sets:
        # MASTER_DARK
        master_dark_b = None
        master_dark_rl = None
        master_dark_ru = None

        for filename, catg in self.inputs:
            if catg == "MASTER_DARK_BLUE" and master_dark_b is None:
                master_dark_b = filename
            elif catg == "MASTER_PDARK_BLUE" and master_dark_b is None:
                master_dark_b = filename
            elif catg == "MASTER_DARK_REDL" and master_dark_rl is None:
                master_dark_rl = filename
            elif catg == "MASTER_DARK_REDU" and master_dark_ru is None:
                master_dark_ru = filename
            elif catg == "MASTER_PDARK_REDL" and master_dark_rl is None:
                master_dark_rl = filename
            elif catg == "MASTER_PDARK_REDU" and master_dark_ru is None:
                master_dark_ru = filename

        # Build and return the file name list
        file_lists = []
        if master_dark_b is not None:
            file_lists.append(
                {
                    "master_im": master_dark_b,
                }
            )
        if master_dark_rl is not None:
            file_lists.append(
                {
                    "master_im": master_dark_rl,
                }
            )
        if master_dark_ru is not None:
            file_lists.append(
                {
                    "master_im": master_dark_ru,
                }
            )
        return file_lists

    def generate_panels(self, **kwargs):
        panels = {}
        # Never get mixed red & blue runs - can check first element of self.hdus
        # to check which arm
        if len(self.hdus[0]["master_im"]) == 1:  # Blue raw bias is single ext
            exts = ["PRIMARY"]
        elif len(self.hdus[0]["master_im"]) == 3:  # Red raw has one prim, two data exts
            exts = ["CCD-20", "CCD-44"]
        else:
            raise RuntimeError(
                f"Unexpected UVES raw bias structure "
                f"({len(self.hdus[0]['raw_im'])} exts)"
            )

        for ext in exts:
            new_panels = super().generate_panels(
                master_im_ext=ext, master_title="Master dark"
            )
            for i, (panel, panel_descr) in enumerate(new_panels.items()):
                panel_descr["report_description"] = (
                    f"UVES dark panel - "
                    f"{os.path.basename(panel_descr['master_im'])}, "
                    f"{panel_descr['master_im_ext']}"
                )

                master_im = fits.open(panel_descr["master_im"])

                # Text Plot
                px = 0
                py = 0
                # which hdul and ext to use
                vspace = 0.3
                fname = os.path.basename(str(master_im.filename()))
                t1 = TextPlot(columns=1, v_space=vspace)

                col1 = (
                    str(master_im["PRIMARY"].header.get("INSTRUME")),
                    "EXTNAME: " + str(master_im[0].header.get("EXTNAME", "N/A")),
                    "PRO CATG: "
                    + str(master_im["PRIMARY"].header.get("HIERARCH ESO PRO CATG")),
                    "FILE NAME: " + fname,
                    "RAW1 NAME: "
                    + str(
                        master_im["PRIMARY"].header.get(
                            "HIERARCH ESO PRO REC1 RAW1 NAME"
                        )
                    ),
                )
                t1.add_data(col1)

                panel.assign_plot(t1, px, py, xext=2)

                px = px + 2
                t2 = TextPlot(columns=1, v_space=vspace, xext=1)
                col2 = (
                    "DET.WIN1.BINX: "
                    + str(
                        master_im["PRIMARY"].header.get("HIERARCH ESO DET WIN1 BINX")
                    ),
                    "DET.WIN1.BINY: "
                    + str(
                        master_im["PRIMARY"].header.get("HIERARCH ESO DET WIN1 BINY")
                    ),
                    "DET.READ.SPEED: "
                    + str(
                        master_im["PRIMARY"].header.get("HIERARCH ESO DET READ SPEED")
                    ),
                )
                t2.add_data(col2)
                panel.assign_plot(t2, px, py, xext=1)

            panels = {**panels, **new_panels}

        return panels


rep = UvesMasterDarkReport()
