from adari_core.plots.points import ScatterPlot
from adari_core.plots.text import TextPlot
from adari_core.data_libs.master_std_star_echelle import MasterSpecphotStdReport

import os
import numpy as np

from . import UvesReportMixin
from .uves_util import UvesSetupInfo


class UvesSpecphotStdReport(UvesReportMixin, MasterSpecphotStdReport):
    def __init__(self):
        super().__init__("uves_specphot_std")

    def parse_sof(self):
        # building one report set
        eff_b = None
        eff_rl = None
        eff_ru = None

        red_std_b = None
        red_std_rl = None
        red_std_ru = None

        raw = None
        raw_r = None

        res = None
        res_rl = None
        res_ru = None

        for filename, catg in self.inputs:
            if catg == "EFFICIENCY_TABLE_BLUE":
                eff_b = filename
            if catg == "RED_STD_BLUE":
                red_std_b = filename
            if catg == "STANDARD_BLUE":
                raw = filename
            if catg == "INSTR_RESPONSE_FINE_BLUE":
                res = filename

            if catg == "EFFICIENCY_TABLE_REDL":
                eff_rl = filename
            if catg == "RED_STD_REDL":
                red_std_rl = filename
            if catg == "STANDARD_RED":
                raw_r = filename
            if catg == "INSTR_RESPONSE_FINE_REDL":
                res_rl = filename

            if catg == "EFFICIENCY_TABLE_REDU":
                eff_ru = filename
            if catg == "RED_STD_REDU":
                red_std_ru = filename
            if catg == "STANDARD_RED":
                raw_r = filename
            if catg == "INSTR_RESPONSE_FINE_REDU":
                res_ru = filename
        # Build and return the (one) file name list
        file_lists = []
        if eff_b is not None and raw is not None:
            file_lists.append(
                {
                    "eff": eff_b,
                    "raw": raw,
                    "res": res,
                    "std": red_std_b,
                }
            )
        if eff_rl is not None and raw_r is not None:
            file_lists.append(
                {
                    "eff": eff_rl,
                    "raw": raw_r,
                    "res": res_rl,
                    "std": red_std_rl,
                }
            )

        if eff_ru is not None and raw_r is not None:
            file_lists.append(
                {
                    "eff": eff_ru,
                    "raw": raw_r,
                    "res": res_ru,
                    "std": red_std_ru,
                }
            )
        return file_lists

    def generate_panels(self, **kwargs):
        vspace = 0.5
    
        exts = []
        if len(self.hdus[0]["raw"]) == 1:  # Blue raw bias is single ext
            exts.append(("PRIMARY",))
        else:
            for file_lists in self.hdus:
                arm = UvesSetupInfo.get_arm_info(file_lists["eff"])
                if "REDL" in arm:
                  # Red raw has one prim, two data exts
                    exts.append(("CCD-44",))
                else:  # if REDL is not there other red ext has to be REDU
                    exts.append(("CCD-20",))

        new_panels = super().generate_panels(ext=exts,raw_im_ext=exts,flux_ext=0,raw_cut_centre=False,flux_ylim="median")
        for i, (panel, panel_descr) in enumerate(new_panels.items()):
            file_lists = self.hdus[i]
                    
            eff_b = file_lists["eff"]
            res = file_lists["res"]
            raw_im = file_lists["raw"]
            
            raw_im_ext = exts[i][0]

            # Text Plot
            g1 = "HIERARCH ESO INS GRAT1 NAME"
            g2 = "HIERARCH ESO INS GRAT2 NAME"
            w1 = "HIERARCH ESO INS GRAT1 WLEN"
            w2 = "HIERARCH ESO INS GRAT2 WLEN"
            hdr = eff_b["PRIMARY"].header
            t1 = TextPlot(columns=1, v_space=vspace)
            fname = os.path.basename(str(eff_b.filename()))
            col1 = (
                str(eff_b["PRIMARY"].header.get("INSTRUME")),
                "EXTNAME: " + str(raw_im[raw_im_ext].header.get("EXTNAME", "N/A")),
                "PRO CATG: "
                + str(eff_b["PRIMARY"].header.get("HIERARCH ESO PRO CATG")),
                "FILE NAME: " + fname,
                "RAW1 NAME: "
                + str(eff_b["PRIMARY"].header.get("HIERARCH ESO PRO REC1 RAW1 NAME")),
            )
            t1.add_data(col1)
            panel.assign_plot(t1, 0, 0, xext=2)

            t2 = TextPlot(columns=1, v_space=vspace, xext=1)
            col2 = (
                "INS.MODE: "
                + str(eff_b["PRIMARY"].header.get("HIERARCH ESO INS MODE")),
                "DET.BINX: "
                + str(eff_b["PRIMARY"].header.get("HIERARCH ESO DET WIN1 BINX")),
                "DET.BINY: "
                + str(eff_b["PRIMARY"].header.get("HIERARCH ESO DET WIN1 BINY")),
                "DET.READ.SPEED: "
                + str(eff_b["PRIMARY"].header.get("HIERARCH ESO DET READ SPEED")),
                "INS.GRAT1.NAME: " + str(hdr.get(g1))
                if g1 in hdr
                else "INS.GRAT2.NAME: " + str(hdr.get(g2)),
                "INS.GRAT1.WELN: " + str(hdr.get(w1))
                if w1 in hdr
                else "INS.GRAT2.WELN: " + str(hdr.get(w2)),
                "OBS.TARG.NAME: "
                + str(eff_b["PRIMARY"].header.get("HIERARCH ESO OBS TARG NAME")),
            )
            t2.add_data(col2)
            panel.assign_plot(t2, 2, 0, xext=1)

            # UVES specific panel
            # Response vs. wavelength
            res_v_wavl = ScatterPlot(
                title="Response vs. wavelength", markersize=0.5, y_min=0
            )
            res_v_wavl.add_data(
                [res[2].data["Wavelength"], res[2].data["response_raw"]],
                label="response_raw",
                color="red",
            )
            res_v_wavl.add_data(
                [res[1].data["Wavelength"], res[1].data["response_smo"]],
                label="response_smo",
                color="black",
            )
            ymin = 0
            ymax = np.nanmax(res[1].data["response_smo"]) * 1.5
            res_v_wavl.set_ylim(ymin, ymax)
            res_v_wavl.x_label = "Wavelength (Angstrom)"
            res_v_wavl.y_label = "Response"
            panel.assign_plot(res_v_wavl, 0, 3, xext=2)

            panel.link_plots_in_x((0, 1), (0, 2))

        return new_panels

rep = UvesSpecphotStdReport()
