from edps import QC1_CALIB, CALCHECKER, SCIENCE, QC0
from edps import task, subworkflow

from .uves_datasources import *
from .uves_job_processing import *


@subworkflow("science", "")
def uves_science_slit(bias_calibrations_for_science, orderpos_calibrations,
                      flat_calibrations, flat_for_science, arc_calibrations_for_science,
                      response_calibrations):
    # Task to reduce long slit reflected solar spectra (e.g. moon observations)
    solar_slit = (task("solar")
                  .with_recipe("uves_obs_scired")
                  .with_main_input(raw_solar)
                  .with_alternative_associated_inputs(bias_calibrations_for_science)
                  .with_alternative_associated_inputs(orderpos_calibrations)
                  .with_alternative_associated_inputs(flat_calibrations)
                  .with_alternative_associated_inputs(arc_calibrations_for_science)
                  .with_associated_input(master_response_blue, condition=use_master_response_blue, min_ret=0)
                  .with_associated_input(master_response_redu, condition=use_master_response_red, min_ret=0)
                  .with_associated_input(master_response_redl, condition=use_master_response_red, min_ret=0)
                  .with_dynamic_parameter("arm_used", which_arm)
                  .with_job_processing(object_type)
                  .with_input_filter(MASTER_BIAS_REDL, MASTER_BIAS_REDU, MASTER_BIAS_BLUE,
                                     ORDER_TABLE_REDL, ORDER_TABLE_REDU, ORDER_TABLE_BLUE,
                                     MASTER_FLAT_REDL, MASTER_FLAT_REDU, MASTER_FLAT_BLUE,
                                     LINE_TABLE_REDL, LINE_TABLE_REDU, LINE_TABLE_BLUE,
                                     master_response_redu_class, master_response_redl_class,
                                     master_response_blue_class)
                  .with_meta_targets([QC0, QC1_CALIB, CALCHECKER])
                  .build())

    # Task to reduce long slit observations
    science_slit = (task("object")
                    .with_recipe("uves_obs_scired")
                    .with_main_input(raw_science)
                    .with_alternative_associated_inputs(bias_calibrations_for_science)
                    .with_alternative_associated_inputs(orderpos_calibrations)
                    .with_alternative_associated_inputs(flat_for_science)
                    .with_alternative_associated_inputs(arc_calibrations_for_science)
                    .with_alternative_associated_inputs(response_calibrations)
                    .with_associated_input(master_response_blue, condition=use_master_response_blue, min_ret=0)
                    .with_associated_input(master_response_redu, condition=use_master_response_red, min_ret=0)
                    .with_associated_input(master_response_redl, condition=use_master_response_red, min_ret=0)
                    .with_associated_input(extcoeff_table, min_ret=0)
                    .with_associated_input(flux_std_table, min_ret=0, condition=use_night_response)
                    .with_dynamic_parameter("arm_used", which_arm)
                    .with_dynamic_parameter("lamp_used", which_lamp)
                    .with_job_processing(object_type)  # set recipe params depending on target (extended or point-like)
                    .with_meta_targets([SCIENCE, QC0, CALCHECKER])
                    .build())

    return science_slit, solar_slit
